/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.util;

import com.sun.org.apache.xerces.internal.impl.dv.util.HexBin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class StringUtils {
    private static final Log log = ExoLogger.getExoLogger(StringUtils.class);

    public static String encodeToHex(String string) {
        return new String(HexBin.encode(string.getBytes()));
    }

    public static String decodeFromHex(String hexstring) {
        try {
            return new String(HexBin.decode(hexstring));
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception when decode from hexa string", (Throwable)e);
            }
            return null;
        }
    }

    public static String getUsernameFromJID(String jid) {
        if (jid.contains("@")) {
            return jid.split("@")[0];
        }
        return jid;
    }

    public static String getRealJid(String jid) {
        if (jid.contains("/")) {
            return jid.split("/")[0];
        }
        return jid;
    }

    public static String parseBareAddress(String XMPPAddress) {
        if (XMPPAddress == null) {
            return null;
        }
        int slashIndex = XMPPAddress.indexOf("/");
        if (slashIndex < 0) {
            return XMPPAddress;
        }
        if (slashIndex == 0) {
            return "";
        }
        return XMPPAddress.substring(0, slashIndex);
    }
}

