/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service.bench;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import org.exoplatform.contact.service.AddressBook;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactAttachment;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactDataInjector
extends DataInjector {
    private static Log log = ExoLogger.getExoLogger(ContactDataInjector.class);
    private static String markedAddrBookId = "MarkedAddressBook123456789";
    private ContactService contactService;
    private int maxAddressBooks = 5;
    private int maxContacts = 10;
    private boolean randomize = false;
    private Random rand = new Random();
    private Stack<String> catsStack = new Stack();

    public ContactDataInjector(ContactService contactService, InitParams initParams) {
        this.contactService = contactService;
        this.initParams(initParams);
    }

    private AddressBook newAddressBook() {
        AddressBook addressBook = new AddressBook();
        addressBook.setName(this.randomWords(5));
        addressBook.setDescription(this.randomParagraphs(5));
        return addressBook;
    }

    private Contact newContact() {
        Contact contact = new Contact();
        contact.setFirstName(this.randomWords(1));
        contact.setLastName(this.randomWords(1));
        contact.setNote(this.randomParagraphs(3));
        contact.setHomeAddress(this.randomWords(5));
        contact.setEmailAddress("fake@example.com");
        ContactAttachment attachment = new ContactAttachment();
        attachment.setId("attachment" + IdGenerator.generate());
        return contact;
    }

    private int addressBookSize() {
        if (this.randomize) {
            return this.rand.nextInt(this.maxAddressBooks);
        }
        return this.maxAddressBooks;
    }

    private int contactsSize() {
        if (this.randomize) {
            return this.rand.nextInt(this.maxContacts);
        }
        return this.maxContacts;
    }

    private List<AddressBook> generateAddressBooks() {
        ArrayList<AddressBook> addressBooks = new ArrayList<AddressBook>();
        for (int i = 1; i < this.addressBookSize(); ++i) {
            addressBooks.add(this.newAddressBook());
        }
        return addressBooks;
    }

    private List<Contact> generateContacts() {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        for (int i = 0; i < this.contactsSize(); ++i) {
            contacts.add(this.newContact());
        }
        return contacts;
    }

    public Log getLog() {
        return log;
    }

    public boolean isInitialized() {
        return false;
    }

    public void initParams(InitParams initParams) {
        ValueParam param = initParams.getValueParam("mA");
        if (param != null) {
            this.maxAddressBooks = Integer.parseInt(param.getValue());
        }
        if ((param = initParams.getValueParam("mC")) != null) {
            this.maxContacts = Integer.parseInt(param.getValue());
        }
        if ((param = initParams.getValueParam("rand")) != null) {
            this.randomize = Boolean.parseBoolean(param.getValue());
        }
    }

    public void inject() throws Exception {
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        this.catsStack.clear();
        List<AddressBook> addressBooks = this.generateAddressBooks();
        for (int i = 0; i < addressBooks.size(); ++i) {
            AddressBook ab = addressBooks.get(i);
            log.info((Object)String.format("\tCreate Address Book " + (i + 1) + "/" + addressBooks.size() + " .......... ", new Object[0]));
            this.contactService.saveAddressBook(userId, ab, true);
            this.catsStack.push(ab.getId());
            List<Contact> contacts = this.generateContacts();
            int contactSize = contacts.size();
            for (int j = 0; j < contactSize; ++j) {
                Contact c = contacts.get(j);
                c.setAddressBook(new String[]{ab.getId()});
                this.contactService.saveContact(userId, c, true);
                log.info((Object)("\t\t Adding Contact " + (j + 1) + "/" + contactSize + " to the address book"));
            }
        }
    }

    public void reject() throws Exception {
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        while (!this.catsStack.isEmpty()) {
            this.contactService.removeAddressBook(userId, this.catsStack.pop());
        }
    }
}

