/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.exoplatform.contact.ContactUtils;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.contact.service.impl.JCRDataStorage;
import org.exoplatform.contact.webui.popup.UIExportAddressBookForm;
import org.exoplatform.contact.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/contact/webui/popup/UIExportAddressBookForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIExportAddressBookForm
extends UIForm
implements UIPopupComponent {
    private static final String NAME = "fileName".intern();
    private static final String TYPE = "type".intern();
    private Map<String, String> privateGroupMap_ = new HashMap();
    private Map<String, String> publicGroupMap_ = new HashMap();
    private Map<String, SharedAddressBook> sharedGroupMap_ = new HashMap();

    public String getLabel(String id) throws Exception {
        try {
            return super.getLabel(id);
        }
        catch (MissingResourceException mre) {
            return id;
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public Map<String, String> getContactGroups() {
        return this.privateGroupMap_;
    }

    public void setContactGroups(Map<String, String> contactGroups) {
        this.privateGroupMap_ = contactGroups;
    }

    public Map<String, SharedAddressBook> getSharedContactGroups() {
        return this.sharedGroupMap_;
    }

    public void setSharedContactGroups(Map<String, SharedAddressBook> contactGroups) {
        this.sharedGroupMap_ = contactGroups;
    }

    public Map<String, String> getPublicContactGroup() {
        return this.publicGroupMap_;
    }

    public void setPublicContactGroup(Map<String, String> groups) {
        this.publicGroupMap_ = groups;
    }

    public void updateList() throws Exception {
        this.getChildren().clear();
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        for (String type : ContactUtils.getContactService().getImportExportType()) {
            options.add(new SelectItemOption(type, (Object)type));
        }
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NAME, NAME, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(TYPE, TYPE, options));
        for (String group : this.privateGroupMap_.keySet()) {
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(group, (String)this.privateGroupMap_.get(group), (Object)false));
        }
        for (String group : this.publicGroupMap_.keySet()) {
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(group, group, (Object)false));
        }
        for (String group : this.sharedGroupMap_.keySet()) {
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(group, ((SharedAddressBook)this.sharedGroupMap_.get(group)).getName(), (Object)false));
        }
    }

    public List<String> getCheckedGroups() throws Exception {
        UIFormCheckBoxInput uiCheckBox;
        ArrayList<String> checked = new ArrayList<String>();
        for (String group : this.privateGroupMap_.keySet()) {
            uiCheckBox = (UIFormCheckBoxInput)this.getChildById(group);
            if (uiCheckBox == null || !uiCheckBox.isChecked()) continue;
            checked.add(group);
        }
        for (String group : this.sharedGroupMap_.keySet()) {
            uiCheckBox = (UIFormCheckBoxInput)this.getChildById(group);
            if (uiCheckBox == null || !uiCheckBox.isChecked()) continue;
            checked.add(group + JCRDataStorage.HYPHEN + ((SharedAddressBook)this.sharedGroupMap_.get(group)).getSharedUserId());
        }
        for (String group : this.publicGroupMap_.keySet()) {
            uiCheckBox = (UIFormCheckBoxInput)this.getChildById(group);
            if (uiCheckBox == null || !uiCheckBox.isChecked()) continue;
            checked.add(group);
        }
        return checked;
    }

    static /* synthetic */ String access$000() {
        return TYPE;
    }

    static /* synthetic */ String access$100() {
        return NAME;
    }
}

