/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.exoplatform.contact.ContactUtils;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.webui.popup.UIImportForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormUploadInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={AddCategoryActionListener.class}, phase=Event.Phase.DECODE)})
public class UIImportForm
extends UIForm {
    public static final String FIELD_UPLOAD = "upload".intern();
    public static final String FIELD_TYPE = "type".intern();
    public static final String INPUT_CATEGORY = "categoryInput";
    public static final String FIELD_CATEGORY = "category";
    private String[] Types = null;
    private Map<String, String> groups_ = new HashMap();

    public UIImportForm() {
        this.setMultiPart(true);
    }

    public void addConponent() throws Exception {
        UIFormInputWithActions input = new UIFormInputWithActions(INPUT_CATEGORY);
        input.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_CATEGORY, FIELD_CATEGORY, this.getCategoryList()));
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData addAction = new UIFormInputWithActions.ActionData();
        addAction.setActionType(0);
        addAction.setActionListener("AddCategory");
        addAction.setActionName("AddCategory");
        actions.add(addAction);
        input.setActionField(FIELD_CATEGORY, actions);
        this.addUIFormInput((UIFormInputSet)input);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        ContactService contactService = ContactUtils.getContactService();
        for (String type : this.Types = contactService.getImportExportType()) {
            options.add(new SelectItemOption(type, (Object)type));
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_TYPE, FIELD_TYPE, options));
        UIFormUploadInput formUploadInput = new UIFormUploadInput(FIELD_UPLOAD, FIELD_UPLOAD);
        this.addUIFormInput((UIFormInput)formUploadInput);
    }

    public String getLabel(String id) throws Exception {
        try {
            return super.getLabel(id);
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public List<SelectItemOption<String>> getCategoryList() throws Exception {
        ArrayList<SelectItemOption<String>> categories = new ArrayList<SelectItemOption<String>>();
        for (String group : this.groups_.keySet()) {
            categories.add((SelectItemOption<String>)new SelectItemOption((String)this.groups_.get(group), (Object)group));
        }
        return categories;
    }

    public void setGroup(Map<String, String> groups) {
        this.groups_ = groups;
    }

    public void setCategoryList(List<SelectItemOption<String>> options) {
        UIFormInputWithActions iput = (UIFormInputWithActions)this.getChildById(INPUT_CATEGORY);
        iput.getUIFormSelectBox(FIELD_CATEGORY).setOptions(options);
    }

    public void setValues(String group) {
        this.getUIFormSelectBox(FIELD_CATEGORY).setValue(group);
    }
}

