/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui.popup;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.webui.popup.UIPopupComponent;
import org.exoplatform.contact.webui.popup.UISelectComponent;
import org.exoplatform.contact.webui.popup.UISelector;
import org.exoplatform.contact.webui.popup.UISharedContactsForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SelectPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UISharedContactsForm
extends UIForm
implements UIPopupComponent,
UISelector {
    public static final String FIELD_CONTACT = "contactName".intern();
    public static final String FIELD_USER = "user".intern();
    public static final String FIELD_GROUP = "group".intern();
    public static final String FIELD_EDIT_PERMISSION = "canEdit".intern();
    private Map<String, String> permissionUser_ = new LinkedHashMap();
    private Map<String, String> permissionGroup_ = new LinkedHashMap();
    private Map<String, Contact> sharedContacts = new LinkedHashMap();

    public void init(Map<String, Contact> contacts) throws Exception {
        UIFormInputWithActions inputset = new UIFormInputWithActions("UIInputUserSelect");
        this.sharedContacts = contacts;
        StringBuffer buffer = new StringBuffer();
        for (Contact contact : contacts.values()) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(contact.getFullName());
        }
        UIFormInputInfo inputInfo = new UIFormInputInfo(FIELD_CONTACT, FIELD_CONTACT, null);
        inputInfo.setValue((Object)buffer.toString());
        inputset.addChild((UIComponent)inputInfo);
        inputset.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_USER, FIELD_USER, null));
        ArrayList<UIFormInputWithActions.ActionData> actionUser = new ArrayList<UIFormInputWithActions.ActionData>();
        actionUser = new ArrayList();
        UIFormInputWithActions.ActionData selectUserAction = new UIFormInputWithActions.ActionData();
        selectUserAction.setActionListener("SelectPermission");
        selectUserAction.setActionName("SelectUser");
        selectUserAction.setActionType(0);
        selectUserAction.setCssIconClass("SelectUserIcon");
        selectUserAction.setActionParameter(UISelectComponent.TYPE_USER);
        actionUser.add(selectUserAction);
        inputset.setActionField(FIELD_USER, actionUser);
        UIFormStringInput group = new UIFormStringInput(FIELD_GROUP, FIELD_GROUP, null);
        group.setEditable(false);
        inputset.addUIFormInput((UIFormInput)group);
        ArrayList<UIFormInputWithActions.ActionData> actionGroup = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData selectGroupAction = new UIFormInputWithActions.ActionData();
        selectGroupAction.setActionListener("SelectPermission");
        selectGroupAction.setActionName("SelectGroup");
        selectGroupAction.setActionType(0);
        selectGroupAction.setCssIconClass("SelectGroupIcon");
        selectGroupAction.setActionParameter(UISelectComponent.TYPE_GROUP);
        actionGroup.add(selectGroupAction);
        inputset.setActionField(FIELD_GROUP, actionGroup);
        inputset.addChild((UIComponent)new UIFormCheckBoxInput(FIELD_EDIT_PERMISSION, FIELD_EDIT_PERMISSION, null));
        this.addChild((UIComponent)inputset);
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void updateSelect(String selectField, String value) throws Exception {
        Map permission;
        UIFormStringInput fieldInput = this.getUIStringInput(selectField);
        if (selectField.equals(FIELD_USER)) {
            this.permissionUser_.put(value, value);
            permission = this.permissionUser_;
        } else {
            this.permissionGroup_.put(value, value);
            permission = this.permissionGroup_;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : permission.values()) {
            if (sb != null && sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        fieldInput.setValue((Object)sb.toString());
    }

    static /* synthetic */ Map access$000(UISharedContactsForm x0) {
        return x0.sharedContacts;
    }
}

