/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui.popup;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.contact.ContactUtils;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactGroup;
import org.exoplatform.contact.webui.popup.UIPopupComponent;
import org.exoplatform.contact.webui.popup.UISelectComponent;
import org.exoplatform.contact.webui.popup.UISelector;
import org.exoplatform.contact.webui.popup.UISharedForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SelectPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UISharedForm
extends UIForm
implements UIPopupComponent,
UISelector {
    public static final String FIELD_ADDRESS = "addressName".intern();
    public static final String FIELD_CONTACT = "contactName".intern();
    public static final String FIELD_USER = "user".intern();
    public static final String FIELD_GROUP = "group".intern();
    public static final String FIELD_EDIT_PERMISSION = "canEdit".intern();
    private Map<String, String> permissionUser_ = new LinkedHashMap();
    private Map<String, String> permissionGroup_ = new LinkedHashMap();
    private ContactGroup group_ = null;
    private Contact contact_ = null;
    private boolean isSharedGroup;
    private boolean isNew_ = true;

    public void setContact(Contact contact) {
        this.isSharedGroup = false;
        this.contact_ = contact;
    }

    public void setGroup(ContactGroup group) {
        this.isSharedGroup = true;
        this.group_ = group;
    }

    public void setNew(boolean isNew) {
        this.isNew_ = isNew;
    }

    public boolean isNew() {
        return this.isNew_;
    }

    public void init() throws Exception {
        UIFormInputInfo formInputInfo;
        UIFormInputWithActions inputset = new UIFormInputWithActions("UIInputUserSelect");
        if (this.isSharedGroup) {
            formInputInfo = new UIFormInputInfo(FIELD_ADDRESS, FIELD_ADDRESS, null);
            formInputInfo.setValue((Object)this.group_.getName());
            inputset.addChild((UIComponent)formInputInfo);
        } else {
            formInputInfo = new UIFormInputInfo(FIELD_CONTACT, FIELD_CONTACT, null);
            formInputInfo.setValue((Object)this.contact_.getFullName());
            inputset.addChild((UIComponent)formInputInfo);
        }
        this.addChild((UIComponent)inputset);
        inputset.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_USER, FIELD_USER, null));
        ArrayList<UIFormInputWithActions.ActionData> actionUser = new ArrayList<UIFormInputWithActions.ActionData>();
        actionUser = new ArrayList();
        UIFormInputWithActions.ActionData selectUserAction = new UIFormInputWithActions.ActionData();
        selectUserAction.setActionListener("SelectPermission");
        selectUserAction.setActionName("SelectUser");
        selectUserAction.setActionType(0);
        selectUserAction.setCssIconClass("SelectUserIcon");
        selectUserAction.setActionParameter(UISelectComponent.TYPE_USER);
        actionUser.add(selectUserAction);
        inputset.setActionField(FIELD_USER, actionUser);
        UIFormStringInput groupField = new UIFormStringInput(FIELD_GROUP, FIELD_GROUP, null);
        groupField.setEditable(false);
        inputset.addUIFormInput((UIFormInput)groupField);
        ArrayList<UIFormInputWithActions.ActionData> actionGroup = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData selectGroupAction = new UIFormInputWithActions.ActionData();
        selectGroupAction.setActionListener("SelectPermission");
        selectGroupAction.setActionName("SelectGroup");
        selectGroupAction.setActionType(0);
        selectGroupAction.setCssIconClass("SelectGroupIcon");
        selectGroupAction.setActionParameter(UISelectComponent.TYPE_GROUP);
        actionGroup.add(selectGroupAction);
        inputset.setActionField(FIELD_GROUP, actionGroup);
        inputset.addChild((UIComponent)new UIFormCheckBoxInput(FIELD_EDIT_PERMISSION, FIELD_EDIT_PERMISSION, null));
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void updateSelect(String selectField, String value) throws Exception {
        Map permission;
        UIFormStringInput fieldInput = this.getUIStringInput(selectField);
        if (selectField.equals(FIELD_USER)) {
            if (!ContactUtils.isEmpty((String)((String)fieldInput.getValue()))) {
                for (String user : ((String)fieldInput.getValue()).split(",")) {
                    this.permissionUser_.put(user.trim(), user.trim());
                }
            }
            this.permissionUser_.put(value, value);
            permission = this.permissionUser_;
        } else {
            this.permissionGroup_.put(value, value);
            permission = this.permissionGroup_;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : permission.values()) {
            if (sb != null && sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        fieldInput.setValue((Object)sb.toString());
    }

    static /* synthetic */ boolean access$000(UISharedForm x0) {
        return x0.isSharedGroup;
    }

    static /* synthetic */ ContactGroup access$100(UISharedForm x0) {
        return x0.group_;
    }

    static /* synthetic */ boolean access$200(UISharedForm x0) {
        return x0.isNew_;
    }

    static /* synthetic */ Contact access$300(UISharedForm x0) {
        return x0.contact_;
    }

    static /* synthetic */ Map access$400(UISharedForm x0) {
        return x0.permissionUser_;
    }

    static /* synthetic */ Map access$500(UISharedForm x0) {
        return x0.permissionGroup_;
    }

    static /* synthetic */ boolean access$202(UISharedForm x0, boolean x1) {
        x0.isNew_ = x1;
        return x0.isNew_;
    }
}

