/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui.popup;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.contact.ContactUtils;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.Utils;
import org.exoplatform.contact.webui.popup.UIComposeForm;
import org.exoplatform.contact.webui.popup.UIPopupComponent;
import org.exoplatform.mail.service.Account;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.UIFormWYSIWYGInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/contact/webui/popup/UIComposeForm.gtmpl", events={@EventConfig(listeners={SendActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={DiscardChangeActionListener.class}), @EventConfig(listeners={AttachmentActionListener.class}), @EventConfig(listeners={DownloadActionListener.class}), @EventConfig(listeners={RemoveAttachmentActionListener.class})})
public class UIComposeForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_FROM_INPUT = "fromInput";
    public static final String FIELD_FROM = "from";
    public static final String FIELD_SUBJECT = "subject";
    public static final String FIELD_TO = "to";
    public static final String FIELD_ATTACHMENTS = "attachments";
    public static final String FIELD_MESSAGECONTENT = "messageContent";
    public static final String ACT_TO = "To";
    public static final String ACT_REMOVE = "remove";
    public static final int MESSAGE_NEW = 0;
    private Map<String, String> fromOptions = new LinkedHashMap();
    private Boolean isVisualEditor = true;
    private int composeType_;
    public List<Contact> toContacts = new ArrayList();
    private boolean isCSMail = false;

    public boolean isVisualEditor() {
        return this.isVisualEditor;
    }

    public void setVisualEditor(boolean b) {
        this.isVisualEditor = b;
    }

    public List<Contact> getToContacts() {
        return this.toContacts;
    }

    public void setToContacts(List<Contact> contactList) {
        this.toContacts = contactList;
    }

    public int getComposeType() {
        return this.composeType_;
    }

    public void setComposeType(int t) {
        this.composeType_ = t;
    }

    public List<UIFormInputWithActions.ActionData> getUploadFileList() {
        return null;
    }

    public void refreshUploadFileList() throws Exception {
        UIFormInputWithActions inputSet = (UIFormInputWithActions)this.getChildById(FIELD_FROM_INPUT);
        inputSet.setActionField(FIELD_ATTACHMENTS, this.getUploadFileList());
    }

    public void init(List<Account> accs, String toEmails) throws Exception {
        this.fromOptions.clear();
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        if (accs != null && accs.size() > 0) {
            this.isCSMail = true;
            for (Account acc : accs) {
                String fromEmail = acc.getUserDisplayName() + " &lt;" + acc.getEmailAddress() + "&gt;";
                options.add(new SelectItemOption(fromEmail, (Object)fromEmail));
                this.fromOptions.put(acc.getId(), acc.getUserDisplayName() + " <" + acc.getEmailAddress() + ">");
            }
        } else {
            this.isCSMail = false;
            String email = "";
            String name = "";
            String userName = ContactUtils.getCurrentUser();
            if (!ContactUtils.isEmpty((String)userName)) {
                name = ContactUtils.getFullName((String)userName);
                email = ContactUtils.getEmailUser((String)userName);
            }
            String fromEmail = name + " &lt;" + email + "&gt;";
            options.add(new SelectItemOption(fromEmail, (Object)fromEmail));
            this.fromOptions.put(userName, name + " <" + email + ">");
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_FROM, FIELD_FROM, options));
        UIFormStringInput fieldTo = new UIFormStringInput(FIELD_TO, null, null);
        fieldTo.setValue((Object)toEmails.replaceAll(Utils.SEMI_COLON, ","));
        this.addUIFormInput((UIFormInput)fieldTo);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_SUBJECT, null, null));
        UIFormInputWithActions inputSet = new UIFormInputWithActions(FIELD_FROM_INPUT);
        inputSet.addUIFormInput((UIFormInput)new UIFormInputInfo(FIELD_ATTACHMENTS, FIELD_ATTACHMENTS, null));
        inputSet.setActionField(FIELD_ATTACHMENTS, this.getUploadFileList());
        this.addUIFormInput((UIFormInputSet)inputSet);
        this.isVisualEditor = true;
        if (this.isVisualEditor.booleanValue()) {
            this.addUIFormInput((UIFormInput)new UIFormWYSIWYGInput(FIELD_MESSAGECONTENT, null, null, true));
        } else {
            this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_MESSAGECONTENT, null, null));
        }
    }

    public String getFieldFromValue() {
        return (String)this.getUIFormSelectBox(FIELD_FROM).getValue();
    }

    public String getFieldSubjectValue() {
        String subject = (String)this.getUIStringInput(FIELD_SUBJECT).getValue();
        if (subject != null) {
            return subject;
        }
        return "";
    }

    public void setFieldSubjectValue(String value) {
        this.getUIStringInput(FIELD_SUBJECT).setValue((Object)value);
    }

    public String getFieldToValue() {
        return (String)this.getUIStringInput(FIELD_TO).getValue();
    }

    public void setFieldToValue(String value) {
        this.getUIStringInput(FIELD_TO).setValue((Object)value);
    }

    public String getFieldAttachmentsValue() {
        UIFormInputWithActions inputSet = (UIFormInputWithActions)this.getChildById(FIELD_FROM_INPUT);
        return (String)inputSet.getUIFormInputInfo(FIELD_ATTACHMENTS).getValue();
    }

    public String getFieldContentValue() {
        String content = "";
        content = this.isVisualEditor != false ? (String)((UIFormWYSIWYGInput)this.getChild(UIFormWYSIWYGInput.class)).getValue() : (String)this.getUIFormTextAreaInput(FIELD_MESSAGECONTENT).getValue();
        if (content == null) {
            content = "";
        }
        return content;
    }

    public void resetFields() {
        this.reset();
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ boolean access$000(UIComposeForm x0) {
        return x0.isCSMail;
    }

    static /* synthetic */ Map access$100(UIComposeForm x0) {
        return x0.fromOptions;
    }
}

