/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui.popup;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.contact.ContactUtils;
import org.exoplatform.contact.webui.popup.UICategorySelect;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/contact/webui/popup/UICategorySelect.gtmpl", events={@EventConfig(listeners={AddCategoryActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OnchangeActionListener.class})})
public class UICategorySelect
extends UIForm {
    public static final String INPUT_CATEGORY = "categoryInput";
    public static final String FIELD_CATEGORY = "category";
    private Map<String, String> privateGroupMap_ = new LinkedHashMap();

    public void setPrivateGroupMap(Map<String, String> map) throws Exception {
        this.privateGroupMap_ = map;
        UIFormInputWithActions input = new UIFormInputWithActions(INPUT_CATEGORY);
        input.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_CATEGORY, FIELD_CATEGORY, this.getCategoryList()));
        UIFormSelectBox uiSelectBox = input.getUIFormSelectBox(FIELD_CATEGORY);
        uiSelectBox.setOnChange("Onchange");
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData addAction = new UIFormInputWithActions.ActionData();
        addAction.setActionType(0);
        addAction.setActionListener("AddCategory");
        addAction.setActionName("AddCategory");
        actions.add(addAction);
        input.setActionField(FIELD_CATEGORY, actions);
        this.addUIFormInput((UIFormInputSet)input);
    }

    public Map<String, String> getPrivateGroupMap() {
        return this.privateGroupMap_;
    }

    public String getSelectedCategory() {
        UIFormInputWithActions input = (UIFormInputWithActions)this.getChildById(INPUT_CATEGORY);
        return (String)input.getUIFormSelectBox(FIELD_CATEGORY).getValue();
    }

    public void setValue(String groupId) throws Exception {
        UIFormInputWithActions input = (UIFormInputWithActions)this.getChildById(INPUT_CATEGORY);
        input.getUIFormSelectBox(FIELD_CATEGORY).setValue(groupId);
    }

    public List<SelectItemOption<String>> getCategoryList() throws Exception {
        ArrayList<SelectItemOption<String>> categories = new ArrayList<SelectItemOption<String>>();
        for (String group : this.privateGroupMap_.keySet()) {
            categories.add((SelectItemOption<String>)new SelectItemOption(ContactUtils.encodeHTML((String)((String)this.privateGroupMap_.get(group))), (Object)group));
        }
        return categories;
    }

    public void setCategoryList(List<SelectItemOption<String>> options) {
        UIFormInputWithActions input = (UIFormInputWithActions)this.getChildById(INPUT_CATEGORY);
        input.getUIFormSelectBox(FIELD_CATEGORY).setOptions(options);
        this.privateGroupMap_.clear();
        for (SelectItemOption<String> option : options) {
            this.privateGroupMap_.put(option.getValue(), option.getLabel());
        }
    }
}

