/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.webui.popup;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.contact.ContactUtils;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.Utils;
import org.exoplatform.contact.webui.popup.UIExportForm;
import org.exoplatform.contact.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/contact/webui/popup/UIExportForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIExportForm
extends UIForm
implements UIPopupComponent {
    private static final String NAME = "name".intern();
    private static final String TYPE = "type".intern();
    private String selectedTag_ = null;
    private String selectedGroup = null;
    private UIPageIterator uiPageIterator_;
    private Map<String, String> checkedContacts = new LinkedHashMap();
    private Map<String, Contact> contacts = null;

    public UIExportForm() throws Exception {
        this.setId("UIExportForm");
        this.uiPageIterator_ = new UIPageIterator();
        this.uiPageIterator_.setId("UIContactPage");
    }

    public String getLabel(String id) throws Exception {
        try {
            return super.getLabel(id);
        }
        catch (MissingResourceException mre) {
            return id;
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setContacts(Map<String, Contact> contacts) {
        this.contacts = contacts;
    }

    public void setContactList(List<ContactData> contactList) throws Exception {
        this.getChildren().clear();
        LazyPageList pageList = new LazyPageList((ListAccess)new ListAccessImpl(ContactData.class, contactList), 10);
        this.uiPageIterator_.setPageList((PageList)pageList);
        for (ContactData contact : contactList) {
            UIFormCheckBoxInput uiCheckbox = this.getUIFormCheckBoxInput(contact.getId());
            if (uiCheckbox != null) continue;
            uiCheckbox = new UIFormCheckBoxInput(contact.getId(), contact.getId(), (Object)false);
            this.addUIFormInput((UIFormInput)uiCheckbox);
        }
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        for (String type : ContactUtils.getContactService().getImportExportType()) {
            options.add(new SelectItemOption(type, (Object)type));
        }
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NAME, NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(TYPE, TYPE, options));
    }

    public List<ContactData> getContacts() throws Exception {
        return new ArrayList<ContactData>(this.uiPageIterator_.getCurrentPageData());
    }

    public void setSelectedGroup(String address) throws Exception {
        this.selectedGroup = address;
    }

    public String getSelectedGroup() {
        try {
            return this.selectedGroup.split(Utils.SPLIT)[2];
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public List<String> getCheckedCurrentPage() throws Exception {
        ArrayList<String> checkedContacts = new ArrayList<String>();
        for (ContactData contact : this.getContacts()) {
            UIFormCheckBoxInput uiCheckBox = (UIFormCheckBoxInput)this.getChildById(contact.getId());
            if (uiCheckBox == null || !uiCheckBox.isChecked()) continue;
            checkedContacts.add(contact.getId());
        }
        return checkedContacts;
    }

    public String getSelectedTag() {
        return this.selectedTag_;
    }

    public void setSelectedTag(String tagName) {
        this.selectedTag_ = tagName;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public long getAvailablePage() {
        return this.uiPageIterator_.getAvailablePage();
    }

    public long getCurrentPage() {
        return this.uiPageIterator_.getCurrentPage();
    }

    protected void updateCurrentPage(int page) throws Exception {
        this.uiPageIterator_.setCurrentPage(page);
        for (ContactData contactData : this.getContacts()) {
            if (!this.checkedContacts.containsKey(contactData.getId())) continue;
            UIFormCheckBoxInput uiCheckBox = (UIFormCheckBoxInput)this.getChildById(contactData.getId());
            uiCheckBox.setChecked(true);
        }
    }

    static /* synthetic */ Map access$000(UIExportForm x0) {
        return x0.checkedContacts;
    }

    static /* synthetic */ String access$100() {
        return TYPE;
    }

    static /* synthetic */ String access$200() {
        return NAME;
    }

    static /* synthetic */ String access$300(UIExportForm x0) {
        return x0.selectedGroup;
    }

    static /* synthetic */ Map access$400(UIExportForm x0) {
        return x0.contacts;
    }
}

