/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.content.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.content.model.ContentNavigation;
import org.exoplatform.content.service.ContentDAO;
import org.exoplatform.portal.config.NewPortalConfig;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewContentNavListener
extends BaseComponentPlugin {
    private ConfigurationManager cservice_;
    private ContentDAO contentService_;
    private NewPortalConfig config_;

    public NewContentNavListener(ContentDAO contentService, ConfigurationManager cservice, InitParams params) throws Exception {
        this.cservice_ = cservice;
        this.contentService_ = contentService;
        String checkUser = "root";
        ValueParam valueParam = params.getValueParam("check.user");
        if (valueParam != null) {
            checkUser = valueParam.getValue();
        }
        if (checkUser == null || checkUser.trim().length() == 0) {
            checkUser = "root";
        }
        if (this.isInitedDB(checkUser)) {
            return;
        }
        this.config_ = (NewPortalConfig)params.getObjectParamValues(NewPortalConfig.class).get(0);
        this.initDB();
    }

    private boolean isInitedDB(String user) throws Exception {
        ContentNavigation nav = this.contentService_.get(user);
        return nav != null;
    }

    private void initDB() throws Exception {
        HashSet users = this.config_.getPredefinedOwner();
        for (String user : users) {
            this.createContentConfigForUser(user);
        }
    }

    private void createContentConfigForUser(String owner) throws Exception {
        String config = null;
        String templateLoc = this.config_.getTemplateLocation();
        if (this.config_.isPredefinedOwner(owner)) {
            String id = this.config_.getTemplateLocation() + "/user/" + owner + "/content.xml";
            config = IOUtil.getStreamContentAsString((InputStream)this.cservice_.getInputStream(id));
        } else {
            InputStream is = this.cservice_.getInputStream(templateLoc + "/user/" + owner + "/content.xml");
            String template = IOUtil.getStreamContentAsString((InputStream)is);
            config = StringUtils.replace((String)template, (String)"@owner@", (String)owner);
        }
        if (config == null) {
            return;
        }
        ContentNavigation contentNavigation = this.fromXML(config, ContentNavigation.class);
        this.contentService_.create(contentNavigation);
    }

    public <T> T fromXML(String xml, Class<T> type) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        IBindingFactory bfact = BindingDirectory.getFactory(type);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        return type.cast(uctx.unmarshalDocument((InputStream)is, null));
    }
}

