/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.content.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.content.model.ContentItem;
import org.exoplatform.content.model.ContentNode;
import org.exoplatform.content.service.ContentDAO;
import org.exoplatform.content.webui.UIDetailContent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/rssreader/webui/UIDetailContent.gtmpl", events={@EventConfig(listeners={RefreshActionListener.class}), @EventConfig(listeners={SelectPathActionListener.class})})
public class UIDetailContent
extends UIContainer {
    private UIPageIterator uiIterator_;
    private ContentNode node_;

    public UIDetailContent() throws Exception {
        UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)this.addChild(UIBreadcumbs.class, null, "ContentBreadcumbs");
        uiBreadcumbs.setBreadcumbsStyle("UIExplorerHistoryPath");
        this.uiIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, null);
        this.addChild((UIComponent)this.uiIterator_);
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiIterator_;
    }

    public void setContentNode(ContentNode node) {
        this.node_ = node;
        this.refresh(false);
    }

    void refresh(boolean removeCached) {
        ContentDAO service = (ContentDAO)PortalContainer.getComponent(ContentDAO.class);
        try {
            if (removeCached) {
                service.removeCache(this.node_.getId());
            }
            PageList pageList = service.getContentData(this.node_);
            this.uiIterator_.setPageList(pageList);
        }
        catch (Exception e) {
            this.uiIterator_.setPageList((PageList)new LazyPageList((ListAccess)new ListAccessImpl(ContentItem.class, new ArrayList()), 10));
        }
    }

    public List<ContentItem> getListItems() throws Exception {
        return this.uiIterator_.getCurrentPageData();
    }

    public ContentNode getContentNode() {
        return this.node_;
    }
}

