/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service;

import org.apache.commons.logging.Log;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class CheckMailJob
extends Thread
implements Job,
Runnable {
    private Thread thread;
    private static Log log_ = ExoLogger.getLogger((String)"job.RecordsJob");

    public CheckMailJob() throws Exception {
        this.setDaemon(true);
        this.start();
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void destroy() {
        this.thread.stop();
        this.thread = null;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            MailService mailService = Utils.getMailService();
            JobSchedulerService schedulerService = Utils.getJobSchedulerService();
            String name = context.getJobDetail().getName();
            JobInfo info = new JobInfo(context.getJobDetail().getName(), "CollaborationSuite-webmail", context.getJobDetail().getJobClass());
            if (name != null && name.indexOf(":") > 0) {
                String[] array = name.split(":");
                mailService.checkNewMessage(SessionProvider.createSystemProvider(), array[0].trim(), array[1].trim());
            }
            schedulerService.removeJob(info);
            System.out.println("\n\n####  Checking mail of " + context.getJobDetail().getName() + " finished ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (log_.isDebugEnabled()) {
            log_.debug((Object)"File plan job done");
        }
    }
}

