/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service;

import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.scheduler.JobInfo;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

public class CheckMailJob
implements Job,
InterruptableJob {
    public static final String CHECKMAIL_GROUP = "CollaborationSuite-webmail";
    public static final String USERNAME = "userName";
    public static final String ACCOUNTID = "acountId";
    public static final String FOLDERID = "folderId";
    private static Log log = ExoLogger.getLogger((String)"job.CheckMailJob");
    private String username;
    private String accountId;
    private String folderId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        MailService mailService = this.getMailService();
        JobDetail jobDetail = context.getJobDetail();
        JobDataMap dataMap = jobDetail.getJobDataMap();
        this.username = dataMap.getString(USERNAME);
        this.accountId = dataMap.getString(ACCOUNTID);
        this.folderId = dataMap.getString(FOLDERID);
        try {
            if (this.username != null && this.accountId != null) {
                mailService.checkNewMessage(this.username, this.accountId, this.folderId);
            }
        }
        catch (InterruptedException ie) {
            this.getMailService().stopCheckMail(this.username, this.accountId);
        }
        catch (Exception e) {
            log.error((Object)("Mail check failed for " + context.getJobDetail().getName()), (Throwable)e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n\n####  Checking mail of " + context.getJobDetail().getName() + " finished "));
            }
        }
    }

    private MailService getMailService() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        MailService mailService = (MailService)container.getComponentInstanceOfType(MailService.class);
        return mailService;
    }

    private static String getJobName(String userId, String accountId) {
        return userId + ":" + accountId;
    }

    public static JobInfo getJobInfo(String userId, String accountId) {
        String name = CheckMailJob.getJobName(userId, accountId);
        JobInfo info = new JobInfo(name, CHECKMAIL_GROUP, CheckMailJob.class);
        info.setDescription("Check emails for user " + userId + " on acount " + accountId);
        return info;
    }

    public void interrupt() throws UnableToInterruptJobException {
        System.out.println("\n\n######### CALLED INTERRUPT!\n\n");
        this.getMailService().stopCheckMail(this.username, this.accountId);
    }
}

