/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.mail.Folder;
import javax.mail.Message;
import org.exoplatform.mail.service.MimeMessageParser;
import org.exoplatform.mail.service.impl.JCRDataStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchMailContentThread
implements Runnable {
    private JCRDataStorage storage_;
    private String username_;
    private String accountId_;
    private LinkedHashMap<Message, List<String>> msgMap_;
    private Folder folder_;
    private int numberMessage_ = 0;

    public FetchMailContentThread(JCRDataStorage storage, LinkedHashMap<Message, List<String>> msgMap, int numberMessage, Folder folder, String username, String accountId) throws Exception {
        this.storage_ = storage;
        this.username_ = username;
        this.accountId_ = accountId;
        this.msgMap_ = msgMap;
        this.folder_ = folder;
        this.numberMessage_ = numberMessage;
    }

    @Override
    public void run() {
        try {
            this.downloadMailContent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void downloadMailContent() throws Exception {
        ArrayList<Message> msgList = new ArrayList<Message>(this.msgMap_.keySet());
        for (int j = 0; j < this.numberMessage_; ++j) {
            Message msg = (Message)msgList.get(j);
            this.storage_.saveTotalMessage(this.username_, this.accountId_, MimeMessageParser.getMessageId(msg), msg, null);
        }
    }

    public void stop() {
        try {
            this.folder_.close(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

