/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.mail.service.JCRPageList;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagePageList
extends JCRPageList {
    private NodeIterator iter_ = null;
    private String value_;
    private boolean hasStructure_;

    public MessagePageList(long pageSize, String value, boolean hasStructure) throws Exception {
        super(pageSize);
        this.value_ = value;
        this.hasStructure_ = hasStructure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void populateCurrentPage(long page, String username) throws Exception {
        long pageSize = this.getPageSize();
        long totalPage = 0L;
        Session session = this.getJCRSession(username);
        try {
            QueryImpl queryImpl = this.createXPathQuery(session, username, this.value_);
            if (page > 1L) {
                queryImpl.setOffset((page - 1L) * pageSize);
            }
            queryImpl.setLimit(pageSize);
            QueryResult result = queryImpl.execute();
            this.iter_ = result.getNodes();
            totalPage = ((QueryResultImpl)result).getTotalSize();
        }
        finally {
            session.logout();
        }
        this.setAvailablePage(totalPage);
        this.currentListPage_ = new LinkedHashMap();
        int i = 0;
        boolean existRefNode = false;
        while ((long)i < pageSize && this.iter_.hasNext()) {
            Node currentNode = this.iter_.nextNode();
            Value[] values = new Value[]{};
            existRefNode = false;
            Value[] folders = currentNode.getProperty(Utils.MSG_FOLDERS).getValues();
            String accId = currentNode.getProperty(Utils.EXO_ACCOUNT).getString();
            String sentFolderId = Utils.generateFID(accId, Utils.FD_SENT, false);
            String[] refFolders = new String[]{sentFolderId};
            String curMsgFolder = "";
            if (folders != null && folders.length > 0) {
                curMsgFolder = currentNode.getProperty(Utils.MSG_FOLDERS).getValues()[0].getString();
                refFolders = new String[]{sentFolderId, curMsgFolder};
            }
            if (this.hasStructure_) {
                Message msg;
                try {
                    values = currentNode.getProperty(Utils.EXO_CONVERSATIONID).getValues();
                    for (int j = 0; j < values.length; ++j) {
                        String uuid = values[j].getString();
                        Node refNode = currentNode.getSession().getNodeByUUID(uuid);
                        String refMsgFolder = refNode.getProperty(Utils.MSG_FOLDERS).getValues()[0].getString();
                        if (refMsgFolder.equals(curMsgFolder)) {
                            existRefNode = true;
                            continue;
                        }
                        if (!refMsgFolder.equals(sentFolderId)) continue;
                        existRefNode = true;
                        Message refMsg = this.getMessage(refNode, refFolders);
                        if (refMsg.getFolders() == null || refMsg.getFolders().length <= 0) continue;
                        this.currentListPage_.put(refMsg.getId(), refMsg);
                        ++i;
                        this.currentListPage_ = this.getMessageList(this.currentListPage_, refNode, curMsgFolder, refFolders);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (currentNode.isNodeType("exo:messageMixin") && existRefNode || (msg = this.getMessage(currentNode, refFolders)).getFolders() == null || msg.getFolders().length <= 0) continue;
                this.currentListPage_.put(msg.getId(), msg);
                ++i;
                this.currentListPage_ = this.getMessageList(this.currentListPage_, currentNode, curMsgFolder, refFolders);
                continue;
            }
            Message msg = this.getMessage(currentNode, null);
            if (msg.getFolders() == null || msg.getFolders().length <= 0) continue;
            this.currentListPage_.put(msg.getId(), msg);
            ++i;
        }
        this.iter_ = null;
    }

    private LinkedHashMap<String, Message> getMessageList(LinkedHashMap<String, Message> listPage, Node currentNode, String folderId, String[] refFolders) throws Exception {
        PropertyIterator prosIter = currentNode.getReferences();
        String accId = currentNode.getProperty(Utils.EXO_ACCOUNT).getString();
        String sentFolderId = Utils.generateFID(accId, Utils.FD_SENT, false);
        while (prosIter.hasNext()) {
            Node msgNode = prosIter.nextProperty().getParent();
            if (!msgNode.isNodeType("exo:message")) continue;
            try {
                String msgFolder = msgNode.getProperty(Utils.MSG_FOLDERS).getValues()[0].getString();
                if (!folderId.equals(msgFolder) && !sentFolderId.equals(msgFolder)) continue;
                Message msg = this.getMessage(msgNode, refFolders);
                msg.setIsRootConversation(false);
                if (msg.getFolders() == null || msg.getFolders().length <= 0) continue;
                listPage.put(msg.getId(), msg);
                if (!msgNode.isNodeType("mix:referenceable")) continue;
                listPage = this.getMessageList(listPage, msgNode, folderId, refFolders);
            }
            catch (Exception e) {}
        }
        return listPage;
    }

    private Message getMessage(Node messageNode, String[] refFolders) throws Exception {
        int i;
        Message msg = new Message();
        if (messageNode.hasProperty(Utils.EXO_ID)) {
            msg.setId(messageNode.getProperty(Utils.EXO_ID).getString());
        }
        msg.setPath(messageNode.getPath());
        try {
            msg.setInReplyToHeader(messageNode.getProperty(Utils.EXO_IN_REPLY_TO_HEADER).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setUID(messageNode.getProperty(Utils.EXO_UID).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setAccountId(messageNode.getProperty(Utils.EXO_ACCOUNT).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setFrom(messageNode.getProperty(Utils.EXO_FROM).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setMessageTo(messageNode.getProperty(Utils.EXO_TO).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setSubject(messageNode.getProperty(Utils.EXO_SUBJECT).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setMessageCc(messageNode.getProperty(Utils.EXO_CC).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setMessageBcc(messageNode.getProperty(Utils.EXO_BCC).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setReplyTo(messageNode.getProperty(Utils.EXO_REPLYTO).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setMessageBody(messageNode.getProperty(Utils.EXO_BODY).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setSize(messageNode.getProperty(Utils.EXO_SIZE).getLong());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setHasAttachment(messageNode.getProperty(Utils.EXO_HASATTACH).getBoolean());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setHasStar(messageNode.getProperty(Utils.EXO_STAR).getBoolean());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setPriority(messageNode.getProperty(Utils.EXO_PRIORITY).getLong());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setUnread(messageNode.getProperty(Utils.EXO_ISUNREAD).getBoolean());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setContentType(messageNode.getProperty(Utils.EXO_CONTENT_TYPE).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Value[] propTags = messageNode.getProperty(Utils.EXO_TAGS).getValues();
            String[] tags = new String[propTags.length];
            for (i = 0; i < propTags.length; ++i) {
                tags[i] = propTags[i].getString();
            }
            msg.setTags(tags);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Value[] propFolders = messageNode.getProperty(Utils.MSG_FOLDERS).getValues();
            String[] folders = new String[propFolders.length];
            for (i = 0; i < propFolders.length; ++i) {
                folders[i] = propFolders[i].getString();
            }
            msg.setFolders(folders);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Value[] properties = messageNode.getProperty(Utils.MSG_HEADERS).getValues();
            for (int i2 = 0; i2 < properties.length; ++i2) {
                String property = properties[i2].getString();
                int index = property.indexOf(61);
                if (index == -1) continue;
                msg.setHeader(property.substring(0, index), property.substring(index + 1));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        GregorianCalendar cal = new GregorianCalendar();
        try {
            cal.setTimeInMillis(messageNode.getProperty(Utils.EXO_RECEIVEDDATE).getLong());
            msg.setReceivedDate(cal.getTime());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            cal.setTimeInMillis(messageNode.getProperty(Utils.EXO_SENDDATE).getLong());
            msg.setSendDate(cal.getTime());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            cal.setTimeInMillis(messageNode.getProperty(Utils.EXO_LAST_UPDATE_TIME).getLong());
            msg.setLastUpdateDate(cal.getTime());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setIsLoaded(messageNode.getProperty(Utils.IS_LOADED).getBoolean());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setAttIsLoadedProperly(messageNode.getProperty(Utils.ATT_IS_LOADED_PROPERLY).getBoolean());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            msg.setIsReturnReceipt(messageNode.getProperty(Utils.IS_RETURN_RECEIPT).getBoolean());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.hasStructure_) {
            if (refFolders == null) {
                refFolders = new String[]{msg.getFolders()[0]};
            }
            List<String> referedMessageIds = this.getReferedMessageIds(messageNode, refFolders);
            msg.setReferedMessageIds(referedMessageIds);
            Value[] values = new Value[]{};
            try {
                values = messageNode.getProperty("exo:conversationId").getValues();
                for (int j = 0; j < values.length; ++j) {
                    Value value = values[j];
                    String uuid = value.getString();
                    Node refNode = messageNode.getSession().getNodeByUUID(uuid);
                    Message refMsg = (Message)this.currentListPage_.get(refNode.getName());
                    List<String> sibling = refMsg.getReferedMessageIds();
                    sibling.removeAll(referedMessageIds);
                    if (refMsg == null) continue;
                    refMsg.setReferedMessageIds(sibling);
                    if (refMsg.getFolders() == null || refMsg.getFolders().length <= 0) continue;
                    this.currentListPage_.put(refNode.getName(), refMsg);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            List<String> groupedMessageIds = new ArrayList<String>();
            groupedMessageIds = this.getGroupedMessageIds(groupedMessageIds, messageNode, refFolders);
            msg.setGroupedMessageIds(groupedMessageIds);
        }
        return msg;
    }

    public List<String> getReferedMessageIds(Node node, String[] refFolders) throws Exception {
        ArrayList<String> referedMessageIds = new ArrayList<String>();
        PropertyIterator prosIter = node.getReferences();
        block2: while (prosIter.hasNext()) {
            Node msgNode = prosIter.nextProperty().getParent();
            for (int i = 0; i < refFolders.length; ++i) {
                try {
                    if (!refFolders[i].equals(msgNode.getProperty(Utils.MSG_FOLDERS).getValues()[0].getString())) continue;
                    String id = msgNode.getProperty(Utils.EXO_ID).getString();
                    if (referedMessageIds.contains(id)) continue block2;
                    referedMessageIds.add(id);
                    continue block2;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return referedMessageIds;
    }

    private List<String> getGroupedMessageIds(List<String> list, Node currentNode, String[] refFolders) throws Exception {
        PropertyIterator prosIter = currentNode.getReferences();
        block2: while (prosIter.hasNext()) {
            Node msgNode = prosIter.nextProperty().getParent();
            if (!msgNode.isNodeType("exo:message")) continue;
            try {
                String msgFolderId = msgNode.getProperty(Utils.MSG_FOLDERS).getValues()[0].getString();
                String msgNodeId = msgNode.getProperty(Utils.EXO_ID).getString();
                for (int i = 0; i < refFolders.length; ++i) {
                    if (!refFolders[i].equals(msgFolderId)) continue;
                    if (!list.contains(msgNodeId)) {
                        list.add(msgNodeId);
                    }
                    if (!msgNode.isNodeType("mix:referenceable")) continue block2;
                    list = this.getGroupedMessageIds(list, msgNode, refFolders);
                    continue block2;
                }
            }
            catch (Exception e) {
            }
        }
        return list;
    }

    @Override
    public List<Message> getAll() throws Exception {
        return null;
    }

    public List<Message> getAll(String username) throws Exception {
        ArrayList<Message> messageList = new ArrayList<Message>();
        int i = 1;
        while ((long)i <= this.getAvailablePage()) {
            messageList.addAll(this.getPage(i, username));
            ++i;
        }
        return messageList;
    }

    private Session getJCRSession(String username) throws Exception {
        RepositoryService repositoryService = (RepositoryService)PortalContainer.getComponent(RepositoryService.class);
        SessionProvider sessionProvider = this.createSystemProvider();
        String defaultWS = repositoryService.getDefaultRepository().getConfiguration().getDefaultWorkspaceName();
        return sessionProvider.getSession(defaultWS, repositoryService.getCurrentRepository());
    }

    private QueryImpl createXPathQuery(Session session, String username, String xpath) throws Exception {
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        return (QueryImpl)queryManager.createQuery(xpath, "xpath");
    }

    private SessionProvider createSystemProvider() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SessionProviderService service = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        return service.getSystemSessionProvider(null);
    }
}

