/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service.impl;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.smtp.SMTPSendFailedException;
import com.sun.mail.smtp.SMTPTransport;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.RecipientStringTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SentDateTerm;
import javax.mail.search.SubjectTerm;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.mail.connection.impl.ImapConnector;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.AccountData;
import org.exoplatform.mail.service.Attachment;
import org.exoplatform.mail.service.CheckMailJob;
import org.exoplatform.mail.service.CheckingInfo;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.Info;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.MailSetting;
import org.exoplatform.mail.service.MailUpdateStorageEventListener;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.MessageFilter;
import org.exoplatform.mail.service.MessagePageList;
import org.exoplatform.mail.service.MimeMessageParser;
import org.exoplatform.mail.service.ServerConfiguration;
import org.exoplatform.mail.service.SpamFilter;
import org.exoplatform.mail.service.Tag;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.service.impl.DispositionNotification;
import org.exoplatform.mail.service.impl.EMLImportExport;
import org.exoplatform.mail.service.impl.FetchMailContentThread;
import org.exoplatform.mail.service.impl.JCRDataStorage;
import org.exoplatform.mail.service.impl.MultipartReport;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.services.scheduler.PeriodInfo;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.picocontainer.Startable;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailServiceImpl
implements MailService,
Startable {
    private static final Log logger = LogFactory.getLog(MailServiceImpl.class);
    private JCRDataStorage storage_;
    private EMLImportExport emlImportExport_;
    private Map<String, CheckingInfo> checkingLog_;
    private JobSchedulerService schedulerService_;
    public List<MailUpdateStorageEventListener> listeners_ = new ArrayList<MailUpdateStorageEventListener>();

    public MailServiceImpl(NodeHierarchyCreator nodeHierarchyCreator, JobSchedulerService schedulerService, RepositoryService reposervice) throws Exception {
        this.storage_ = new JCRDataStorage(nodeHierarchyCreator, reposervice);
        this.emlImportExport_ = new EMLImportExport(this.storage_);
        this.checkingLog_ = new HashMap<String, CheckingInfo>();
        this.schedulerService_ = schedulerService;
    }

    @Override
    public String getMailHierarchyNode() throws Exception {
        return this.storage_.getMailHierarchyNode();
    }

    @Override
    public void removeCheckingInfo(String username, String accountId) throws Exception {
        String key = username + ":" + accountId;
        this.checkingLog_.remove(key);
    }

    @Override
    public CheckingInfo getCheckingInfo(String username, String accountId) {
        String key = username + ":" + accountId;
        return this.checkingLog_.get(key);
    }

    @Override
    public List<Account> getAccounts(String username) throws Exception {
        return this.storage_.getAccounts(username);
    }

    @Override
    public Account getAccountById(String username, String id) throws Exception {
        return this.storage_.getAccountById(username, id);
    }

    public void saveAccount(String username, Account account, boolean isNew) throws Exception {
        this.storage_.saveAccount(username, account, isNew);
    }

    @Override
    public void updateAccount(String username, Account account) throws Exception {
        this.saveAccount(username, account, false);
    }

    @Override
    public void removeAccount(String username, String accountId) throws Exception {
        this.stopAllJobs(username, accountId);
        this.storage_.removeAccount(username, accountId);
    }

    @Override
    public Folder getFolder(String username, String accountId, String folderId) throws Exception {
        return this.storage_.getFolder(username, accountId, folderId);
    }

    @Override
    public String getFolderParentId(String username, String accountId, String folderId) throws Exception {
        return this.storage_.getFolderParentId(username, accountId, folderId);
    }

    @Override
    public boolean isExistFolder(String username, String accountId, String parentId, String folderName) throws Exception {
        return this.storage_.isExistFolder(username, accountId, parentId, folderName);
    }

    @Override
    public void saveFolder(String username, String accountId, Folder folder) throws Exception {
        this.saveFolder(username, accountId, folder, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFolder(String username, String accountId, Folder folder, boolean b) throws Exception {
        Account account = this.getAccountById(username, accountId);
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP) && folder.isPersonalFolder() && b) {
            IMAPFolder imapFolder = null;
            try {
                ImapConnector connector = new ImapConnector(account);
                imapFolder = (IMAPFolder)connector.createFolder(folder);
                this.saveFolder(username, accountId, null, (javax.mail.Folder)imapFolder);
            }
            catch (Exception e) {
                return;
            }
            finally {
                if (imapFolder != null && imapFolder.isOpen()) {
                    imapFolder.close(true);
                }
            }
        } else {
            this.storage_.saveFolder(username, accountId, folder);
        }
    }

    @Override
    public void saveFolder(String username, String accountId, String parentId, Folder folder) throws Exception {
        this.saveFolder(username, accountId, parentId, folder, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveFolder(String username, String accountId, String parentId, Folder folder, boolean b) throws Exception {
        Account account = this.getAccountById(username, accountId);
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP) && folder.isPersonalFolder() && b) {
            try {
                Folder parentFolder = this.getFolder(username, accountId, parentId);
                ImapConnector connector = new ImapConnector(account);
                IMAPFolder imapFolder = (IMAPFolder)connector.createFolder(parentFolder, folder);
                if (imapFolder == null) return;
                this.saveFolder(username, accountId, parentFolder, (javax.mail.Folder)imapFolder);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        } else {
            this.storage_.saveFolder(username, accountId, parentId, folder);
        }
    }

    @Override
    public void renameFolder(String username, String accountId, String newName, String folderId) throws Exception {
        Account account = this.getAccountById(username, accountId);
        Folder folder = this.getFolder(username, accountId, folderId);
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP) && folder.isPersonalFolder()) {
            try {
                ImapConnector connector = new ImapConnector(account);
                folder = connector.renameFolder(newName, folder);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (folder != null) {
            this.storage_.renameFolder(username, accountId, newName, folder);
        }
    }

    private void deleteLocalFolder(String username, String accountId, String folderId) throws Exception {
        this.storage_.removeUserFolder(username, accountId, folderId);
    }

    @Override
    public void removeUserFolder(String username, String accountId, String folderId) throws Exception {
        Account account = this.getAccountById(username, accountId);
        Folder folder = this.getFolder(username, accountId, folderId);
        boolean success = true;
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP) && folder.isPersonalFolder()) {
            try {
                ImapConnector connector = new ImapConnector(account);
                success = connector.deleteFolder(folder);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (success) {
            this.storage_.removeUserFolder(username, accountId, folderId);
        }
    }

    @Override
    public List<MessageFilter> getFilters(String username, String accountId) throws Exception {
        return this.storage_.getFilters(username, accountId);
    }

    @Override
    public MessageFilter getFilterById(String username, String accountId, String filterId) throws Exception {
        return this.storage_.getFilterById(username, accountId, filterId);
    }

    @Override
    public void saveFilter(String username, String accountId, MessageFilter filter, boolean applyAll) throws Exception {
        this.storage_.saveFilter(username, accountId, filter, applyAll);
    }

    @Override
    public void removeFilter(String username, String accountId, String filterId) throws Exception {
        this.storage_.removeFilter(username, accountId, filterId);
    }

    @Override
    public Message getMessageById(String username, String accountId, String msgId) throws Exception {
        return this.storage_.getMessageById(username, accountId, msgId);
    }

    @Override
    public void removeMessage(String username, String accountId, Message message) throws Exception {
        this.storage_.removeMessage(username, accountId, message);
    }

    @Override
    public void removeMessages(String username, String accountId, List<Message> messages, boolean moveReference) throws Exception {
        this.storage_.removeMessages(username, accountId, messages, moveReference);
    }

    @Override
    public void moveMessages(String username, String accountId, List<Message> msgList, String currentFolderId, String destFolderId) throws Exception {
        Account account = this.getAccountById(username, accountId);
        Folder currentFolder = this.getFolder(username, accountId, currentFolderId);
        Folder destFolder = this.getFolder(username, accountId, destFolderId);
        boolean success = true;
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP)) {
            try {
                ImapConnector connector = new ImapConnector(account);
                msgList = connector.moveMessage(msgList, currentFolder, destFolder);
                if (msgList == null) {
                    success = false;
                }
            }
            catch (Exception e) {
                return;
            }
        }
        if (success) {
            this.storage_.moveMessages(username, accountId, msgList, currentFolderId, destFolderId);
        }
    }

    @Override
    public void moveMessages(String username, String accountId, List<Message> msgList, String currentFolderId, String destFolderId, boolean updateReference) throws Exception {
        Account account = this.getAccountById(username, accountId);
        Folder currentFolder = this.getFolder(username, accountId, currentFolderId);
        Folder destFolder = this.getFolder(username, accountId, destFolderId);
        boolean success = true;
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP)) {
            try {
                ImapConnector connector = new ImapConnector(account);
                msgList = connector.moveMessage(msgList, currentFolder, destFolder);
                if (msgList == null) {
                    success = false;
                }
            }
            catch (Exception e) {
                return;
            }
        }
        if (success) {
            this.storage_.moveMessages(username, accountId, msgList, currentFolderId, destFolderId, updateReference);
        }
    }

    @Override
    public void moveMessage(String username, String accountId, Message msg, String currentFolderId, String destFolderId) throws Exception {
        Account account = this.getAccountById(username, accountId);
        Folder currentFolder = this.getFolder(username, accountId, currentFolderId);
        Folder destFolder = this.getFolder(username, accountId, destFolderId);
        boolean success = true;
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP)) {
            try {
                List<Message> l = new ArrayList<Message>();
                ImapConnector connector = new ImapConnector(account);
                l.add(msg);
                l = connector.moveMessage(l, currentFolder, destFolder);
                if (l == null) {
                    success = false;
                } else {
                    msg = l.get(0);
                }
            }
            catch (Exception e) {
                return;
            }
        }
        if (success) {
            this.moveMessage(username, accountId, msg, currentFolderId, destFolderId, true);
        }
    }

    @Override
    public void moveMessage(String username, String accountId, Message msg, String currentFolderId, String destFolderId, boolean updateReference) throws Exception {
        Account account = this.getAccountById(username, accountId);
        Folder currentFolder = this.getFolder(username, accountId, currentFolderId);
        Folder destFolder = this.getFolder(username, accountId, destFolderId);
        boolean success = true;
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP)) {
            try {
                ImapConnector connector = new ImapConnector(account);
                List<Message> l = new ArrayList<Message>();
                l.add(msg);
                l = connector.moveMessage(l, currentFolder, destFolder);
                if (l == null) {
                    success = false;
                } else {
                    msg = l.get(0);
                }
            }
            catch (Exception e) {
                return;
            }
        }
        if (success) {
            this.storage_.moveMessage(username, accountId, msg, currentFolderId, destFolderId, updateReference);
        }
    }

    @Override
    public MessagePageList getMessagePageList(String username, MessageFilter filter) throws Exception {
        return this.storage_.getMessagePageList(username, filter);
    }

    @Override
    public void saveMessage(String username, String accountId, String targetMsgPath, Message message, boolean isNew) throws Exception {
        this.storage_.saveMessage(username, accountId, targetMsgPath, message, isNew);
    }

    @Override
    public List<Message> getMessagesByTag(String username, String accountId, String tagId) throws Exception {
        MessageFilter filter = new MessageFilter("Tag");
        filter.setAccountId(accountId);
        filter.setFolder(new String[]{tagId});
        return this.getMessages(username, filter);
    }

    @Override
    public List<Message> getMessagesByFolder(String username, String accountId, String folderId) throws Exception {
        MessageFilter filter = new MessageFilter("Folder");
        filter.setAccountId(accountId);
        filter.setFolder(new String[]{folderId});
        return this.getMessages(username, filter);
    }

    @Override
    public List<Message> getMessages(String username, MessageFilter filter) throws Exception {
        return this.storage_.getMessages(username, filter);
    }

    @Override
    public void saveMessage(String username, String accountId, Message message, boolean isNew) throws Exception {
        this.storage_.saveMessage(username, accountId, message, isNew);
    }

    @Override
    public Message sendMessage(String username, String accId, Message message) throws Exception {
        Account acc = this.getAccountById(username, accId);
        return this.sendMessage(username, acc, message);
    }

    @Override
    public Message sendMessage(String username, Account acc, Message message) throws Exception {
        String smtpUser = acc.getIncomingUser();
        String outgoingHost = acc.getOutgoingHost();
        String outgoingPort = acc.getOutgoingPort();
        String isSSl = acc.getServerProperties().get(Utils.SVR_OUTGOING_SSL);
        boolean isSMTPAuth = acc.isOutgoingAuthentication();
        Properties props = new Properties();
        props.put(Utils.SVR_SMTP_USER, smtpUser);
        props.put(Utils.SVR_SMTP_HOST, outgoingHost);
        props.put(Utils.SVR_SMTP_PORT, outgoingPort);
        props.put("mail.smtp.dsn.notify", "SUCCESS,FAILURE ORCPT=rfc822;" + acc.getEmailAddress());
        props.put("mail.smtp.dsn.ret", "FULL");
        props.put("mail.smtp.socketFactory.port", outgoingPort);
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_FALLBACK, "true");
        props.put("mail.smtp.connectiontimeout", "0");
        props.put("mail.smtp.timeout", "0");
        String socketFactoryClass = "javax.net.SocketFactory";
        if (Boolean.valueOf(isSSl).booleanValue()) {
            socketFactoryClass = Utils.SSL_FACTORY;
            props.put(Utils.SVR_SMTP_STARTTLS_ENABLE, "true");
            props.put("mail.smtp.ssl.protocols", "SSLv3 TLSv1");
        }
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_CLASS, socketFactoryClass);
        props.put(Utils.SVR_SMTP_USER, smtpUser);
        if (isSMTPAuth) {
            props.put(Utils.SVR_SMTP_AUTH, "true");
        } else {
            props.put(Utils.SVR_SMTP_AUTH, "false");
        }
        Session session = Session.getInstance((Properties)props, null);
        logger.debug((Object)" #### Sending email ... ");
        SMTPTransport transport = (SMTPTransport)session.getTransport("smtp");
        try {
            if (!isSMTPAuth) {
                transport.connect();
            } else if (acc.useIncomingSettingForOutgoingAuthent()) {
                transport.connect(outgoingHost, Integer.parseInt(outgoingPort), smtpUser, acc.getIncomingPassword());
            } else {
                transport.connect(outgoingHost, Integer.parseInt(outgoingPort), acc.getOutgoingUserName(), acc.getOutgoingPassword());
            }
        }
        catch (Exception ex) {
            logger.debug((Object)"#### Can not connect to smtp server ...");
            throw ex;
        }
        Message msg = this.send(session, (Transport)transport, message);
        transport.close();
        return msg;
    }

    @Override
    public Message sendMessage(String username, Message message) throws Exception {
        return this.sendMessage(username, message.getAccountId(), message);
    }

    @Override
    public void sendMessage(Message message) throws Exception {
        ArrayList<Message> msgList = new ArrayList<Message>();
        msgList.add(message);
        this.sendMessages(msgList, message.getServerConfiguration());
    }

    @Override
    public void sendMessages(List<Message> msgList, ServerConfiguration serverConfig) throws Exception {
        Properties props = new Properties();
        props.put(Utils.SVR_INCOMING_USERNAME, serverConfig.getUserName());
        props.put(Utils.SVR_INCOMING_PASSWORD, serverConfig.getPassword());
        props.put(Utils.SVR_SMTP_USER, serverConfig.getUserName());
        props.put(Utils.SVR_SMTP_HOST, serverConfig.getOutgoingHost());
        props.put(Utils.SVR_SMTP_PORT, serverConfig.getOutgoingPort());
        boolean isSMTPAuth = serverConfig.isOutgoingAuthentication();
        if (isSMTPAuth) {
            props.put(Utils.SVR_SMTP_AUTH, "true");
        } else {
            props.put(Utils.SVR_SMTP_AUTH, "false");
        }
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_PORT, serverConfig.getOutgoingPort());
        if (serverConfig.isOutgoingSsl()) {
            props.put(Utils.SVR_INCOMING_SSL, String.valueOf(serverConfig.isSsl()));
            props.put(Utils.SVR_SMTP_STARTTLS_ENABLE, "true");
            props.put(Utils.SVR_SMTP_SOCKET_FACTORY_CLASS, "javax.net.ssl.SSLSocketFactory");
        }
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_FALLBACK, "false");
        Session session = Session.getInstance((Properties)props, null);
        Transport transport = session.getTransport("smtp");
        try {
            if (!isSMTPAuth) {
                transport.connect();
            } else {
                transport.connect(serverConfig.getOutgoingHost(), serverConfig.getUserName(), serverConfig.getPassword());
            }
        }
        catch (Exception e) {
            try {
                transport.connect();
            }
            catch (Exception ex) {
                logger.debug((Object)"#### Can not connect to smtp server ...");
                return;
            }
        }
        logger.debug((Object)" #### Sending email ... ");
        int i = 0;
        for (Message msg : msgList) {
            msg.setServerConfiguration(serverConfig);
            try {
                this.send(session, transport, msg);
                ++i;
            }
            catch (Exception e) {
                logger.error((Object)(" #### Info : send fail at message " + i + " \n"));
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                StringBuffer sb = sw.getBuffer();
                logger.error((Object)sb.toString());
            }
        }
        logger.debug((Object)(" #### Info : Sent " + i + " email(s)"));
        transport.close();
    }

    private Message send(Session session, Transport transport, Message message) throws Exception {
        MimeMessage mimeMessage = new MimeMessage(session);
        String status = "";
        mimeMessage.setHeader("Message-ID", message.getId());
        mimeMessage.setHeader("Content-Transfer-Encoding", "utf-8");
        InternetAddress addressFrom = message.getFrom() != null ? new InternetAddress(message.getFrom()) : new InternetAddress(session.getProperties().getProperty(Utils.SVR_SMTP_USER));
        mimeMessage.setFrom((Address)addressFrom);
        if (message.getMessageTo() != null) {
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)message.getMessageTo()));
        }
        if (message.getMessageCc() != null) {
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)message.getMessageCc(), (boolean)true));
        }
        if (message.getMessageBcc() != null) {
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)message.getMessageBcc(), (boolean)false));
        }
        if (message.getReplyTo() != null) {
            mimeMessage.setReplyTo((Address[])Utils.getInternetAddress(message.getReplyTo()));
        }
        mimeMessage.setSubject(message.getSubject(), "UTF-8");
        mimeMessage.setSentDate(message.getSendDate());
        MimeMultipart multipPartRoot = new MimeMultipart("mixed");
        MimeMultipart multipPartContent = new MimeMultipart("alternative");
        List<Attachment> attachList = message.getAttachments();
        if (attachList != null && attachList.size() != 0) {
            MimeBodyPart contentPartRoot = new MimeBodyPart();
            if (message.getContentType() != null && message.getContentType().indexOf("text/plain") > -1) {
                contentPartRoot.setContent((Object)message.getMessageBody(), "text/plain; charset=utf-8");
            } else {
                contentPartRoot.setContent((Object)message.getMessageBody(), "text/html; charset=utf-8");
            }
            MimeBodyPart mimeBodyPart1 = new MimeBodyPart();
            mimeBodyPart1.setContent((Object)message.getMessageBody(), message.getContentType());
            multipPartContent.addBodyPart((BodyPart)mimeBodyPart1);
            multipPartRoot.addBodyPart((BodyPart)contentPartRoot);
            for (Attachment att : attachList) {
                InputStream is = att.getInputStream();
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(is, att.getMimeType());
                mimeBodyPart.setDataHandler(new DataHandler((DataSource)byteArrayDataSource));
                mimeBodyPart.setDisposition("attachment");
                mimeBodyPart.setFileName(MimeUtility.encodeText((String)att.getName(), (String)"utf-8", null));
                multipPartRoot.addBodyPart((BodyPart)mimeBodyPart);
            }
            mimeMessage.setContent((Multipart)multipPartRoot);
        } else if (message.getContentType() != null && message.getContentType().indexOf("text/plain") > -1) {
            mimeMessage.setContent((Object)message.getMessageBody(), "text/plain; charset=utf-8");
        } else {
            mimeMessage.setContent((Object)message.getMessageBody(), "text/html; charset=utf-8");
        }
        if (message.isReturnReceipt()) {
            mimeMessage.setHeader("Disposition-Notification-To", message.getReplyTo());
        }
        mimeMessage.setHeader("X-Priority", String.valueOf(message.getPriority()));
        String priority = "Normal";
        if (message.getPriority() == 1L) {
            priority = "High";
        } else if (message.getPriority() == 5L) {
            priority = "Low";
        }
        if (message.getPriority() != 0L) {
            mimeMessage.setHeader("Importance", priority);
        }
        Iterator<String> iter = message.getHeaders().keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            mimeMessage.setHeader(key, message.getHeaders().get(key));
        }
        mimeMessage.saveChanges();
        try {
            transport.sendMessage((javax.mail.Message)mimeMessage, mimeMessage.getAllRecipients());
            message.setId(MimeMessageParser.getMessageId((javax.mail.Message)mimeMessage));
            Enumeration enu = mimeMessage.getAllHeaders();
            while (enu.hasMoreElements()) {
                Header header = (Header)enu.nextElement();
                message.setHeader(header.getName(), header.getValue());
            }
            status = "Mail Delivered !";
        }
        catch (AddressException e) {
            status = "There was an error parsing the addresses. Sending Failed !" + e.getMessage();
            throw e;
        }
        catch (AuthenticationFailedException e) {
            status = "The Username or Password may be wrong. Sending Failed !" + e.getMessage();
            throw e;
        }
        catch (SMTPSendFailedException e) {
            status = "Sorry, There was an error sending the message. Sending Failed !" + e.getMessage();
            throw e;
        }
        catch (MessagingException e) {
            status = "There was an unexpected error. Sending Failed ! " + e.getMessage();
            throw e;
        }
        catch (Exception e) {
            status = "There was an unexpected error. Sending Falied !" + e.getMessage();
            throw e;
        }
        logger.debug((Object)(" #### Info : " + status));
        return message;
    }

    @Override
    public void checkMail(String username, String accountId) throws Exception {
        JobDetail job = this.loadCheckmailJob(username, accountId);
        if (job != null) {
            this.schedulerService_.executeJob(job.getName(), job.getGroup(), job.getJobDataMap());
        }
    }

    @Override
    public void checkMail(String username, String accountId, String folderId) throws Exception {
        if (Utils.isEmptyField(folderId)) {
            this.checkMail(username, accountId);
        } else {
            JobDetail job = this.loadCheckmailJob(username, accountId, folderId);
            if (job != null) {
                this.schedulerService_.executeJob(job.getName(), job.getGroup(), job.getJobDataMap());
            }
        }
    }

    @Override
    public void stopCheckMail(String username, String accountId) {
        CheckingInfo checkingInfo = this.getCheckingInfo(username, accountId);
        if (checkingInfo != null) {
            checkingInfo.setRequestStop(true);
            System.out.println("Requested check loop to stop ");
        }
    }

    @Override
    public void stopAllJobs(String username, String accountId) throws Exception {
        JobInfo info = CheckMailJob.getJobInfo(username, accountId);
        this.stopCheckMail(username, accountId);
        this.schedulerService_.removeJob(info);
    }

    private JobDetail loadCheckmailJob(String username, String accountId) throws Exception {
        return this.loadCheckmailJob(username, accountId, "");
    }

    private JobDetail loadCheckmailJob(String username, String accountId, String folderId) throws Exception {
        JobInfo info = CheckMailJob.getJobInfo(username, accountId);
        JobDetail job = this.findCheckmailJob(username, accountId);
        if (job == null) {
            JobDataMap jobData = new JobDataMap();
            jobData.put("userName", username);
            jobData.put("acountId", accountId);
            jobData.put("folderId", folderId);
            PeriodInfo periodInfo = new PeriodInfo(new GregorianCalendar().getTime(), null, 1, 86400000L);
            this.schedulerService_.addPeriodJob(info, periodInfo, jobData);
        }
        return job;
    }

    private JobDetail findCheckmailJob(String username, String accountId) throws Exception {
        for (Object obj : this.schedulerService_.getAllJobs()) {
            JobDetail tmp = (JobDetail)obj;
            if (!tmp.getName().equals(username + ":" + accountId)) continue;
            return tmp;
        }
        return null;
    }

    private LinkedHashMap<javax.mail.Message, List<String>> getMessages(LinkedHashMap<javax.mail.Message, List<String>> msgMap, javax.mail.Folder folder, boolean isImap, Date fromDate, Date toDate, List<MessageFilter> filters) throws Exception {
        javax.mail.Message msg;
        javax.mail.Message[] messages;
        Object searchTerm = null;
        if (fromDate != null && toDate != null && fromDate.equals(toDate)) {
            return msgMap;
        }
        if (fromDate == null && toDate == null) {
            messages = folder.getMessages();
        } else {
            searchTerm = new FlagTerm(new Flags(Flags.Flag.SEEN), false);
            Object dateTerm = null;
            if (fromDate != null) {
                dateTerm = new SentDateTerm(5, fromDate);
            }
            if (toDate != null) {
                dateTerm = dateTerm != null ? new AndTerm((SearchTerm)dateTerm, (SearchTerm)new SentDateTerm(1, toDate)) : new SentDateTerm(1, toDate);
            }
            searchTerm = !isImap ? new OrTerm((SearchTerm)searchTerm, (SearchTerm)dateTerm) : dateTerm;
            messages = folder.search((SearchTerm)searchTerm);
        }
        boolean beforeTime = false;
        boolean betweenTime = false;
        int filteredMsgNumber = 0;
        int getFrom = 0;
        for (MessageFilter filter : filters) {
            int k;
            beforeTime = false;
            betweenTime = false;
            SearchTerm st = this.getSearchTerm((SearchTerm)searchTerm, filter);
            javax.mail.Message[] filteredMsg = folder.search(st);
            filteredMsgNumber = filteredMsg.length;
            if (filteredMsgNumber <= 0) continue;
            getFrom = 0;
            if (fromDate != null) {
                for (k = 0; k < filteredMsgNumber && MimeMessageParser.getReceivedDate(filteredMsg[k]).getTime().before(fromDate); ++k) {
                    ++getFrom;
                }
            }
            for (k = filteredMsgNumber - 1; k >= 0; --k) {
                msg = filteredMsg[k];
                List<Object> filterList = msgMap.containsKey(msg) ? msgMap.get(msg) : new ArrayList();
                if (filterList == null) {
                    filterList = new ArrayList();
                }
                if (!filterList.contains(filter.getId())) {
                    filterList.add(filter.getId());
                }
                if (fromDate != null && toDate != null) {
                    if (!betweenTime && isImap && !MimeMessageParser.getReceivedDate(msg).getTime().before(toDate)) continue;
                    betweenTime = true;
                    if (!isImap || k > getFrom) {
                        msgMap.put(msg, filterList);
                        continue;
                    }
                    betweenTime = false;
                    continue;
                }
                if (fromDate != null) {
                    if (isImap && k <= getFrom) continue;
                    msgMap.put(msg, filterList);
                    continue;
                }
                if (toDate != null) {
                    if (!beforeTime && isImap && !MimeMessageParser.getReceivedDate(msg).getTime().before(toDate)) continue;
                    beforeTime = true;
                    msgMap.put(msg, filterList);
                    continue;
                }
                msgMap.put(msg, filterList);
            }
        }
        if (messages.length > 0) {
            beforeTime = false;
            betweenTime = false;
            getFrom = 0;
            if (fromDate != null) {
                Date date;
                for (int l = 0; l < messages.length && ((date = MimeMessageParser.getReceivedDate(messages[l]).getTime()).before(fromDate) || date.equals(fromDate)); ++l) {
                    ++getFrom;
                }
            }
            for (int l = messages.length; l > 0; --l) {
                msg = messages[l - 1];
                if (!msgMap.containsKey(msg)) {
                    if (fromDate != null && toDate != null) {
                        if (!betweenTime && isImap && !MimeMessageParser.getReceivedDate(msg).getTime().before(toDate)) continue;
                        betweenTime = true;
                        if (!isImap || l > getFrom) {
                            msgMap.put(msg, null);
                            continue;
                        }
                        betweenTime = false;
                        continue;
                    }
                    if (fromDate != null) {
                        if (isImap && l <= getFrom) continue;
                        msgMap.put(msg, null);
                        continue;
                    }
                    if (toDate != null) {
                        if (!beforeTime && isImap && !MimeMessageParser.getReceivedDate(msg).getTime().before(toDate)) continue;
                        beforeTime = true;
                        msgMap.put(msg, null);
                        continue;
                    }
                    msgMap.put(msg, null);
                    continue;
                }
                List<String> temp = msgMap.get(msg);
                msgMap.remove(msg);
                msgMap.put(msg, temp);
            }
        }
        return msgMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchImapFolders(String username, String accountId) throws Exception {
        CheckingInfo info = new CheckingInfo();
        String key = username + ":" + accountId;
        this.checkingLog_.put(key, info);
        IMAPStore store = null;
        try {
            Account account = this.getAccountById(username, accountId);
            store = this.openIMAPConnection(username, account, info);
            if (store != null) {
                this.checkingLog_.get(key).setSyncFolderStatus(301);
                this.synchImapFolders(username, accountId, null, store.getDefaultFolder().list());
                this.checkingLog_.get(key).setSyncFolderStatus(302);
            }
        }
        finally {
            if (store != null && store.isConnected()) {
                store.close();
            }
        }
    }

    private List<javax.mail.Folder> synchImapFolders(String username, String accountId, Folder parentFolder, javax.mail.Folder[] folders) throws Exception {
        ArrayList<javax.mail.Folder> folderList = new ArrayList<javax.mail.Folder>();
        ArrayList<String> serverFolderId = new ArrayList<String>();
        for (javax.mail.Folder fd : folders) {
            String folderName = fd.getName();
            if (parentFolder == null && (folderName.equalsIgnoreCase(Utils.FD_TRASH) || folderName.equalsIgnoreCase(Utils.FD_DRAFTS) || folderName.equalsIgnoreCase(Utils.FD_SENT) || folderName.equalsIgnoreCase(Utils.FD_SPAM))) continue;
            if (!fd.getName().equalsIgnoreCase(Utils.FD_INBOX)) {
                String folderId;
                block9: {
                    folderId = fd.getType() != 2 ? Utils.generateFID(accountId, String.valueOf(((IMAPFolder)fd).getUIDValidity()), true) : Utils.escapeIllegalJcrChars(folderName);
                    serverFolderId.add(folderId);
                    Folder folder = this.storage_.getFolder(username, accountId, folderId);
                    if (folder == null) {
                        folder = new Folder();
                        folder.setId(folderId);
                        folder.setName(folderName);
                        folder.setURLName(fd.getURLName().toString());
                        folder.setNumberOfUnreadMessage(0L);
                        folder.setTotalMessage(0L);
                        folder.setPersonalFolder(true);
                        folder.setType(fd.getType());
                        try {
                            if (parentFolder == null) {
                                this.storage_.saveFolder(username, accountId, folder);
                                break block9;
                            }
                            this.storage_.saveFolder(username, accountId, parentFolder.getId(), folder);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (folder.getName().equalsIgnoreCase(fd.getName())) {
                        folder.setName(fd.getName());
                        folder.setURLName(fd.getURLName().toString());
                        this.saveFolder(username, accountId, folder, false);
                    }
                }
                List<Object> localFolders = new ArrayList();
                localFolders = parentFolder == null ? this.getFolders(username, accountId, true) : this.getSubFolders(username, accountId, parentFolder.getPath());
                for (Folder folder : localFolders) {
                    if (serverFolderId.contains(folder.getId())) continue;
                    this.deleteLocalFolder(username, accountId, folder.getId());
                }
                folderList.add(fd);
                if (fd.getType() != 2 && fd.list().length <= 0) continue;
                folderList.addAll(this.synchImapFolders(username, accountId, this.getFolder(username, accountId, folderId), fd.list()));
                continue;
            }
            Folder inbox = this.getFolder(username, accountId, Utils.generateFID(accountId, Utils.FD_INBOX, false));
            inbox.setURLName(fd.getURLName().toString());
            this.saveFolder(username, accountId, inbox, false);
        }
        return folderList;
    }

    private void saveFolder(String username, String accountId, Folder parentFolder, javax.mail.Folder serverFolder) throws Exception {
        String folderId = serverFolder.getType() != 2 ? Utils.generateFID(accountId, String.valueOf(((IMAPFolder)serverFolder).getUIDValidity()), true) : Utils.escapeIllegalJcrChars(serverFolder.getName());
        Folder folder = this.storage_.getFolder(username, accountId, folderId);
        if (folder == null) {
            folder = new Folder();
            folder.setId(folderId);
            folder.setName(serverFolder.getName());
            folder.setURLName(serverFolder.getURLName().toString());
            folder.setNumberOfUnreadMessage(0L);
            folder.setTotalMessage(0L);
            folder.setPersonalFolder(true);
            folder.setType(serverFolder.getType());
            try {
                if (parentFolder == null) {
                    this.storage_.saveFolder(username, accountId, folder);
                } else {
                    this.storage_.saveFolder(username, accountId, parentFolder.getId(), folder);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public IMAPStore openIMAPConnection(String username, Account account) {
        return this.openIMAPConnection(username, account, null);
    }

    public IMAPStore openIMAPConnection(String username, Account account, CheckingInfo info) {
        try {
            logger.debug((Object)(" #### Getting mail from " + account.getIncomingHost() + " ... !"));
            if (info != null) {
                info.setStatusMsg("Getting mail from " + account.getIncomingHost() + " ... !");
            }
            Properties props = System.getProperties();
            props.setProperty("mail.mime.base64.ignoreerrors", "true");
            String socketFactoryClass = "javax.net.SocketFactory";
            if (account.isIncomingSsl()) {
                socketFactoryClass = Utils.SSL_FACTORY;
            }
            props.setProperty("mail.imap.socketFactory.fallback", "false");
            props.setProperty("mail.imap.socketFactory.class", socketFactoryClass);
            Session session = Session.getInstance((Properties)props, null);
            IMAPStore imapStore = (IMAPStore)session.getStore("imap");
            try {
                imapStore.connect(account.getIncomingHost(), Integer.valueOf(account.getIncomingPort()).intValue(), account.getIncomingUser(), account.getIncomingPassword());
            }
            catch (AuthenticationFailedException e) {
                if (!account.isSavePassword()) {
                    account.setIncomingPassword("");
                    this.updateAccount(username, account);
                    logger.debug((Object)("Exception while connecting to server : " + e.getMessage()));
                }
                if (info != null) {
                    info.setStatusMsg("The username or password may be wrong.");
                    info.setStatusCode(103);
                }
                return null;
            }
            catch (MessagingException e) {
                logger.debug((Object)("Exception while connecting to server : " + e.getMessage()));
                if (info != null) {
                    info.setStatusMsg("Connecting failed. Please check server configuration.");
                    info.setStatusCode(102);
                }
                return null;
            }
            catch (Exception e) {
                logger.debug((Object)("Exception while connecting to server : " + e.getMessage()));
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                StringBuffer sb = sw.getBuffer();
                logger.error((Object)sb.toString());
                if (info != null) {
                    info.setStatusMsg("There was an unexpected error. Connecting failed.");
                    info.setStatusCode(102);
                }
                return null;
            }
            return imapStore;
        }
        catch (Exception ex) {
            System.out.println("Cannot connect to the server, please check your configuration ! ");
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void getSynchnizeImapServer(String username, String accountId, String folderId, boolean synchFolders) throws Exception {
        info = new CheckingInfo();
        key = username + ":" + accountId;
        this.checkingLog_.put(key, info);
        account = this.getAccountById(username, accountId);
        store = this.openIMAPConnection(username, account, info);
        if (store != null) {
            folderList /* !! */  = new ArrayList<E>();
            if (synchFolders) {
                info.setSyncFolderStatus(301);
                info.setStatusMsg("Synchronizing imap folder ...");
                folderList /* !! */  = this.synchImapFolders(username, accountId, null, store.getDefaultFolder().list());
                info.setSyncFolderStatus(302);
                info.setStatusMsg("Finished synchronizing imap folder ...");
            }
            if (!Utils.isEmptyField(folderId)) {
                fd = null;
                f = this.getFolder(username, accountId, folderId);
                if (f == null || Utils.isEmptyField(f.getURLName())) {
                    f = this.getFolder(username, accountId, Utils.generateFID(accountId, Utils.FD_INBOX, false));
                }
                try {
                    if (f == null || Utils.isEmptyField(f.getURLName()) || (fd = store.getFolder(url = new URLName(f.getURLName()))) == null) ** GOTO lbl48
                    this.synchImapMessage(username, accountId, fd, key);
                }
                catch (Exception e) {
                }
                finally {
                    this.checkingLog_.get(key).setStatusCode(200);
                    this.removeCheckingInfo(username, accountId);
                    store.close();
                }
            } else {
                for (javax.mail.Folder folder : folderList /* !! */ ) {
                    if (!Utils.isEmptyField(info.getRequestingForFolder_()) && !info.getRequestingForFolder_().equals("checkall")) break;
                    if (info.isRequestStop()) {
                        if (!MailServiceImpl.logger.isDebugEnabled()) break;
                        MailServiceImpl.logger.debug((Object)("Stop requested on checkmail for " + account.getId()));
                        break;
                    }
                    try {
                        this.synchImapMessage(username, accountId, folder, key);
                    }
                    catch (MessagingException e) {
                        System.err.println("Failed to open '" + folder.getName() + "' folder as read-only");
                        this.checkingLog_.get(key).setStatusCode(200);
                        this.removeCheckingInfo(username, accountId);
                        e.printStackTrace();
                    }
                }
                this.checkingLog_.get(key).setStatusCode(200);
                this.removeCheckingInfo(username, accountId);
            }
lbl48:
            // 4 sources

            if (!account.isSavePassword()) {
                account.setIncomingPassword("");
            }
            this.updateAccount(username, account);
            MailServiceImpl.logger.debug((Object)"/////////////////////////////////////////////////////////////");
            MailServiceImpl.logger.debug((Object)"/////////////////////////////////////////////////////////////");
        }
    }

    private void synchImapMessage(String username, String accountId, javax.mail.Folder folder, String key) throws Exception {
        Account account = this.getAccountById(username, accountId);
        boolean saved = false;
        int totalNew = -1;
        Info infoObj = new Info();
        ContinuationService continuation = Utils.getContinuationService();
        if (folder == null) {
            return;
        }
        try {
            folder.open(2);
            logger.debug((Object)(" #### Getting mails from folder " + folder.getName() + " !"));
            this.checkingLog_.get(key).setSyncFolderStatus(303);
            this.checkingLog_.get(key).setStatusMsg("Getting mails from folder " + folder.getName() + " !");
            String folderId = Utils.generateFID(accountId, String.valueOf(((IMAPFolder)folder).getUIDValidity()), true);
            if (folder.getName().equalsIgnoreCase(Utils.FD_INBOX)) {
                folderId = Utils.generateFID(accountId, Utils.FD_INBOX, false);
            }
            Folder eXoFolder = this.getFolder(username, accountId, folderId);
            Date lastCheckedDate = eXoFolder.getLastCheckedDate();
            Date lastCheckedFromDate = eXoFolder.getLastStartCheckingTime();
            Date checkFromDate = eXoFolder.getCheckFromDate();
            if (account.getCheckFromDate() == null) {
                checkFromDate = null;
            } else if (checkFromDate == null || checkFromDate.before(account.getCheckFromDate())) {
                checkFromDate = account.getCheckFromDate();
            }
            LinkedHashMap<Object, Object> msgMap = new LinkedHashMap();
            boolean isImap = account.getProtocol().equals(Utils.IMAP);
            boolean leaveOnserver = isImap && Boolean.valueOf(account.getServerProperties().get(Utils.SVR_LEAVE_ON_SERVER)) != false;
            msgMap = this.getMessageMap(username, accountId, folder, lastCheckedDate, checkFromDate, lastCheckedFromDate);
            totalNew = msgMap.size();
            logger.debug((Object)(" #### Folder " + folder.getName() + " contains " + totalNew + " messages !"));
            if (totalNew > 0) {
                int i = 0;
                Date lastFromDate = null;
                Date receivedDate = null;
                ArrayList<Object> msgList = new ArrayList<Object>(msgMap.keySet());
                SpamFilter spamFilter = this.getSpamFilter(username, account.getId());
                while (i < totalNew) {
                    block18: {
                        if (this.checkingLog_.get(key).isRequestStop()) {
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("Stop requested on checkmail for " + account.getId()));
                            break;
                        }
                        if (!Utils.isEmptyField(this.checkingLog_.get(key).getRequestingForFolder_()) && !String.valueOf(((IMAPFolder)folder).getUIDValidity()).equals(Utils.getFolderNameFromFolderId(this.checkingLog_.get(key).getRequestingForFolder_()))) break;
                        String[] folderIds = new String[]{folderId};
                        javax.mail.Message msg = (javax.mail.Message)msgList.get(i);
                        this.checkingLog_.get(key).setFetching(i + 1);
                        this.checkingLog_.get(key).setStatusMsg("Synchronizing  " + folder.getName() + " : " + (i + 1) + "/" + totalNew);
                        List filterList = (List)msgMap.get(msg);
                        try {
                            ArrayList<String> folderList = new ArrayList<String>();
                            ArrayList<String> tagList = new ArrayList<String>();
                            if (filterList != null && filterList.size() > 0) {
                                for (int j = 0; j < filterList.size(); ++j) {
                                    MessageFilter filter = this.getFilterById(username, accountId, (String)filterList.get(j));
                                    folderList.add(filter.getApplyFolder());
                                    String tagId = filter.getApplyTag();
                                    if (tagId == null || tagId.trim().length() <= 0) continue;
                                    tagList.add(tagId);
                                }
                                folderIds = folderList.toArray(new String[0]);
                            }
                            String folderStr = "";
                            for (int k = 0; k < folderIds.length; ++k) {
                                folderStr = folderStr + folderIds[k] + ",";
                            }
                            infoObj.setFolders(folderStr);
                            long msgUID = ((IMAPFolder)folder).getUID(msg);
                            saved = this.storage_.saveMessage(username, accountId, msgUID, msg, folderIds, tagList, spamFilter, infoObj, continuation, false);
                            if (saved && !leaveOnserver) {
                                msg.setFlag(Flags.Flag.DELETED, true);
                            }
                            receivedDate = MimeMessageParser.getReceivedDate(msg).getTime();
                            if (i == 0) {
                                lastFromDate = receivedDate;
                            }
                            eXoFolder.setLastCheckedDate(receivedDate);
                            if (i == totalNew - 1) {
                                eXoFolder.setCheckFromDate(lastFromDate);
                            }
                            if (lastFromDate == null || eXoFolder.getLastStartCheckingTime() != null && !eXoFolder.getLastStartCheckingTime().before(lastFromDate)) break block18;
                            eXoFolder.setLastStartCheckingTime(lastFromDate);
                        }
                        catch (Exception e) {
                            ++i;
                            continue;
                        }
                    }
                    ++i;
                }
                this.saveFolder(username, accountId, eXoFolder, false);
                FetchMailContentThread downloadContentMail = new FetchMailContentThread(this.storage_, msgMap, i, folder, username, accountId);
                new Thread(downloadContentMail).start();
            }
            this.checkingLog_.get(key).setStatusMsg("Finished download for " + folder.getName() + " folder.");
            logger.debug((Object)("#### Synchronization finished for " + folder.getName() + " folder."));
        }
        catch (Exception e) {
            logger.error((Object)("Error while checking emails from folder" + folder.getName() + " of username " + username + " on account " + accountId), (Throwable)e);
        }
    }

    private LinkedHashMap<javax.mail.Message, List<String>> getMessageMap(String username, String accountId, javax.mail.Folder folder, Date lastCheckedDate, Date checkFromDate, Date lastCheckedFromDate) throws Exception {
        LinkedHashMap<javax.mail.Message, List<String>> msgMap = new LinkedHashMap<javax.mail.Message, List<String>>();
        List<MessageFilter> filters = this.getFilters(username, accountId);
        if (checkFromDate == null) {
            if (lastCheckedDate != null && lastCheckedFromDate != null) {
                msgMap = this.getMessages(msgMap, folder, true, lastCheckedFromDate, null, filters);
                msgMap = this.getMessages(msgMap, folder, true, null, lastCheckedDate, filters);
            } else {
                msgMap = lastCheckedFromDate != null ? this.getMessages(msgMap, folder, true, lastCheckedFromDate, null, filters) : (lastCheckedDate != null ? this.getMessages(msgMap, folder, true, null, lastCheckedDate, filters) : this.getMessages(msgMap, folder, true, null, null, filters));
            }
        } else if (lastCheckedDate != null && lastCheckedFromDate != null) {
            msgMap = this.getMessages(msgMap, folder, true, lastCheckedFromDate, null, filters);
            msgMap = this.getMessages(msgMap, folder, true, checkFromDate, lastCheckedDate, filters);
        } else {
            msgMap = lastCheckedFromDate != null ? this.getMessages(msgMap, folder, true, lastCheckedFromDate, null, filters) : (lastCheckedDate != null && lastCheckedDate.after(checkFromDate) ? this.getMessages(msgMap, folder, true, checkFromDate, lastCheckedDate, filters) : this.getMessages(msgMap, folder, true, checkFromDate, null, filters));
        }
        return msgMap;
    }

    @Override
    public List<Message> checkNewMessage(String username, String accountId) throws Exception {
        return this.checkNewMessage(username, accountId, null);
    }

    @Override
    public List<Message> checkNewMessage(String username, String accountId, String folderId) throws Exception {
        Account account = this.getAccountById(username, accountId);
        ArrayList<Message> messageList = new ArrayList<Message>();
        if (account != null) {
            boolean isPop3 = account.getProtocol().equals(Utils.POP3);
            boolean isImap = account.getProtocol().equals(Utils.IMAP);
            if (isPop3) {
                return this.checkPop3Server(username, accountId);
            }
            if (isImap) {
                boolean synchFolder = this.getFolders(username, accountId, true).size() <= 0;
                this.getSynchnizeImapServer(username, accountId, folderId, synchFolder);
            }
        }
        return messageList;
    }

    public List<Message> checkPop3Server(String username, String accountId) throws Exception {
        Account account = this.getAccountById(username, accountId);
        ArrayList<Message> messageList = new ArrayList<Message>();
        if (account != null) {
            CheckingInfo info = new CheckingInfo();
            String key = username + ":" + accountId;
            this.checkingLog_.put(key, info);
            if (Utils.isEmptyField(account.getIncomingPassword())) {
                info.setStatusCode(103);
            }
            logger.debug((Object)(" #### Getting mail from " + account.getIncomingHost() + " ... !"));
            info.setStatusMsg("Getting mail from " + account.getIncomingHost() + " ... !");
            int totalNew = 0;
            String protocol = account.getProtocol();
            boolean isImap = account.getProtocol().equals(Utils.IMAP);
            try {
                String[] incomingFolders;
                Properties props = System.getProperties();
                props.setProperty("mail.mime.base64.ignoreerrors", "true");
                String socketFactoryClass = "javax.net.SocketFactory";
                if (account.isIncomingSsl()) {
                    socketFactoryClass = Utils.SSL_FACTORY;
                }
                if (protocol.equals(Utils.POP3)) {
                    props.setProperty("mail.pop3.socketFactory.fallback", "false");
                    props.setProperty("mail.pop3.socketFactory.class", socketFactoryClass);
                } else if (protocol.equals(Utils.IMAP)) {
                    props.setProperty("mail.imap.socketFactory.fallback", "false");
                    props.setProperty("mail.imap.socketFactory.class", socketFactoryClass);
                }
                Session session = Session.getInstance((Properties)props, null);
                for (String incomingFolder : incomingFolders = account.getIncomingFolder().split(",")) {
                    incomingFolder = incomingFolder.trim();
                    URLName storeURL = new URLName(account.getProtocol(), account.getIncomingHost(), Integer.valueOf(account.getIncomingPort()).intValue(), incomingFolder, account.getIncomingUser(), account.getIncomingPassword());
                    Store store = session.getStore(storeURL);
                    try {
                        store.connect();
                    }
                    catch (AuthenticationFailedException e) {
                        if (!account.isSavePassword()) {
                            account.setIncomingPassword("");
                            this.updateAccount(username, account);
                            logger.debug((Object)("Exception while connecting to server : " + e.getMessage()));
                        }
                        info.setStatusMsg("The username or password may be wrong.");
                        info.setStatusCode(103);
                        return messageList;
                    }
                    catch (MessagingException e) {
                        logger.debug((Object)("Exception while connecting to server : " + e.getMessage()));
                        info.setStatusMsg("Connecting failed. Please check server configuration.");
                        info.setStatusCode(102);
                        return messageList;
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Exception while connecting to server : " + e.getMessage()));
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        StringBuffer sb = sw.getBuffer();
                        logger.error((Object)sb.toString());
                        info.setStatusMsg("There was an unexpected error. Connecting failed.");
                        info.setStatusCode(102);
                        return messageList;
                    }
                    javax.mail.Folder folder = store.getFolder(storeURL.getFile());
                    if (!folder.exists()) {
                        logger.debug((Object)(" #### Folder " + incomingFolder + " is not exists !"));
                        info.setStatusMsg("Folder " + incomingFolder + " is not exists");
                        store.close();
                        continue;
                    }
                    logger.debug((Object)(" #### Getting mails from folder " + incomingFolder + " !"));
                    info.setStatusMsg("Getting mails from folder " + incomingFolder + " !");
                    folder.open(2);
                    Date lastCheckedDate = account.getLastCheckedDate();
                    Date lastCheckedFromDate = account.getLastStartCheckingTime();
                    Date checkFromDate = account.getCheckFromDate();
                    List<MessageFilter> filters = this.getFilters(username, accountId);
                    LinkedHashMap<javax.mail.Message, List<String>> msgMap = new LinkedHashMap<javax.mail.Message, List<String>>();
                    if (checkFromDate == null) {
                        if (lastCheckedDate != null && lastCheckedFromDate != null) {
                            msgMap = this.getMessages(msgMap, folder, isImap, lastCheckedFromDate, null, filters);
                            msgMap = this.getMessages(msgMap, folder, isImap, null, lastCheckedDate, filters);
                        } else {
                            msgMap = lastCheckedFromDate != null ? this.getMessages(msgMap, folder, isImap, lastCheckedFromDate, null, filters) : (lastCheckedDate != null ? this.getMessages(msgMap, folder, isImap, null, lastCheckedDate, filters) : this.getMessages(msgMap, folder, isImap, null, null, filters));
                        }
                    } else if (lastCheckedDate != null && lastCheckedFromDate != null) {
                        msgMap = this.getMessages(msgMap, folder, isImap, lastCheckedFromDate, null, filters);
                        msgMap = this.getMessages(msgMap, folder, isImap, checkFromDate, lastCheckedDate, filters);
                    } else {
                        msgMap = lastCheckedFromDate != null ? this.getMessages(msgMap, folder, isImap, lastCheckedFromDate, null, filters) : (lastCheckedDate != null && lastCheckedDate.after(checkFromDate) ? this.getMessages(msgMap, folder, isImap, checkFromDate, lastCheckedDate, filters) : this.getMessages(msgMap, folder, isImap, checkFromDate, null, filters));
                    }
                    totalNew = msgMap.size();
                    logger.debug((Object)"=============================================================");
                    logger.debug((Object)"=============================================================");
                    logger.debug((Object)(" #### Folder contains " + totalNew + " messages !"));
                    long tt1 = System.currentTimeMillis();
                    boolean saved = false;
                    if (totalNew > 0) {
                        boolean leaveOnServer = Boolean.valueOf(account.getServerProperties().get(Utils.SVR_LEAVE_ON_SERVER));
                        info.setTotalMsg(totalNew);
                        int i = 0;
                        Date lastFromDate = null;
                        Date receivedDate = null;
                        ArrayList<javax.mail.Message> msgList = new ArrayList<javax.mail.Message>(msgMap.keySet());
                        SpamFilter spamFilter = this.getSpamFilter(username, account.getId());
                        String folderId = this.makeStoreFolder(username, accountId, incomingFolder);
                        while (i < totalNew) {
                            long t1;
                            block35: {
                                if (info.isRequestStop()) {
                                    if (!logger.isDebugEnabled()) break;
                                    logger.debug((Object)("Stop requested on checkmail for " + account.getId()));
                                    break;
                                }
                                javax.mail.Message msg = (javax.mail.Message)msgList.get(i);
                                logger.debug((Object)("Fetching message " + (i + 1) + " ..."));
                                this.checkingLog_.get(key).setFetching(i + 1);
                                this.checkingLog_.get(key).setStatusMsg("Fetching message " + (i + 1) + "/" + totalNew);
                                t1 = System.currentTimeMillis();
                                List<String> filterList = msgMap.get(msg);
                                try {
                                    String[] folderIds = new String[]{folderId};
                                    ArrayList<String> folderList = new ArrayList<String>();
                                    ArrayList<String> tagList = new ArrayList<String>();
                                    if (filterList != null && filterList.size() > 0) {
                                        for (int j = 0; j < filterList.size(); ++j) {
                                            MessageFilter filter = this.getFilterById(username, accountId, filterList.get(j));
                                            folderList.add(filter.getApplyFolder());
                                            String tagId = filter.getApplyTag();
                                            if (tagId == null || tagId.trim().length() <= 0) continue;
                                            tagList.add(tagId);
                                        }
                                        folderIds = folderList.toArray(new String[0]);
                                    }
                                    if (saved = this.storage_.savePOP3Message(username, accountId, msg, folderIds, tagList, spamFilter, null, null)) {
                                        msg.setFlag(Flags.Flag.SEEN, true);
                                        if (!leaveOnServer) {
                                            msg.setFlag(Flags.Flag.DELETED, true);
                                        }
                                        String folderStr = "";
                                        for (int k = 0; k < folderIds.length; ++k) {
                                            folderStr = folderStr + folderIds[k] + ",";
                                        }
                                        this.checkingLog_.get(key).setFetchingToFolders(folderStr);
                                        this.checkingLog_.get(key).setMsgId(MimeMessageParser.getMessageId(msg));
                                    }
                                    receivedDate = MimeMessageParser.getReceivedDate(msg).getTime();
                                    if (i == 0) {
                                        lastFromDate = receivedDate;
                                    }
                                    account.setLastCheckedDate(receivedDate);
                                    if (i == totalNew - 1) {
                                        account.setCheckFromDate(lastFromDate);
                                    }
                                    if (lastFromDate == null || account.getLastStartCheckingTime() != null && !account.getLastStartCheckingTime().before(lastFromDate)) break block35;
                                    account.setLastStartCheckingTime(lastFromDate);
                                }
                                catch (Exception e) {
                                    this.checkingLog_.get(key).setStatusMsg("An error occurs while fetching messsge " + (i + 1));
                                    e.printStackTrace();
                                    ++i;
                                    continue;
                                }
                            }
                            long t2 = System.currentTimeMillis();
                            logger.debug((Object)("Message " + ++i + " saved : " + (t2 - t1) + " ms"));
                        }
                        long tt2 = System.currentTimeMillis();
                        logger.debug((Object)(" ### Check mail finished total took: " + (tt2 - tt1) + " ms"));
                    }
                    if (!account.isSavePassword()) {
                        account.setIncomingPassword("");
                    }
                    this.updateAccount(username, account);
                    folder.close(true);
                    store.close();
                    if (totalNew == 0) {
                        info.setStatusMsg("There is no new messages !");
                        continue;
                    }
                    info.setStatusMsg("Check mail finished !");
                }
                info.setStatusCode(200);
                this.removeCheckingInfo(username, accountId);
                logger.debug((Object)"/////////////////////////////////////////////////////////////");
                logger.debug((Object)"/////////////////////////////////////////////////////////////");
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)("Error while checking emails for " + username + " on account " + accountId), (Throwable)e);
            }
        }
        return messageList;
    }

    private String makeStoreFolder(String username, String accountId, String incomingFolder) throws Exception {
        String folderId = Utils.generateFID(accountId, incomingFolder, false);
        Folder storeFolder = this.storage_.getFolder(username, accountId, folderId);
        if (storeFolder == null) {
            folderId = Utils.generateFID(accountId, incomingFolder, true);
            Folder storeUserFolder = this.storage_.getFolder(username, accountId, folderId);
            storeFolder = storeUserFolder != null ? storeUserFolder : new Folder();
            storeFolder.setId(folderId);
            storeFolder.setName(incomingFolder);
            storeFolder.setPersonalFolder(true);
            this.storage_.saveFolder(username, accountId, storeFolder);
        }
        return folderId;
    }

    public SearchTerm getSearchTerm(SearchTerm sTerm, MessageFilter filter) throws Exception {
        if (!Utils.isEmptyField(filter.getFrom())) {
            FromStringTerm fsTerm = new FromStringTerm(filter.getFrom());
            if (filter.getFromCondition() == 0) {
                sTerm = sTerm == null ? fsTerm : new AndTerm(sTerm, (SearchTerm)fsTerm);
            } else if (filter.getFromCondition() == 1) {
                sTerm = sTerm == null ? new NotTerm((SearchTerm)fsTerm) : new AndTerm(sTerm, (SearchTerm)new NotTerm((SearchTerm)fsTerm));
            }
        }
        if (!Utils.isEmptyField(filter.getTo())) {
            RecipientStringTerm toTerm = new RecipientStringTerm(MimeMessage.RecipientType.TO, filter.getTo());
            if (filter.getToCondition() == 0) {
                sTerm = sTerm == null ? toTerm : new AndTerm(sTerm, (SearchTerm)toTerm);
            } else if (filter.getToCondition() == 1) {
                sTerm = sTerm == null ? new NotTerm((SearchTerm)toTerm) : new AndTerm(sTerm, (SearchTerm)new NotTerm((SearchTerm)toTerm));
            }
        }
        if (!Utils.isEmptyField(filter.getSubject())) {
            SubjectTerm subjectTerm = new SubjectTerm(filter.getSubject());
            if (filter.getSubjectCondition() == 0) {
                sTerm = sTerm == null ? subjectTerm : new AndTerm(sTerm, (SearchTerm)subjectTerm);
            } else if (filter.getSubjectCondition() == 1) {
                sTerm = sTerm == null ? new NotTerm((SearchTerm)subjectTerm) : new AndTerm(sTerm, (SearchTerm)new NotTerm((SearchTerm)subjectTerm));
            }
        }
        if (!Utils.isEmptyField(filter.getBody())) {
            BodyTerm bodyTerm = new BodyTerm(filter.getBody());
            if (filter.getBodyCondition() == 0) {
                sTerm = sTerm == null ? bodyTerm : new AndTerm(sTerm, (SearchTerm)bodyTerm);
            } else if (filter.getBodyCondition() == 1) {
                sTerm = sTerm == null ? new NotTerm((SearchTerm)bodyTerm) : new AndTerm(sTerm, (SearchTerm)new NotTerm((SearchTerm)bodyTerm));
            }
        }
        return sTerm;
    }

    @Override
    public void createAccount(String username, Account account) throws Exception {
        this.saveAccount(username, account, true);
    }

    @Override
    public List<Folder> getFolders(String username, String accountId) throws Exception {
        return this.storage_.getFolders(username, accountId);
    }

    @Override
    public List<Folder> getFolders(String username, String accountId, boolean isPersonal) throws Exception {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        for (Folder folder : this.storage_.getFolders(username, accountId)) {
            if (isPersonal) {
                if (!folder.isPersonalFolder()) continue;
                folders.add(folder);
                continue;
            }
            if (folder.isPersonalFolder()) continue;
            folders.add(folder);
        }
        return folders;
    }

    @Override
    public void addTag(String username, String accountId, Tag tag) throws Exception {
        this.storage_.addTag(username, accountId, tag);
    }

    @Override
    public void addTag(String username, String accountId, List<Message> messages, List<Tag> tag) throws Exception {
        this.storage_.addTag(username, accountId, messages, tag);
    }

    @Override
    public List<Tag> getTags(String username, String accountId) throws Exception {
        return this.storage_.getTags(username, accountId);
    }

    @Override
    public Tag getTag(String username, String accountId, String tagId) throws Exception {
        return this.storage_.getTag(username, accountId, tagId);
    }

    @Override
    public void removeTagsInMessages(String username, String accountId, List<Message> msgList, List<String> tagIdList) throws Exception {
        this.storage_.removeTagsInMessages(username, accountId, msgList, tagIdList);
    }

    @Override
    public void removeTag(String username, String accountId, String tag) throws Exception {
        this.storage_.removeTag(username, accountId, tag);
    }

    @Override
    public void updateTag(String username, String accountId, Tag tag) throws Exception {
        this.storage_.updateTag(username, accountId, tag);
    }

    @Override
    public List<Message> getMessageByTag(String username, String accountId, String tagName) throws Exception {
        return this.storage_.getMessageByTag(username, accountId, tagName);
    }

    @Override
    public MessagePageList getMessagePagelistByTag(String username, String accountId, String tagId) throws Exception {
        MessageFilter filter = new MessageFilter("Filter By Tag");
        filter.setAccountId(accountId);
        filter.setTag(new String[]{tagId});
        return this.getMessagePageList(username, filter);
    }

    @Override
    public MessagePageList getMessagePageListByFolder(String username, String accountId, String folderId) throws Exception {
        MessageFilter filter = new MessageFilter("Filter By Folder");
        filter.setAccountId(accountId);
        filter.setFolder(new String[]{folderId});
        return this.getMessagePageList(username, filter);
    }

    @Override
    public MailSetting getMailSetting(String username) throws Exception {
        return this.storage_.getMailSetting(username);
    }

    @Override
    public void saveMailSetting(String username, MailSetting newSetting) throws Exception {
        this.storage_.saveMailSetting(username, newSetting);
    }

    @Override
    public boolean importMessage(String username, String accountId, String folderId, InputStream inputStream, String type) throws Exception {
        return this.emlImportExport_.importMessage(username, accountId, folderId, inputStream, type);
    }

    @Override
    public OutputStream exportMessage(String username, String accountId, Message message) throws Exception {
        return this.emlImportExport_.exportMessage(username, accountId, message);
    }

    @Override
    public SpamFilter getSpamFilter(String username, String accountId) throws Exception {
        return this.storage_.getSpamFilter(username, accountId);
    }

    @Override
    public void saveSpamFilter(String username, String accountId, SpamFilter spamFilter) throws Exception {
        this.storage_.saveSpamFilter(username, accountId, spamFilter);
    }

    @Override
    public void toggleMessageProperty(String username, String accountId, List<Message> msgList, String folderId, String property, boolean value) throws Exception {
        Account account = this.getAccountById(username, accountId);
        Folder folder = this.getFolder(username, accountId, folderId);
        boolean success = true;
        if (account.getProtocol().equalsIgnoreCase(Utils.IMAP)) {
            try {
                ImapConnector connector = new ImapConnector(account);
                if (property.equals(Utils.EXO_STAR)) {
                    if (folder != null && !Utils.isEmptyField(folder.getName())) {
                        success = connector.setIsStared(msgList, value, folder);
                    } else {
                        for (Message m : msgList) {
                            folder = this.getFolder(username, accountId, m.getFolders()[0]);
                            if (folder == null) continue;
                            ArrayList<Message> l = new ArrayList<Message>();
                            l.add(m);
                            success = connector.setIsStared(l, value, folder);
                        }
                    }
                } else if (property.equals(Utils.EXO_ISUNREAD)) {
                    if (folder != null && !Utils.isEmptyField(folder.getName())) {
                        success = value ? connector.markAsUnread(msgList, folder) : connector.markAsRead(msgList, folder);
                    } else {
                        for (Message m : msgList) {
                            folder = this.getFolder(username, accountId, m.getFolders()[0]);
                            if (folder == null) continue;
                            ArrayList<Message> l = new ArrayList<Message>();
                            l.add(m);
                            if (value) {
                                success = connector.markAsUnread(l, folder);
                                continue;
                            }
                            success = connector.markAsRead(l, folder);
                        }
                    }
                }
            }
            catch (Exception e) {
                return;
            }
        }
        if (success) {
            this.storage_.toggleMessageProperty(username, accountId, msgList, property, value);
        }
    }

    public List<AccountData> getAccountDatas(SessionProvider sProvider) throws Exception {
        return null;
    }

    @Override
    public String getFolderHomePath(String username, String accountId) throws Exception {
        return this.storage_.getFolderHomePath(username, accountId);
    }

    @Override
    public List<Folder> getSubFolders(String username, String accountId, String parentPath) throws Exception {
        return this.storage_.getSubFolders(username, accountId, parentPath);
    }

    @Override
    public List<Message> getReferencedMessages(String username, String accountId, String msgPath) throws Exception {
        return this.storage_.getReferencedMessages(username, accountId, msgPath);
    }

    @Override
    public Account getDefaultAccount(String username) throws Exception {
        MailSetting mailSetting = this.storage_.getMailSetting(username);
        String defaultAccount = mailSetting.getDefaultAccount();
        Account account = null;
        if (defaultAccount != null) {
            account = this.getAccountById(username, defaultAccount);
        } else {
            List<Account> accList = this.getAccounts(username);
            if (accList.size() > 0) {
                account = this.getAccounts(username).get(0);
            }
        }
        return account;
    }

    @Override
    public Message loadTotalMessage(String username, String accountId, Message msg) throws Exception {
        Account account = this.getAccountById(username, accountId);
        try {
            IMAPStore store = this.openIMAPConnection(username, account);
            if (!msg.isLoaded() && store != null) {
                javax.mail.Message message = null;
                javax.mail.Folder fd = null;
                URLName url = new URLName(this.getFolder(username, accountId, msg.getFolders()[0]).getURLName());
                fd = store.getFolder(url);
                if (fd != null) {
                    if (fd.isOpen()) {
                        message = ((IMAPFolder)fd).getMessageByUID(Long.valueOf(msg.getUID()).longValue());
                        this.storage_.saveTotalMessage(username, accountId, msg.getId(), message, null);
                    } else {
                        fd.open(2);
                        message = ((IMAPFolder)fd).getMessageByUID(Long.valueOf(msg.getUID()).longValue());
                        this.storage_.saveTotalMessage(username, accountId, msg.getId(), message, null);
                        fd.close(true);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)"Download content failure");
        }
        return this.storage_.loadTotalMessage(username, accountId, msg);
    }

    public void start() {
        for (MailUpdateStorageEventListener updateListener : this.listeners_) {
            updateListener.preUpdate();
        }
    }

    public void stop() {
    }

    @Override
    public synchronized void addListenerPlugin(ComponentPlugin listener) throws Exception {
        if (listener instanceof MailUpdateStorageEventListener) {
            this.listeners_.add((MailUpdateStorageEventListener)listener);
        }
    }

    private Properties getAccountProperties(Account acc) {
        Properties props = new Properties();
        String smtpUser = acc.getIncomingUser();
        String outgoingHost = acc.getOutgoingHost();
        String outgoingPort = acc.getOutgoingPort();
        String isSSl = acc.getServerProperties().get(Utils.SVR_OUTGOING_SSL);
        props.put(Utils.SVR_SMTP_USER, smtpUser);
        props.put(Utils.SVR_SMTP_HOST, outgoingHost);
        props.put(Utils.SVR_SMTP_PORT, outgoingPort);
        props.put("mail.smtp.dsn.notify", "SUCCESS,FAILURE ORCPT=rfc822;" + acc.getEmailAddress());
        props.put("mail.smtp.dsn.ret", "FULL");
        props.put("mail.smtp.socketFactory.port", outgoingPort);
        props.put(Utils.SVR_SMTP_AUTH, "true");
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_FALLBACK, "true");
        props.put("mail.smtp.connectiontimeout", "0");
        props.put("mail.smtp.timeout", "0");
        String socketFactoryClass = "javax.net.SocketFactory";
        if (Boolean.valueOf(isSSl).booleanValue()) {
            socketFactoryClass = Utils.SSL_FACTORY;
            props.put(Utils.SVR_SMTP_STARTTLS_ENABLE, "true");
            props.put("mail.smtp.ssl.protocols", "SSLv3 TLSv1");
        }
        props.put(Utils.SVR_SMTP_SOCKET_FACTORY_CLASS, socketFactoryClass);
        return props;
    }

    @Override
    public boolean sendReturnReceipt(String username, String accId, String msgId, ResourceBundle res) throws Exception {
        Account acc = this.getAccountById(username, accId);
        Message msg = this.getMessageById(username, accId, msgId);
        String subject = new String("Disposition notification");
        String text = new String("The message sent on {0} to {1} with subject \"{2}\" has been displayed. This is no guarantee that the message has been read or understood.");
        if (res != null) {
            try {
                subject = res.getString("UIMessagePreview.msg.return-receipt-subject");
            }
            catch (MissingResourceException e) {
                subject = new String("Disposition notification");
                e.printStackTrace();
            }
            try {
                text = res.getString("UIMessagePreview.msg.return-receipt-text");
            }
            catch (MissingResourceException e) {
                text = new String("The message sent on {0} to {1} with subject \"{2}\" has been displayed. This is no guarantee that the message has been read or understood.");
                e.printStackTrace();
            }
        }
        text = text.replace("{0}", msg.getSendDate().toString());
        text = text.replace("{1}", msg.getMessageTo());
        text = text.replace("{2}", msg.getSubject());
        Message receiptMsg = new Message();
        receiptMsg.setMessageTo(msg.getFrom());
        receiptMsg.setSubject(subject);
        receiptMsg.setSendDate(new Date());
        DispositionNotification disNotification = new DispositionNotification();
        disNotification.getNotifications().setHeader("Reporting-UA", "cs.exoplatform.com; CS-Mail");
        disNotification.getNotifications().setHeader("MDN-Gateway", "smtp; " + acc.getOutgoingHost());
        disNotification.getNotifications().setHeader("Original-Recipient", "rfc822; " + msg.getFrom());
        disNotification.getNotifications().setHeader("Final-Recipient", "rfc822; " + acc.getUserDisplayName() + "<" + acc.getEmailAddress() + ">");
        disNotification.getNotifications().setHeader("Original-Message-ID", msg.getId());
        disNotification.getNotifications().setHeader("Disposition", "manual-action/MDN-sent-automatically; displayed");
        MultipartReport report = new MultipartReport(text, disNotification);
        Properties props = this.getAccountProperties(acc);
        Session session = Session.getInstance((Properties)props, null);
        logger.debug((Object)" #### Sending email ... ");
        SMTPTransport transport = (SMTPTransport)session.getTransport("smtp");
        try {
            if (!acc.isOutgoingAuthentication()) {
                transport.connect();
            } else if (acc.useIncomingSettingForOutgoingAuthent()) {
                transport.connect(acc.getOutgoingHost(), Integer.parseInt(acc.getOutgoingPort()), acc.getIncomingUser(), acc.getIncomingPassword());
            } else {
                transport.connect(acc.getOutgoingHost(), Integer.parseInt(acc.getOutgoingPort()), acc.getOutgoingUserName(), acc.getOutgoingPassword());
            }
        }
        catch (Exception ex) {
            logger.debug((Object)"#### Can not connect to smtp server ...");
            throw ex;
        }
        MailcapCommandMap mailcap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcap.addMailcap("message/disposition-notification;; x-java-content-handler=org.exoplatform.mail.service.impl.Message_DispositionNotification");
        CommandMap.setDefaultCommandMap((CommandMap)mailcap);
        this.sendReturnReceipt(session, (Transport)transport, receiptMsg, report);
        transport.close();
        return true;
    }

    private void sendReturnReceipt(Session session, Transport transport, Message message, MultipartReport report) throws Exception {
        MimeMessage mimeMessage = new MimeMessage(session);
        String status = "";
        mimeMessage.setHeader("Message-ID", message.getId());
        mimeMessage.setHeader("Content-Transfer-Encoding", "utf-8");
        InternetAddress addressFrom = message.getFrom() != null ? new InternetAddress(message.getFrom()) : new InternetAddress(session.getProperties().getProperty(Utils.SVR_SMTP_USER));
        mimeMessage.setFrom((Address)addressFrom);
        if (message.getMessageTo() != null) {
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)message.getMessageTo()));
        }
        mimeMessage.setSubject(message.getSubject(), "UTF-8");
        mimeMessage.setSentDate(message.getSendDate());
        mimeMessage.setContent((Multipart)report);
        mimeMessage.saveChanges();
        try {
            transport.sendMessage((javax.mail.Message)mimeMessage, mimeMessage.getAllRecipients());
            status = "Mail Delivered !";
        }
        catch (AddressException e) {
            status = "There was an error parsing the addresses. Sending Failed !" + e.getMessage();
            throw e;
        }
        catch (AuthenticationFailedException e) {
            status = "The Username or Password may be wrong. Sending Failed !" + e.getMessage();
            throw e;
        }
        catch (SMTPSendFailedException e) {
            status = "Sorry, There was an error sending the message. Sending Failed !" + e.getMessage();
            throw e;
        }
        catch (MessagingException e) {
            status = "There was an unexpected error. Sending Failed ! " + e.getMessage();
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            status = "There was an unexpected error. Sending Falied !" + e.getMessage();
            throw e;
        }
        logger.debug((Object)(" #### Info : " + status));
    }
}

