/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service.bench;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.service.bench.SimpleMailServerInitializer;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailDataInjector
extends DataInjector {
    private static Log log = ExoLogger.getExoLogger(MailDataInjector.class);
    public static final String FD_INBOX = "Inbox".intern();
    public static final String FD_DRAFTS = "Drafts".intern();
    public static final String FD_SENT = "Sent".intern();
    public static final String FD_SPAM = "Spam".intern();
    public static final String FD_TRASH = "Trash".intern();
    public static final String[] defaultFolders_ = new String[]{FD_INBOX, FD_DRAFTS, FD_SENT, FD_SPAM, FD_TRASH};
    private MailService mailService;
    private SimpleMailServerInitializer mailServerInitializer;
    private int maxAccounts = 2;
    private int maxMessages = 100;
    private int attachmentSize = 100;
    private boolean randomize = false;
    private Random random = new Random();
    private Stack<String> accountsStack = new Stack();

    public MailDataInjector(MailService mailService, SimpleMailServerInitializer mailServerInitializer, InitParams initParams) {
        this.mailService = mailService;
        this.mailServerInitializer = mailServerInitializer;
        this.initParams(initParams);
    }

    private Account newAccount(Account previous) {
        String username = IdGenerator.generate();
        String email = username + "@example.com";
        Account account = new Account();
        account.setIncomingUser(email);
        account.setLabel(username);
        account.setIncomingPassword("password");
        account.setUseIncomingForAuthentication(true);
        account.setEmailAddress(email);
        account.setIncomingHost(this.mailServerInitializer.getHost());
        if (previous != null) {
            if (previous.getProtocol().equals("imap")) {
                account.setProtocol("pop3");
                account.setIncomingPort(this.mailServerInitializer.getPop3Port());
            } else {
                account.setProtocol("imap");
                account.setIncomingPort(this.mailServerInitializer.getImapPort());
            }
        } else {
            account.setProtocol("pop3");
            account.setIncomingPort(this.mailServerInitializer.getPop3Port());
        }
        account.setOutgoingHost(this.mailServerInitializer.getHost());
        account.setOutgoingPort(this.mailServerInitializer.getSmtpPort());
        account.setUserDisplayName(this.randomWords(3));
        account.setDescription(this.randomWords(10));
        account.setIsSavePassword(true);
        account.setAuthMechsIncoming("starttls");
        account.setAuthMechsOutgoing("starttls");
        account.setIncomingSsl(true);
        account.setOutgoingSsl(true);
        account.setSecureAuthsIncoming("starttls");
        account.setSecureAuthsOutgoing("starttls");
        account.setIncomingFolder(FD_INBOX);
        account.setCheckAll(true);
        return account;
    }

    private int maxAccounts() {
        return this.randomize ? this.random.nextInt(this.maxAccounts) : this.maxAccounts;
    }

    private int maxMessages() {
        return this.randomize ? this.random.nextInt(this.maxMessages) : this.maxMessages;
    }

    private List<Folder> generateDefaultFolders() {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        for (String folderName : defaultFolders_) {
            Folder folder = new Folder();
            folder.setName(folderName);
            folder.setPersonalFolder(false);
            folders.add(folder);
        }
        return folders;
    }

    private List<Account> generateAccounts() {
        ArrayList<Account> accounts = new ArrayList<Account>();
        Account previous = null;
        for (int i = 0; i < this.maxAccounts(); ++i) {
            Account account = this.newAccount(previous);
            accounts.add(account);
            previous = account;
        }
        return accounts;
    }

    public Log getLog() {
        return log;
    }

    public boolean isInitialized() {
        return false;
    }

    public void initParams(InitParams initParams) {
        ValueParam param = initParams.getValueParam("mA");
        if (param != null) {
            this.maxAccounts = Integer.parseInt(param.getValue());
        }
        if ((param = initParams.getValueParam("mM")) != null) {
            this.maxMessages = Integer.parseInt(param.getValue());
        }
        if ((param = initParams.getValueParam("attSize")) != null) {
            this.attachmentSize = Integer.parseInt(param.getValue());
        }
        if ((param = initParams.getValueParam("rand")) != null) {
            this.randomize = Boolean.parseBoolean(param.getValue());
        }
    }

    public void inject() throws Exception {
        String username = ConversationState.getCurrent().getIdentity().getUserId();
        List<Account> accounts = this.generateAccounts();
        int accSize = accounts.size();
        byte[] attachment = this.createTextResource(this.attachmentSize).getBytes();
        for (int i = 0; i < accSize; ++i) {
            log.info((Object)("\tCreate account " + (i + 1) + "/" + accSize + " ...... "));
            Account account = accounts.get(i);
            this.mailService.createAccount(username, account);
            this.mailServerInitializer.addUser(account.getEmailAddress(), account.getIncomingPassword());
            this.accountsStack.push(account.getId());
            List<Folder> folders = this.generateDefaultFolders();
            int folderSize = folders.size();
            for (int j = 0; j < folderSize; ++j) {
                Folder folder = folders.get(j);
                log.info((Object)("\t\tCreate Folder " + folder.getName() + " ....... "));
                folder.setId(Utils.generateFID(account.getId(), folder.getName(), false));
                this.mailService.saveFolder(username, account.getId(), folder);
                if (!folder.getName().equalsIgnoreCase(FD_INBOX)) continue;
                int msgsNum = this.maxMessages();
                log.info((Object)("\t\t\t Pouring " + msgsNum + " messages into INBOX folder ........."));
                for (int k = 0; k < msgsNum; ++k) {
                    log.info((Object)("\t\t\t\t Sending message " + k + "/" + msgsNum + " ........."));
                    this.mailServerInitializer.sendMailMessage(account.getEmailAddress(), account.getEmailAddress(), this.randomWords(100), this.randomParagraphs(4), attachment, "filename" + IdGenerator.generate() + ".txt", null);
                }
            }
            log.info((Object)"\t\t\t Pulling messages from mail server to eXo Mail ........");
            this.mailService.checkNewMessage(username, account.getId(), FD_INBOX);
            log.info((Object)String.format("\tAccount %1$s has been created successfully!", account.getEmailAddress()));
        }
    }

    public void reject() throws Exception {
        String username = ConversationState.getCurrent().getIdentity().getUserId();
        while (!this.accountsStack.isEmpty()) {
            String accId = this.accountsStack.pop();
            log.info((Object)("\tRemove account " + accId + " ............. "));
            this.mailService.removeAccount(username, accId);
        }
        log.info((Object)"\tAccounts have been removed successfully!");
    }
}

