/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service;

import java.util.Calendar;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.services.jcr.util.IdGenerator;

public class MessageFilter {
    private String id_ = Utils.KEY_FILTER + IdGenerator.generate();
    private String name_;
    private String accountId_;
    private String to_;
    private int toCondition_;
    private String from_;
    private int fromCondition_;
    private String subject_;
    private int subjectCondition_;
    private String body_;
    private int bodyCondition_;
    private String[] excludeFolders_;
    private String[] folders_;
    private String[] tags_;
    private String viewQuery_;
    private String accountPath_;
    private String orderBy_;
    private boolean isAscending_;
    private Calendar fromDate_;
    private Calendar toDate_;
    private boolean hasAttach_;
    private boolean hasStar_;
    private long priority_;
    private String text_;
    private String applyFolder_;
    private String applyTag_;
    private boolean keepInbox_;
    private boolean applyForAll_;
    private boolean hasStructure_;
    private String[] returnedProperties;

    public MessageFilter(String name) {
        this.name_ = name;
        this.toCondition_ = 0;
        this.fromCondition_ = 0;
        this.subjectCondition_ = 0;
        this.bodyCondition_ = 0;
        this.hasAttach_ = false;
        this.hasStar_ = false;
        this.priority_ = 0L;
        this.isAscending_ = false;
        this.orderBy_ = Utils.EXO_LAST_CHECKED_TIME;
        this.hasStructure_ = false;
    }

    public String getId() {
        return this.id_;
    }

    public void setId(String id) {
        this.id_ = id;
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public String getAccountId() {
        return this.accountId_;
    }

    public void setAccountId(String id) {
        this.accountId_ = id;
    }

    public String[] getExcludeFolders() {
        return this.excludeFolders_;
    }

    public void setExcludeFolders(String[] folders) {
        this.excludeFolders_ = folders;
    }

    public String[] getFolder() {
        return this.folders_;
    }

    public void setFolder(String[] folder) {
        this.folders_ = folder;
    }

    public String[] getTag() {
        return this.tags_;
    }

    public void setTag(String[] tag) {
        this.tags_ = tag;
    }

    public String getFrom() {
        return this.from_;
    }

    public void setFrom(String from) {
        this.from_ = from;
    }

    public int getFromCondition() {
        return this.fromCondition_;
    }

    public void setFromCondition(int i) {
        this.fromCondition_ = i;
    }

    public String getTo() {
        return this.to_;
    }

    public void setTo(String emailTo) {
        this.to_ = emailTo;
    }

    public int getToCondition() {
        return this.toCondition_;
    }

    public void setToCondition(int i) {
        this.toCondition_ = i;
    }

    public String getSubject() {
        return this.subject_;
    }

    public void setSubject(String subject) {
        this.subject_ = subject;
    }

    public int getSubjectCondition() {
        return this.subjectCondition_;
    }

    public void setSubjectCondition(int i) {
        this.subjectCondition_ = i;
    }

    public String getBody() {
        return this.body_;
    }

    public void setBody(String body) {
        this.body_ = body;
    }

    public int getBodyCondition() {
        return this.bodyCondition_;
    }

    public void setBodyCondition(int i) {
        this.bodyCondition_ = i;
    }

    public String getViewQuery() {
        return this.viewQuery_;
    }

    public void setViewQuery(String query) {
        this.viewQuery_ = query;
    }

    public String getAccountPath() {
        return this.accountPath_;
    }

    public void setAccountPath(String path) {
        this.accountPath_ = path;
    }

    public String getOrderBy() {
        return this.orderBy_;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy_ = orderBy;
    }

    public boolean isAscending() {
        return this.isAscending_;
    }

    public void setAscending(boolean b) {
        this.isAscending_ = b;
    }

    public Calendar getFromDate() {
        return this.fromDate_;
    }

    public void setFromDate(Calendar date) {
        this.fromDate_ = date;
    }

    public Calendar getToDate() {
        return this.toDate_;
    }

    public void setToDate(Calendar date) {
        this.toDate_ = date;
    }

    public boolean hasStar() {
        return this.hasStar_;
    }

    public void setHasStar(boolean b) {
        this.hasStar_ = b;
    }

    public boolean hasAttach() {
        return this.hasAttach_;
    }

    public void setHasAttach(boolean b) {
        this.hasAttach_ = b;
    }

    public long getPriority() {
        return this.priority_;
    }

    public void setPriority(long l) {
        this.priority_ = l;
    }

    public String getApplyFolder() {
        return this.applyFolder_;
    }

    public void setApplyFolder(String folder) {
        this.applyFolder_ = folder;
    }

    public String getApplyTag() {
        return this.applyTag_;
    }

    public void setApplyTag(String tag) {
        this.applyTag_ = tag;
    }

    public Boolean keepInInbox() {
        return this.keepInbox_;
    }

    public void setKeepInInbox(boolean keepInbox) {
        this.keepInbox_ = keepInbox;
    }

    public Boolean applyForAll() {
        return this.applyForAll_;
    }

    public void setApplyForAll(boolean b) {
        this.applyForAll_ = b;
    }

    public String getText() {
        return this.text_;
    }

    public void setText(String text) {
        this.text_ = text;
    }

    public boolean hasStructure() {
        return this.hasStructure_;
    }

    public void setHasStructure(boolean hasStructure) {
        this.hasStructure_ = hasStructure;
    }

    public String[] getReturnedProperties() {
        return this.returnedProperties;
    }

    public void setReturnedProperties(String[] returnedProperties) {
        this.returnedProperties = returnedProperties;
    }

    public String getStatement() throws Exception {
        int i;
        StringBuffer queryString = new StringBuffer("/jcr:root" + this.accountPath_ + "//element(*,exo:message)");
        StringBuilder columnSpecifier = new StringBuilder();
        if (this.returnedProperties != null && this.returnedProperties.length > 0) {
            if (this.returnedProperties.length == 1) {
                columnSpecifier.append("/@" + this.returnedProperties[0]);
            } else {
                columnSpecifier.append("/(@" + this.returnedProperties[0]);
            }
            for (int i2 = 1; i2 < this.returnedProperties.length; ++i2) {
                columnSpecifier.append(" | @" + this.returnedProperties[i2]);
            }
            if (this.returnedProperties.length > 1) {
                columnSpecifier.append(")");
            }
        }
        queryString.append((CharSequence)columnSpecifier);
        boolean hasConjuntion = false;
        StringBuffer stringBuffer = new StringBuffer("[");
        if (this.text_ != null && this.text_.trim().length() > 0) {
            this.text_ = Utils.encodeJCRTextSearch(this.text_);
            stringBuffer.append("jcr:contains(., '").append(this.text_).append("')");
            hasConjuntion = true;
        }
        if (this.excludeFolders_ != null && this.excludeFolders_.length > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            for (i = 0; i < this.excludeFolders_.length; ++i) {
                if (i == 0) {
                    stringBuffer.append("@exo:folders!='" + this.excludeFolders_[i] + "'");
                    continue;
                }
                stringBuffer.append(" and @exo:folders!='" + this.excludeFolders_[i] + "'");
            }
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.folders_ != null && this.folders_.length > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            for (i = 0; i < this.folders_.length; ++i) {
                if (i == 0) {
                    stringBuffer.append("@exo:folders='" + this.folders_[i] + "'");
                    continue;
                }
                stringBuffer.append(" or @exo:folders='" + this.folders_[i] + "'");
            }
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.tags_ != null && this.tags_.length > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            for (i = 0; i < this.tags_.length; ++i) {
                if (i == 0) {
                    stringBuffer.append("@exo:tags='" + this.tags_[i] + "'");
                    continue;
                }
                stringBuffer.append(" or @exo:tags='" + this.tags_[i] + "'");
            }
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.from_ != null && this.from_.trim().length() > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            switch (this.getFromCondition()) {
                case 0: {
                    stringBuffer.append(" jcr:like(@exo:from, '%" + this.from_ + "%')");
                    break;
                }
                case 1: {
                    stringBuffer.append(" fn:not(jcr:like(@exo:from, '%" + this.from_ + "%'))");
                    break;
                }
                case 2: {
                    stringBuffer.append(" @exo:from = '" + this.from_ + "'");
                    break;
                }
                case 3: {
                    stringBuffer.append(" @exo:from != '" + this.from_ + "'");
                    break;
                }
                case 4: {
                    stringBuffer.append(" jcr:like(@exo:from, '" + this.from_ + "%')");
                    break;
                }
                case 5: {
                    stringBuffer.append(" jcr:like(@exo:from, '%" + this.from_ + "')");
                }
            }
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.to_ != null && this.to_.trim().length() > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            switch (this.getToCondition()) {
                case 0: {
                    stringBuffer.append(" jcr:like(@exo:to, '%" + this.to_ + "%')");
                    break;
                }
                case 1: {
                    stringBuffer.append(" fn:not(jcr:like(@exo:to, '%" + this.to_ + "%'))");
                    break;
                }
                case 2: {
                    stringBuffer.append(" @exo:to = '" + this.to_ + "'");
                    break;
                }
                case 3: {
                    stringBuffer.append(" @exo:to != '" + this.to_ + "'");
                    break;
                }
                case 4: {
                    stringBuffer.append(" jcr:like(@exo:to, '" + this.to_ + "%')");
                    break;
                }
                case 5: {
                    stringBuffer.append(" jcr:like(@exo:to, '%" + this.to_ + "')");
                }
            }
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.subject_ != null && this.subject_.trim().length() > 0) {
            this.subject_ = Utils.encodeJCRTextSearch(this.subject_);
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            switch (this.getSubjectCondition()) {
                case 0: {
                    stringBuffer.append(" jcr:contains(@exo:subject, '" + this.subject_ + "')");
                    break;
                }
                case 1: {
                    stringBuffer.append(" fn:not(jcr:contains(@exo:subject, '" + this.subject_ + "'))");
                    break;
                }
                case 2: {
                    stringBuffer.append(" @exo:subject = '" + this.subject_ + "'");
                    break;
                }
                case 3: {
                    stringBuffer.append(" @exo:subject != '" + this.subject_ + "'");
                    break;
                }
                case 4: {
                    stringBuffer.append(" jcr:like(@exo:subject, '" + this.subject_ + "%')");
                    break;
                }
                case 5: {
                    stringBuffer.append(" jcr:like(@exo:subject, '%" + this.subject_ + "')");
                }
            }
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.body_ != null && this.body_.trim().length() > 0) {
            this.body_ = Utils.encodeJCRTextSearch(this.body_);
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            switch (this.getBodyCondition()) {
                case 0: {
                    stringBuffer.append(" jcr:contains(@exo:body, '" + this.body_ + "')");
                    break;
                }
                case 1: {
                    stringBuffer.append(" fn:not(jcr:contains(@exo:body, '" + this.body_ + "'))");
                }
            }
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.fromDate_ != null) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append(" @exo:receivedDate >= xs:dateTime('" + ISO8601.format((Calendar)this.fromDate_) + "')");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.toDate_ != null) {
            this.toDate_.set(11, 23);
            this.toDate_.set(12, 59);
            this.toDate_.set(14, 999);
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append(" @exo:receivedDate <= xs:dateTime('" + ISO8601.format((Calendar)this.toDate_) + "')");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.priority_ > 0L) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append(" @exo:priority = " + this.priority_ + "");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.hasAttach_) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append(" @exo:hasAttach = 'true'");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.hasStar_) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append(" @exo:star = 'true'");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.viewQuery_ != null && this.viewQuery_.trim().length() > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append(this.viewQuery_);
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.hasStructure_) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append(" @exo:isRoot = 'true'");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        stringBuffer.append("]");
        if (this.orderBy_ != null && this.orderBy_.trim().length() > 0) {
            stringBuffer.append(" order by @" + this.orderBy_ + " ");
            if (this.isAscending_) {
                stringBuffer.append("ascending");
            } else {
                stringBuffer.append("descending");
            }
            if (this.orderBy_.equalsIgnoreCase(Utils.EXO_LAST_UPDATE_TIME)) {
                stringBuffer.append(" , @" + Utils.EXO_RECEIVEDDATE + " ");
                if (this.isAscending_) {
                    stringBuffer.append("ascending");
                } else {
                    stringBuffer.append("descending");
                }
            }
        }
        if (hasConjuntion) {
            queryString.append(stringBuffer.toString());
        }
        return queryString.toString();
    }
}

