/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactGroup;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.webui.SelectItem;
import org.exoplatform.mail.webui.SelectItemOption;
import org.exoplatform.mail.webui.SelectItemOptionGroup;
import org.exoplatform.mail.webui.UIFormSelectBox;
import org.exoplatform.mail.webui.popup.UIAddContactForm;
import org.exoplatform.mail.webui.popup.UIPopupComponent;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.EmailAddressValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/popup/UIAddContactForm.gtmpl", events={@EventConfig(listeners={AddGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeImageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeleteImageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAddContactForm
extends UIForm
implements UIPopupComponent {
    public static final String SELECT_GROUP = "select-group".intern();
    public static final String NAME = "name".intern();
    public static final String FIRST_NAME = "first-name".intern();
    public static final String LAST_NAME = "last-name".intern();
    private static final String NICKNAME = "nickName";
    private static final String GENDER = "gender";
    private static final String BIRTHDAY = "birthday";
    private static final String DAY = "day";
    private static final String MONTH = "month";
    private static final String YEAR = "year";
    private static final String JOBTITLE = "jobTitle";
    private static final String EMAIL = "email";
    private static final String MALE = "Male";
    private static final String FEMALE = "Female";
    private byte[] imageBytes_ = null;
    private String fileName_ = null;
    private String imageMimeType_ = null;
    public boolean isEdited_ = false;
    public String selectedGroup_;
    public Contact selectedContact_;

    public UIAddContactForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(SELECT_GROUP, SELECT_GROUP, this.getOptions()));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIRST_NAME, FIRST_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(LAST_NAME, LAST_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NICKNAME, NICKNAME, null));
        ArrayList<org.exoplatform.webui.core.model.SelectItemOption> genderOptions = new ArrayList<org.exoplatform.webui.core.model.SelectItemOption>();
        genderOptions.add(new org.exoplatform.webui.core.model.SelectItemOption(MALE, (Object)MALE));
        genderOptions.add(new org.exoplatform.webui.core.model.SelectItemOption(FEMALE, (Object)FEMALE));
        this.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(GENDER, MALE, genderOptions));
        this.addUIFormInput((UIFormInput)new UIFormInputInfo(BIRTHDAY, BIRTHDAY, null));
        ArrayList<org.exoplatform.webui.core.model.SelectItemOption> datesOptions = new ArrayList<org.exoplatform.webui.core.model.SelectItemOption>();
        datesOptions.add(new org.exoplatform.webui.core.model.SelectItemOption("- day -", (Object)DAY));
        for (int i = 1; i < 32; ++i) {
            String date = i + "";
            datesOptions.add(new org.exoplatform.webui.core.model.SelectItemOption(date, (Object)date));
        }
        this.addUIFormInput((UIFormInput)new org.exoplatform.webui.form.UIFormSelectBox(DAY, DAY, datesOptions));
        ArrayList<org.exoplatform.webui.core.model.SelectItemOption> monthOptions = new ArrayList<org.exoplatform.webui.core.model.SelectItemOption>();
        monthOptions.add(new org.exoplatform.webui.core.model.SelectItemOption("-month-", (Object)MONTH));
        for (int i = 1; i < 13; ++i) {
            String month = i + "";
            monthOptions.add(new org.exoplatform.webui.core.model.SelectItemOption(month, (Object)month));
        }
        this.addUIFormInput((UIFormInput)new org.exoplatform.webui.form.UIFormSelectBox(MONTH, MONTH, monthOptions));
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        String date = MailUtils.formatDate((String)"dd/MM/yyyy", (Date)new Date(), (Locale)locale);
        String strDate = date.substring(date.lastIndexOf("/") + 1, date.length());
        int thisYear = Integer.parseInt(strDate);
        ArrayList<org.exoplatform.webui.core.model.SelectItemOption> yearOptions = new ArrayList<org.exoplatform.webui.core.model.SelectItemOption>();
        yearOptions.add(new org.exoplatform.webui.core.model.SelectItemOption("- year -", (Object)YEAR));
        for (int i = thisYear; i >= 1900; --i) {
            String year = i + "";
            yearOptions.add(new org.exoplatform.webui.core.model.SelectItemOption(year, (Object)year));
        }
        this.addUIFormInput((UIFormInput)new org.exoplatform.webui.form.UIFormSelectBox(YEAR, YEAR, yearOptions));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(JOBTITLE, JOBTITLE, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(EMAIL, EMAIL, null).addValidator(EmailAddressValidator.class, new Object[0]));
    }

    public List<SelectItem> getOptions() throws Exception {
        String username = MailUtils.getCurrentUser();
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        ArrayList<SelectItem> options = new ArrayList<SelectItem>();
        SelectItemOptionGroup personalContacts = new SelectItemOptionGroup("personal-contacts");
        for (ContactGroup pcg : contactSrv.getGroups(SessionProviderFactory.createSystemProvider(), username)) {
            personalContacts.addOption(new SelectItemOption(pcg.getName(), (Object)pcg.getId()));
        }
        options.add((SelectItem)personalContacts);
        return options;
    }

    public void fillDatas(Contact ct, String groupId) throws Exception {
        this.isEdited_ = true;
        this.selectedGroup_ = groupId;
        this.selectedContact_ = ct;
        ((UIFormSelectBox)this.getChildById(SELECT_GROUP)).setSelectedValues(new String[]{groupId});
        ((UIFormSelectBox)this.getChildById(SELECT_GROUP)).setEditable(false);
        ((UIFormSelectBox)this.getChildById(SELECT_GROUP)).setEnable(false);
        this.getUIStringInput(FIRST_NAME).setValue((Object)ct.getFirstName());
        this.getUIStringInput(LAST_NAME).setValue((Object)ct.getLastName());
        this.getUIStringInput(NICKNAME).setValue((Object)ct.getNickName());
        ((UIFormRadioBoxInput)this.getChild(UIFormRadioBoxInput.class)).setValue((Object)ct.getGender());
        this.setFieldBirthday(ct.getBirthday());
        this.getUIStringInput(JOBTITLE).setValue((Object)ct.getJobTitle());
        this.getUIStringInput(EMAIL).setValue((Object)ct.getEmailAddress());
        if (ct != null && ct.getAttachment() != null) {
            this.setImage(ct.getAttachment().getInputStream());
        }
    }

    public void setFieldBirthday(Date date) throws Exception {
        if (date != null) {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime(date);
            this.getUIFormSelectBox(MONTH).setValue(String.valueOf(cal.get(2) + 1));
            this.getUIFormSelectBox(DAY).setValue(String.valueOf(cal.get(5)));
            this.getUIFormSelectBox(YEAR).setValue(String.valueOf(cal.get(1)));
        }
    }

    public void refreshGroupList() throws Exception {
        ((UIFormSelectBox)this.getChildById(SELECT_GROUP)).setOptions(this.getOptions());
    }

    public void setFirstNameField(String firstName) throws Exception {
        this.getUIStringInput(FIRST_NAME).setValue((Object)firstName);
    }

    public void setLastNameField(String lastName) throws Exception {
        this.getUIStringInput(LAST_NAME).setValue((Object)lastName);
    }

    public String getNickName() {
        return (String)this.getUIStringInput(NICKNAME).getValue();
    }

    public String getJobTitle() {
        return (String)this.getUIStringInput(JOBTITLE).getValue();
    }

    public void setEmailField(String email) throws Exception {
        this.getUIStringInput(EMAIL).setValue((Object)email);
    }

    protected String getFieldGender() {
        return (String)((UIFormRadioBoxInput)this.getChild(UIFormRadioBoxInput.class)).getValue();
    }

    protected Date getFieldBirthday() {
        int year = 0;
        int month = 0;
        int day = 0;
        boolean emptyYear = false;
        boolean emptyMonth = false;
        boolean emptyDay = false;
        try {
            day = Integer.parseInt((String)this.getUIFormSelectBox(DAY).getValue());
        }
        catch (NumberFormatException e) {
            emptyDay = true;
        }
        try {
            month = Integer.parseInt((String)this.getUIFormSelectBox(MONTH).getValue());
        }
        catch (NumberFormatException e) {
            emptyMonth = true;
        }
        try {
            year = Integer.parseInt((String)this.getUIFormSelectBox(YEAR).getValue());
        }
        catch (NumberFormatException e) {
            emptyYear = true;
        }
        if (emptyDay && emptyMonth && emptyYear) {
            return null;
        }
        Calendar cal = GregorianCalendar.getInstance();
        cal.setLenient(false);
        cal.set(5, day);
        cal.set(2, month - 1);
        cal.set(1, year);
        return cal.getTime();
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    protected void setImage(InputStream input) throws Exception {
        if (input != null) {
            this.imageBytes_ = new byte[input.available()];
            input.read(this.imageBytes_);
        } else {
            this.imageBytes_ = null;
        }
    }

    protected byte[] getImage() {
        return this.imageBytes_;
    }

    protected String getMimeType() {
        return this.imageMimeType_;
    }

    protected void setMimeType(String mimeType) {
        this.imageMimeType_ = mimeType;
    }

    protected void setFileName(String name) {
        this.fileName_ = name;
    }

    protected String getFileName() {
        return this.fileName_;
    }

    protected String getImageSource() throws Exception {
        if (this.imageBytes_ == null || this.imageBytes_.length == 0) {
            return null;
        }
        ByteArrayInputStream byteImage = new ByteArrayInputStream(this.imageBytes_);
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)byteImage, "image");
        dresource.setDownloadName(this.fileName_);
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }
}

