/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactGroup;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.download.DownloadService;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.webui.SelectItem;
import org.exoplatform.mail.webui.SelectItemOption;
import org.exoplatform.mail.webui.SelectItemOptionGroup;
import org.exoplatform.mail.webui.UIFormSelectBox;
import org.exoplatform.mail.webui.popup.UIAddressBookForm;
import org.exoplatform.mail.webui.popup.UIPopupComponent;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/popup/UIAddressBookForm.gtmpl", events={@EventConfig(listeners={AddNewGroupActionListener.class}), @EventConfig(listeners={AddContactActionListener.class}), @EventConfig(listeners={EditContactActionListener.class}), @EventConfig(listeners={ChangeGroupActionListener.class}), @EventConfig(listeners={SelectContactActionListener.class}), @EventConfig(listeners={DeleteContactActionListener.class}, confirm="UIAddressBookForm.msg.confirm-remove-contact"), @EventConfig(listeners={CloseActionListener.class})})
public class UIAddressBookForm
extends UIForm
implements UIPopupComponent {
    public static final String ALL_GROUP = "All group".intern();
    public static final String SELECT_GROUP = "select-group".intern();
    private Contact selectedContact;
    Map<String, Contact> contactMap_ = new HashMap();
    List<Contact> contactList_ = new ArrayList();

    public UIAddressBookForm() throws Exception {
        UIFormSelectBox uiSelectGroup = new UIFormSelectBox(SELECT_GROUP, SELECT_GROUP, this.getOptions());
        uiSelectGroup.setOnChange("ChangeGroup");
        this.addUIFormInput((UIFormInput)uiSelectGroup);
        this.refrestContactList((String)uiSelectGroup.getValue());
    }

    public List<SelectItem> getOptions() throws Exception {
        String username = MailUtils.getCurrentUser();
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        ArrayList<SelectItem> options = new ArrayList<SelectItem>();
        SelectItemOptionGroup personalContacts = new SelectItemOptionGroup("personal-contacts");
        for (ContactGroup pcg : contactSrv.getGroups(SessionProviderFactory.createSystemProvider(), username)) {
            personalContacts.addOption(new SelectItemOption(pcg.getName(), (Object)pcg.getId()));
        }
        options.add((SelectItem)personalContacts);
        return options;
    }

    public Contact getSelectedContact() {
        return this.selectedContact;
    }

    public void setSelectedContact(Contact contact) {
        this.selectedContact = contact;
    }

    public DownloadService getDownloadService() {
        return (DownloadService)this.getApplicationComponent(DownloadService.class);
    }

    public List<Contact> getContacts() throws Exception {
        return this.contactList_;
    }

    public void refrestContactList(String groupId) throws Exception {
        String username = MailUtils.getCurrentUser();
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        List contactList = new ArrayList();
        contactList = groupId != null && groupId != "" ? contactSrv.getContactPageListByGroup(SessionProviderFactory.createSystemProvider(), username, groupId).getAll() : contactSrv.getContactPageListByGroup(SessionProviderFactory.createSystemProvider(), username, ((ContactGroup)contactSrv.getGroups(SessionProviderFactory.createSystemProvider(), username).get(0)).getId()).getAll();
        this.contactMap_.clear();
        for (Contact ct : contactList) {
            this.contactMap_.put(ct.getId(), ct);
        }
        this.contactList_ = new ArrayList(this.contactMap_.values());
        this.selectedContact = this.contactList_.size() > 0 ? (Contact)this.contactList_.get(0) : null;
    }

    public void updateGroup(String selectedGroup) throws Exception {
        ((UIFormSelectBox)this.getChildById(SELECT_GROUP)).setOptions(this.getOptions());
        ((UIFormSelectBox)this.getChildById(SELECT_GROUP)).setValue(selectedGroup);
    }

    public String[] getActions() {
        return new String[]{"Close"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }
}

