/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactAttachment;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.mail.service.Attachment;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Message;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.quartz.JobDetail;

/*
 * Exception performing whole class analysis ignored.
 */
public class MailUtils {
    public static final String SEMICOLON = ";".intern();
    public static final String COMMA = ",".intern();
    public static final String SLASH = "/".intern();
    public static final String BACKSLASH = "\\".intern();
    public static final String GREATER_THAN = ">".intern();
    public static final String SMALLER_THAN = "<".intern();
    public static final String[] SPECIALCHARACTER = new String[]{SEMICOLON, COMMA, SLASH, BACKSLASH, "'", "|", ">", "<", "\"", "?", "!", "@", "#", "$", "%", "^", "&", "*"};
    public static final String[] SUPPORTED_VIEW_TYPE_ATTACH = new String[]{"gif", "png", "jpg", "jpec", "bmp"};
    public static final String[] SIMPLECHARACTER = new String[]{GREATER_THAN, SMALLER_THAN, "'", "\""};

    public static MailService getMailService() throws Exception {
        return (MailService)PortalContainer.getComponent(MailService.class);
    }

    public static String getCurrentUser() throws Exception {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public static boolean isNameValid(String name, String[] regex) {
        for (String c : regex) {
            if (!name.contains(c)) continue;
            return false;
        }
        return true;
    }

    public static String getImageSource(Contact contact, DownloadService dservice) throws Exception {
        ContactAttachment contactAttachment = contact.getAttachment();
        if (contactAttachment != null) {
            InputStream input = contactAttachment.getInputStream();
            byte[] imageBytes = null;
            if (input != null) {
                imageBytes = new byte[input.available()];
                input.read(imageBytes);
                ByteArrayInputStream byteImage = new ByteArrayInputStream(imageBytes);
                InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)byteImage, "image");
                dresource.setDownloadName(contactAttachment.getFileName());
                return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
            }
        }
        return null;
    }

    public static OrganizationService getOrganizationService() throws Exception {
        return (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
    }

    public static String encodeJCRText(String str) {
        return str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
    }

    public static String convertSize(long size) throws Exception {
        String str = "";
        DecimalFormat df = new DecimalFormat("0.00");
        str = size > 0x100000L ? str + df.format((double)size / 1048576.0) + " MB" : (size > 1024L ? str + df.format((double)size / 1024.0) + " KB" : str + size + " B");
        return str;
    }

    public static String getImageSource(Attachment attach, DownloadService dservice) throws Exception {
        if (attach != null) {
            InputStream input = attach.getInputStream();
            byte[] imageBytes = null;
            if (input != null) {
                imageBytes = new byte[input.available()];
                input.read(imageBytes);
                ByteArrayInputStream byteImage = new ByteArrayInputStream(imageBytes);
                InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)byteImage, "image");
                dresource.setDownloadName(attach.getName());
                return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
            }
        }
        return null;
    }

    public static boolean isFieldEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isChecking(String username, String accountId) throws Exception {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
            List allJobs = schedulerService.getAllJobs();
            for (Object obj : allJobs) {
                if (!((JobDetail)obj).getName().equals(username + ":" + accountId)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String formatDate(String format, Date date, Locale locale) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, locale);
        return formatter.format((Object)date);
    }

    public static String formatDate(Date date, Locale locale) {
        boolean isSameDate;
        GregorianCalendar systemDate = new GregorianCalendar();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        boolean isSameYear = systemDate.get(1) == cal.get(1);
        boolean isSameMonth = systemDate.get(2) == cal.get(2);
        boolean isSameWeek = isSameMonth && systemDate.get(4) == cal.get(4);
        boolean bl = isSameDate = isSameWeek && systemDate.get(7) == cal.get(7);
        if (isSameYear) {
            if (isSameDate) {
                return new SimpleDateFormat("HH:mm aaa", locale).format(date);
            }
            if (isSameWeek) {
                return new SimpleDateFormat("EEEE", locale).format(date);
            }
            if (isSameMonth) {
                return new SimpleDateFormat("EEEE, dd", locale).format(date);
            }
            return new SimpleDateFormat("MMM dd", locale).format(date);
        }
        return new SimpleDateFormat("MMM dd, yyyy", locale).format(date);
    }

    public static String encodeHTML(String htmlContent) throws Exception {
        return !MailUtils.isFieldEmpty((String)htmlContent) ? htmlContent.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&#39;") : "";
    }

    public static String decodeHTML(String htmlContent) throws Exception {
        return !MailUtils.isFieldEmpty((String)htmlContent) ? htmlContent.replaceAll("&amp;", "&").replaceAll("&quot;", "\"").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&#39;", "'") : "";
    }

    public static boolean isInvitation(Message msg) throws Exception {
        return msg.getHeader("X-Exo-Invitation") != null;
    }

    public static String getEventFrom(Message msg) throws Exception {
        String from = null;
        if (MailUtils.isInvitation((Message)msg)) {
            from = msg.getHeader("X-Exo-Invitation").split(";")[0].trim();
        }
        return from;
    }

    public static String getEventTo(Message msg) throws Exception {
        String to = null;
        if (MailUtils.isInvitation((Message)msg)) {
            to = msg.getHeader("X-Exo-Invitation").split(";")[1].trim();
        }
        return to;
    }

    public static String getEventType(Message msg) throws Exception {
        String eventType = null;
        if (MailUtils.isInvitation((Message)msg)) {
            eventType = msg.getHeader("X-Exo-Invitation").split(";")[2].trim();
        }
        return eventType;
    }

    public static String getCalendarId(Message msg) throws Exception {
        String calId = null;
        if (MailUtils.isInvitation((Message)msg)) {
            calId = msg.getHeader("X-Exo-Invitation").split(";")[3].trim();
        }
        return calId;
    }

    public static String getCalendarEventId(Message msg) throws Exception {
        String calEvenId = null;
        if (MailUtils.isInvitation((Message)msg)) {
            calEvenId = msg.getHeader("X-Exo-Invitation").split(";")[4].trim();
        }
        return calEvenId;
    }

    public static boolean isValidEmailAddresses(String addressList) throws Exception {
        if (MailUtils.isFieldEmpty((String)addressList)) {
            return true;
        }
        boolean isInvalid = true;
        try {
            InternetAddress[] iAdds = InternetAddress.parse((String)addressList, (boolean)true);
            String emailRegex = "[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-.]+\\.[A-Za-z]{2,5}";
            for (int i = 0; i < iAdds.length; ++i) {
                if (iAdds[i].getAddress().toString().matches(emailRegex)) continue;
                isInvalid = false;
            }
        }
        catch (AddressException e) {
            return false;
        }
        return isInvalid;
    }

    public static String html2string(String str) throws Exception {
        if (str != null) {
            str = str.replaceAll("<[^>]*>", "");
            str = str.replaceAll("&nbsp;", "");
            str = str.replaceAll("&quot;", "\"");
            str = str.replaceAll("\n", "");
        } else {
            str = "";
        }
        return str;
    }

    public static String html2text(String str) throws Exception {
        if (str != null) {
            str = str.replaceAll("<br*/?>", "\n");
            str = str.replaceAll("<[^>]*>", "");
            str = str.replaceAll("&nbsp;", "");
            str = str.replaceAll("&quot;", "\"");
        } else {
            str = "";
        }
        return str;
    }

    public static String text2html(String str) throws Exception {
        str = str != null ? str.replaceAll("\n", "<br />") : "";
        return str;
    }

    public static String convertTextToHtmlLink(String s) throws Exception {
        if (MailUtils.isFieldEmpty((String)s)) {
            return "";
        }
        s = MailUtils.decodeHTML((String)s);
        s = s.replaceAll("(\r?\n?)(https?|ftp)", "<br /> $2");
        s = s.replaceAll("([^((href|src)=\")])(https?|ftp)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]", "<a target=\"_blank\" href=\"$0\"> $0 </a>");
        s = s.replaceAll("(\\s)([_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-.]+\\.[A-Za-z]{2,5})", "$1<a target=\"_blank\" href=\"mailto:$2\"> $2 </a>");
        return s;
    }

    public static String insertTargetToHtmlLink(String s) throws Exception {
        if (MailUtils.isFieldEmpty((String)s)) {
            return "";
        }
        s = MailUtils.decodeHTML((String)s);
        s = s.replaceAll("<(A|a)(.*?)>(.*?)</(A|a)>", "<a $2 target=\"_blank\"> $3 </a>");
        return s;
    }
}

