/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.mail.internet.InternetAddress;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadService;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.webui.UIFolderContainer;
import org.exoplatform.mail.webui.UIMailPortlet;
import org.exoplatform.mail.webui.UIMessagePreview;
import org.exoplatform.mail.webui.UISelectAccount;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/mail/webui/UIMessagePreview.gtmpl", events={@EventConfig(listeners={DownloadAttachmentActionListener.class}), @EventConfig(listeners={AddStarActionListener.class}), @EventConfig(listeners={ReplyActionListener.class}), @EventConfig(listeners={ReplyAllActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIMessagePreview.msg.confirm-remove-message"), @EventConfig(listeners={ForwardActionListener.class}), @EventConfig(listeners={CreateFilterActionListener.class}), @EventConfig(listeners={PrintActionListener.class}), @EventConfig(listeners={ExportActionListener.class}), @EventConfig(listeners={AddTagActionListener.class}), @EventConfig(listeners={AddContactActionListener.class}), @EventConfig(listeners={MoveMessagesActionListener.class}), @EventConfig(listeners={AnswerInvitationActionListener.class}), @EventConfig(listeners={ViewAllHeadersActionListener.class})})
public class UIMessagePreview
extends UIComponent {
    private Message selectedMessage_;
    private List<Message> showedMsgs = new ArrayList();

    public Message getMessage() throws Exception {
        return this.selectedMessage_;
    }

    public void setMessage(Message msg) throws Exception {
        this.selectedMessage_ = msg;
    }

    public List<Message> getShowedMessages() throws Exception {
        return this.showedMsgs;
    }

    public void setShowedMessages(List<Message> msgList) throws Exception {
        this.showedMsgs = msgList;
    }

    public boolean isShowBcc(Message msg) throws Exception {
        UIMailPortlet uiPortlet = (UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class);
        String selectedFolder = ((UIFolderContainer)uiPortlet.findFirstComponentOfType(UIFolderContainer.class)).getSelectedFolder();
        String accId = ((UISelectAccount)uiPortlet.findFirstComponentOfType(UISelectAccount.class)).getSelectedValue();
        String username = MailUtils.getCurrentUser();
        MailService mailServ = (MailService)uiPortlet.getApplicationComponent(MailService.class);
        Account account = mailServ.getAccountById(SessionProviderFactory.createSystemProvider(), username, accId);
        InternetAddress[] fromAddress = Utils.getInternetAddress((String)msg.getFrom());
        InternetAddress from = fromAddress[0];
        return !MailUtils.isFieldEmpty((String)selectedFolder) && selectedFolder.equals(Utils.createFolderId((String)accId, (String)Utils.FD_SENT, (boolean)false)) && !MailUtils.isFieldEmpty((String)msg.getMessageBcc()) && account != null && from.getAddress().equalsIgnoreCase(account.getEmailAddress());
    }

    /*
     * Enabled aggressive block sorting
     */
    public CalendarEvent getEvent(Message msg) throws Exception {
        CalendarService calendarSrv = (CalendarService)this.getApplicationComponent(CalendarService.class);
        CalendarEvent calEvent = null;
        if (0 != Integer.parseInt(MailUtils.getEventType((Message)msg))) {
            if (1 == Integer.parseInt(MailUtils.getEventType((Message)msg))) {
                return calEvent;
            }
            if (2 != Integer.parseInt(MailUtils.getEventType((Message)msg))) return calEvent;
            return calendarSrv.getGroupEvent(SessionProviderFactory.createSystemProvider(), MailUtils.getCalendarId((Message)msg), MailUtils.getCalendarEventId((Message)msg));
        }
        ArrayList<String> calIds = new ArrayList<String>();
        calIds.add(MailUtils.getCalendarId((Message)msg));
        Iterator iter = calendarSrv.getUserEventByCalendar(SessionProviderFactory.createSessionProvider(), MailUtils.getEventFrom((Message)msg), calIds).iterator();
        if (!iter.hasNext()) return calEvent;
        calEvent = (CalendarEvent)iter.next();
        if (!MailUtils.getCalendarEventId((Message)msg).equals(calEvent.getId())) return calEvent;
        return calEvent;
    }

    public Message getShowedMessageById(String id) throws Exception {
        for (Message msg : this.getShowedMessages()) {
            if (!msg.getId().equals(id)) continue;
            return msg;
        }
        return null;
    }

    public DownloadService getDownloadService() {
        return (DownloadService)this.getApplicationComponent(DownloadService.class);
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }
}

