/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.webui.UIFormDateTimePicker;
import org.exoplatform.mail.webui.popup.UIAccountCreation;
import org.exoplatform.mail.webui.popup.UIAccountSetting;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/popup/UIAccountSetting.gtmpl", events={@EventConfig(listeners={SelectAccountActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddNewAccountActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeleteAccountActionListener.class}, phase=Event.Phase.DECODE, confirm="UIAccountSetting.msg.confirm-remove-account"), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeServerTypeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeSSLActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CheckFromDateActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAccountSetting
extends UIFormTabPane {
    public static final String TAB_ACCOUNT = "account";
    public static final String TAB_IDENTITY_SETTINGS = "identitySettings";
    public static final String TAB_SERVER_SETTINGS = "serverSettings";
    public static final String FIELD_ACCOUNT_NAME = "accountName";
    public static final String FIELD_DISPLAY_NAME = "display-name".intern();
    public static final String FIELD_INCOMING_USERNAME = "incomingUsername";
    public static final String FIELD_ACCOUNT_DESCRIPTION = "description";
    public static final String FIELD_OUTGOING_NAME = "yourOutgoingName";
    public static final String FIELD_EMAIL_ADDRESS = "yourEmailAddress";
    public static final String FIELD_INCOMING_ACCOUNT = "incomingAccount";
    public static final String FIELD_INCOMING_PASSWORD = "incomingPassword";
    public static final String FIELD_REPLYTO_ADDRESS = "replyToAddress";
    public static final String FIELD_MAIL_SIGNATURE = "mailSignature";
    public static final String FIELD_SERVER_TYPE = "serverType";
    public static final String FIELD_INCOMING_SERVER = "incomingServer";
    public static final String FIELD_INCOMING_PORT = "incomingPort";
    public static final String FIELD_OUTGOING_SERVER = "outgoingServer";
    public static final String FIELD_OUTGOING_PORT = "outgoingPort";
    public static final String FIELD_INCOMING_FOLDER = "messageComeInFolder";
    public static final String FIELD_IS_INCOMING_SSL = "isSSL";
    public static final String FIELD_CHECKMAIL_AUTO = "checkMailAutomatically";
    public static final String FIELD_LEAVE_ON_SERVER = "leaveMailOnServer";
    public static final String FIELD_MARK_AS_DELETED = "markItAsDeleted";
    public static final String FIELD_IS_SAVE_PASSWORD = "isSavePassword";
    private String accountId_ = null;
    UIFormCheckBoxInput<Boolean> leaveOnServer_;
    UIFormCheckBoxInput<Boolean> markAsDelete_;
    public static final String CHECK_FROM_DATE = "checkFromDate";
    public static final String FROM_DATE = "fromDate";

    public UIAccountSetting() throws Exception {
        super("UIAccountSetting");
        UIFormInputWithActions accountInputSet = new UIFormInputWithActions(TAB_ACCOUNT);
        accountInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_ACCOUNT_NAME, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        accountInputSet.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_ACCOUNT_DESCRIPTION, null, null));
        UIFormCheckBoxInput checkFromDate = new UIFormCheckBoxInput(CHECK_FROM_DATE, CHECK_FROM_DATE, null);
        checkFromDate.setOnChange("CheckFromDate");
        accountInputSet.addUIFormInput((UIFormInput)checkFromDate);
        accountInputSet.addUIFormInput((UIFormInput)new UIFormDateTimePicker(FROM_DATE, FROM_DATE, null, true));
        this.addUIFormInput((UIFormInputSet)accountInputSet);
        this.setSelectedTab(accountInputSet.getId());
        UIFormInputWithActions identityInputSet = new UIFormInputWithActions(TAB_IDENTITY_SETTINGS);
        identityInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_DISPLAY_NAME, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        identityInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_EMAIL_ADDRESS, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        identityInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_REPLYTO_ADDRESS, null, null));
        identityInputSet.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_MAIL_SIGNATURE, null, null));
        this.addUIFormInput((UIFormInputSet)identityInputSet);
        UIFormInputWithActions serverInputSet = new UIFormInputWithActions(TAB_SERVER_SETTINGS);
        UIFormSelectBox serverType = new UIFormSelectBox(FIELD_SERVER_TYPE, null, this.getServerTypeValues());
        serverType.setEditable(false);
        serverType.setEnable(false);
        serverInputSet.addUIFormInput((UIFormInput)serverType);
        serverInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_INCOMING_SERVER, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        serverInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_INCOMING_PORT, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        serverInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_INCOMING_ACCOUNT, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        UIFormStringInput passwordField = new UIFormStringInput(FIELD_INCOMING_PASSWORD, null, null);
        passwordField.setType((short)1);
        passwordField.addValidator(MandatoryValidator.class, new Object[0]);
        serverInputSet.addUIFormInput((UIFormInput)passwordField);
        serverInputSet.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_IS_SAVE_PASSWORD, null, null));
        UIFormCheckBoxInput ssl = new UIFormCheckBoxInput(FIELD_IS_INCOMING_SSL, null, null);
        ssl.setOnChange("ChangeSSL");
        serverInputSet.addUIFormInput((UIFormInput)ssl);
        serverInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_OUTGOING_SERVER, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        serverInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_OUTGOING_PORT, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        serverInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_INCOMING_FOLDER, null, null).addValidator(MandatoryValidator.class, new Object[0]));
        serverInputSet.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_CHECKMAIL_AUTO, null, null));
        this.leaveOnServer_ = new UIFormCheckBoxInput(FIELD_LEAVE_ON_SERVER, null, null);
        this.markAsDelete_ = new UIFormCheckBoxInput(FIELD_MARK_AS_DELETED, null, null);
        this.addUIFormInput((UIFormInputSet)serverInputSet);
    }

    private List<SelectItemOption<String>> getServerTypeValues() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(Utils.POP3, (Object)Utils.POP3));
        options.add(new SelectItemOption(Utils.IMAP, (Object)Utils.IMAP));
        return options;
    }

    public String getSelectedAccountId() throws Exception {
        return this.accountId_;
    }

    public void setSelectedAccountId(String accountId) throws Exception {
        this.accountId_ = accountId;
    }

    public String getFieldAccountNameValue() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_ACCOUNT);
        return (String)uiInput.getUIStringInput(FIELD_ACCOUNT_NAME).getValue();
    }

    public boolean getFieldCheckFromDate() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_ACCOUNT);
        return uiInput.getUIFormCheckBoxInput(CHECK_FROM_DATE).isChecked();
    }

    public Calendar getFieldCheckFrom() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_ACCOUNT);
        if ((UIFormDateTimePicker)uiInput.getChildById(FROM_DATE) != null) {
            return ((UIFormDateTimePicker)uiInput.getChildById(FROM_DATE)).getCalendar();
        }
        return null;
    }

    public String getDisplayName() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_IDENTITY_SETTINGS);
        return (String)uiInput.getUIStringInput(FIELD_DISPLAY_NAME).getValue();
    }

    public String getFieldAccountDescription() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_ACCOUNT);
        return (String)uiInput.getUIStringInput(FIELD_ACCOUNT_DESCRIPTION).getValue();
    }

    public String getFieldMailAddress() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_IDENTITY_SETTINGS);
        return (String)uiInput.getUIStringInput(FIELD_EMAIL_ADDRESS).getValue();
    }

    public String getFieldProtocol() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_SERVER_SETTINGS);
        return (String)uiInput.getUIFormSelectBox(FIELD_SERVER_TYPE).getValue();
    }

    public String getFieldIncomingAccount() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_SERVER_SETTINGS);
        return (String)uiInput.getUIStringInput(FIELD_INCOMING_ACCOUNT).getValue();
    }

    public String getFieldIncomingPassword() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_SERVER_SETTINGS);
        return (String)uiInput.getUIStringInput(FIELD_INCOMING_PASSWORD).getValue();
    }

    public String getFieldIncomingServer() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_SERVER_SETTINGS);
        return (String)uiInput.getUIStringInput(FIELD_INCOMING_SERVER).getValue();
    }

    public String getFieldIncomingPort() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_SERVER_SETTINGS);
        return (String)uiInput.getUIStringInput(FIELD_INCOMING_PORT).getValue();
    }

    public String getFieldOutgoingServer() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_SERVER_SETTINGS);
        return (String)uiInput.getUIStringInput(FIELD_OUTGOING_SERVER).getValue();
    }

    public String getFieldOutgoingPort() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_SERVER_SETTINGS);
        return (String)uiInput.getUIStringInput(FIELD_OUTGOING_PORT).getValue();
    }

    public String getFieldMailSignature() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_IDENTITY_SETTINGS);
        return (String)uiInput.getUIStringInput(FIELD_MAIL_SIGNATURE).getValue();
    }

    public boolean isSavePassword() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_SERVER_SETTINGS);
        return uiInput.getUIFormCheckBoxInput(FIELD_IS_SAVE_PASSWORD).isChecked();
    }

    public String getFieldReplyAddress() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_IDENTITY_SETTINGS);
        return (String)uiInput.getUIStringInput(FIELD_REPLYTO_ADDRESS).getValue();
    }

    public String getFieldIncomingFolder() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_SERVER_SETTINGS);
        return (String)uiInput.getUIStringInput(FIELD_INCOMING_FOLDER).getValue();
    }

    public boolean getFieldIsSSL() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_SERVER_SETTINGS);
        return uiInput.getUIFormCheckBoxInput(FIELD_IS_INCOMING_SSL).isChecked();
    }

    public boolean getFieldCheckMailAuto() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_SERVER_SETTINGS);
        return uiInput.getUIFormCheckBoxInput(FIELD_CHECKMAIL_AUTO).isChecked();
    }

    public boolean getFieldLeaveOnServer() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_SERVER_SETTINGS);
        return uiInput.getUIFormCheckBoxInput(FIELD_LEAVE_ON_SERVER).isChecked();
    }

    public boolean getFieldMaxAsDeleted() {
        UIFormInputWithActions uiInput = (UIFormInputWithActions)this.getChildById(TAB_SERVER_SETTINGS);
        return uiInput.getUIFormCheckBoxInput(FIELD_MARK_AS_DELETED).isChecked();
    }

    public void fillField() throws Exception {
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        String username = Util.getPortalRequestContext().getRemoteUser();
        Account account = mailSrv.getAccountById(SessionProviderFactory.createSystemProvider(), username, this.getSelectedAccountId());
        UIFormInputWithActions uiAccountInput = (UIFormInputWithActions)this.getChildById(TAB_ACCOUNT);
        uiAccountInput.getUIStringInput(FIELD_ACCOUNT_NAME).setValue((Object)account.getLabel());
        uiAccountInput.getUIStringInput(FIELD_ACCOUNT_DESCRIPTION).setValue((Object)account.getDescription());
        UIFormCheckBoxInput checkFromDate = uiAccountInput.getUIFormCheckBoxInput(CHECK_FROM_DATE);
        if (account.getProtocol().equals(Utils.IMAP)) {
            if (checkFromDate == null) {
                checkFromDate = new UIFormCheckBoxInput(CHECK_FROM_DATE, CHECK_FROM_DATE, null);
                checkFromDate.setOnChange("CheckFromDate");
                uiAccountInput.addUIFormInput((UIFormInput)checkFromDate);
            }
            checkFromDate.setChecked(!account.isCheckAll());
            GregorianCalendar cal = new GregorianCalendar();
            if (account.getCheckFromDate() != null) {
                cal.setTimeInMillis(account.getCheckFromDate().getTime());
                UIFormDateTimePicker uiDate = (UIFormDateTimePicker)uiAccountInput.getChildById(FROM_DATE);
                if (uiDate != null) {
                    uiDate.setCalendar((Calendar)cal);
                } else {
                    uiDate = new UIFormDateTimePicker(FROM_DATE, FROM_DATE, null, true);
                    uiDate.setCalendar((Calendar)cal);
                    uiAccountInput.addUIFormInput((UIFormInput)uiDate);
                }
            }
            if (account.isCheckAll()) {
                uiAccountInput.removeChildById(FROM_DATE);
            }
        } else {
            uiAccountInput.removeChildById(CHECK_FROM_DATE);
            uiAccountInput.removeChildById(FROM_DATE);
        }
        UIFormInputWithActions uiIdentityInput = (UIFormInputWithActions)this.getChildById(TAB_IDENTITY_SETTINGS);
        uiIdentityInput.getUIStringInput(FIELD_DISPLAY_NAME).setValue((Object)account.getUserDisplayName());
        uiIdentityInput.getUIStringInput(FIELD_EMAIL_ADDRESS).setValue((Object)account.getEmailAddress());
        uiIdentityInput.getUIStringInput(FIELD_REPLYTO_ADDRESS).setValue((Object)account.getEmailReplyAddress());
        uiIdentityInput.getUIStringInput(FIELD_MAIL_SIGNATURE).setValue((Object)account.getSignature());
        UIFormInputWithActions uiServerInput = (UIFormInputWithActions)this.getChildById(TAB_SERVER_SETTINGS);
        uiServerInput.getUIStringInput(FIELD_INCOMING_SERVER).setValue((Object)account.getIncomingHost());
        uiServerInput.getUIStringInput(FIELD_INCOMING_PORT).setValue((Object)account.getIncomingPort());
        uiServerInput.getUIStringInput(FIELD_INCOMING_ACCOUNT).setValue((Object)account.getIncomingUser());
        uiServerInput.getUIStringInput(FIELD_INCOMING_PASSWORD).setValue((Object)account.getIncomingPassword());
        uiServerInput.getUIFormCheckBoxInput(FIELD_IS_SAVE_PASSWORD).setChecked(account.isSavePassword());
        uiServerInput.getUIStringInput(FIELD_OUTGOING_SERVER).setValue((Object)account.getOutgoingHost());
        uiServerInput.getUIStringInput(FIELD_OUTGOING_PORT).setValue((Object)account.getOutgoingPort());
        uiServerInput.getUIStringInput(FIELD_INCOMING_FOLDER).setValue((Object)account.getIncomingFolder());
        uiServerInput.getUIFormSelectBox(FIELD_SERVER_TYPE).setValue(account.getProtocol());
        uiServerInput.getUIFormCheckBoxInput(FIELD_IS_INCOMING_SSL).setChecked(account.isIncomingSsl());
        uiServerInput.getUIFormCheckBoxInput(FIELD_CHECKMAIL_AUTO).setChecked(account.checkedAuto());
        if (this.getFieldProtocol().equals(Utils.POP3)) {
            if (uiServerInput.getChildById(FIELD_LEAVE_ON_SERVER) == null) {
                uiServerInput.addUIFormInput((UIFormInput)this.leaveOnServer_);
            }
            if (uiServerInput.getChildById(FIELD_MARK_AS_DELETED) != null) {
                uiServerInput.removeChildById(FIELD_MARK_AS_DELETED);
            }
        } else {
            if (uiServerInput.getChildById(FIELD_MARK_AS_DELETED) == null) {
                uiServerInput.addUIFormInput((UIFormInput)this.markAsDelete_);
            }
            if (uiServerInput.getChildById(FIELD_LEAVE_ON_SERVER) != null) {
                uiServerInput.removeChildById(FIELD_LEAVE_ON_SERVER);
            }
        }
        if (account.getPopServerProperties() != null && uiServerInput.getChildById(FIELD_LEAVE_ON_SERVER) != null) {
            uiServerInput.getUIFormCheckBoxInput(FIELD_LEAVE_ON_SERVER).setChecked(Boolean.valueOf((String)account.getPopServerProperties().get(Utils.SVR_POP_LEAVE_ON_SERVER)).booleanValue());
        }
        if (account.getImapServerProperties() != null && uiServerInput.getChildById(FIELD_MARK_AS_DELETED) != null) {
            uiServerInput.getUIFormCheckBoxInput(FIELD_MARK_AS_DELETED).setChecked(Boolean.valueOf((String)account.getImapServerProperties().get(Utils.SVR_IMAP_MARK_AS_DELETE)).booleanValue());
        }
    }

    public void setDefaultValue(String serverType, boolean isSSL) {
        if (serverType.equals(Utils.POP3)) {
            if (isSSL) {
                this.getUIStringInput(FIELD_INCOMING_PORT).setValue((Object)UIAccountCreation.DEFAULT_POPSSL_PORT);
            } else {
                this.getUIStringInput(FIELD_INCOMING_PORT).setValue((Object)UIAccountCreation.DEFAULT_POP_PORT);
            }
        } else if (isSSL) {
            this.getUIStringInput(FIELD_INCOMING_PORT).setValue((Object)UIAccountCreation.DEFAULT_IMAPSSL_PORT);
        } else {
            this.getUIStringInput(FIELD_INCOMING_PORT).setValue((Object)UIAccountCreation.DEFAULT_IMAP_PORT);
        }
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public List<Account> getAccounts() throws Exception {
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        String username = Util.getPortalRequestContext().getRemoteUser();
        return mailSrv.getAccounts(SessionProviderFactory.createSystemProvider(), username);
    }
}

