/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.webui.popup.UIAccountList;
import org.exoplatform.mail.webui.popup.UIPopupComponent;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIGrid;

@ComponentConfig(template="app:/templates/mail/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIAccountList.msg.confirm-delete"), @EventConfig(listeners={CloseActionListener.class})})
public class UIAccountList
extends UIGrid
implements UIPopupComponent {
    private static String[] BEAN_FIELD = new String[]{"name", "email", "server", "protocol"};
    private static String[] BEAN_ACTION = new String[]{"Delete"};

    public UIAccountList() throws Exception {
        this.configure("id", BEAN_FIELD, BEAN_ACTION);
        this.updateGrid();
    }

    public void updateGrid() throws Exception {
        ArrayList<AccountData> accounts = new ArrayList<AccountData>();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        MailService mailSvr = (MailService)this.getApplicationComponent(MailService.class);
        for (Account acc : mailSvr.getAccounts(userId)) {
            accounts.add(new AccountData(this, acc.getId(), acc.getLabel(), acc.getEmailAddress(), (String)acc.getServerProperties().get(Utils.SVR_INCOMING_HOST), acc.getProtocol()));
        }
        ObjectPageList objPageList = new ObjectPageList(accounts, 10);
        this.getUIPageIterator().setPageList((PageList)objPageList);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String[] getButtons() {
        return new String[]{"Close"};
    }
}

