/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.MessageFilter;
import org.exoplatform.mail.service.Tag;
import org.exoplatform.mail.webui.UISelectFolder;
import org.exoplatform.mail.webui.popup.UIAddMessageFilter;
import org.exoplatform.mail.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/popup/UIAddMessageFilter.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIAddMessageFilter
extends UIForm
implements UIPopupComponent {
    public static final String FILTER_NAME = "filter-name".intern();
    public static final String FILTER_FROM = "filter-from".intern();
    public static final String FILTER_FROM_CONDITION = "filter-from-condition".intern();
    public static final String FILTER_TO = "filter-to".intern();
    public static final String FILTER_TO_CONDITION = "filter-to-condition".intern();
    public static final String FILTER_SUBJECT = "filter-subject".intern();
    public static final String FILTER_SUBJECT_CONDITION = "filter-subject-condition".intern();
    public static final String FILTER_BODY = "filter-body".intern();
    public static final String FILTER_BODY_CONDITION = "filter-body-condition".intern();
    public static final String FILTER_APPLY_FOLDER = "filter-aplly-folder".intern();
    public static final String FILTER_APPLY_TAG = "filter-aplly-tag".intern();
    public static final String APPLY_ALL_MESSAGE = "apply-all-messages".intern();
    private MessageFilter currentFilter;

    public void init(String accountId) throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FILTER_NAME, FILTER_NAME, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FILTER_FROM, FILTER_FROM, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FILTER_TO, FILTER_TO, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FILTER_SUBJECT, FILTER_SUBJECT, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FILTER_BODY, FILTER_BODY, null));
        ArrayList<SelectItemOption> options1 = new ArrayList<SelectItemOption>();
        options1.add(new SelectItemOption("contains", (Object)String.valueOf(0)));
        options1.add(new SelectItemOption("doesn't contain", (Object)String.valueOf(1)));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FILTER_BODY_CONDITION, FILTER_BODY_CONDITION, options1));
        ArrayList<SelectItemOption> options2 = new ArrayList<SelectItemOption>();
        options2.add(new SelectItemOption("contains", (Object)String.valueOf(0)));
        options2.add(new SelectItemOption("doesn't contain", (Object)String.valueOf(1)));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FILTER_TO_CONDITION, FILTER_TO_CONDITION, options2));
        ArrayList<SelectItemOption> options3 = new ArrayList<SelectItemOption>();
        options3.add(new SelectItemOption("contains", (Object)String.valueOf(0)));
        options3.add(new SelectItemOption("doesn't contain", (Object)String.valueOf(1)));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FILTER_FROM_CONDITION, FILTER_FROM_CONDITION, options3));
        ArrayList<SelectItemOption> options4 = new ArrayList<SelectItemOption>();
        options4.add(new SelectItemOption("contains", (Object)String.valueOf(0)));
        options4.add(new SelectItemOption("doesn't contain", (Object)String.valueOf(1)));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FILTER_SUBJECT_CONDITION, FILTER_SUBJECT_CONDITION, options4));
        String username = MailUtils.getCurrentUser();
        MailService mailSrv = MailUtils.getMailService();
        UISelectFolder uiSelectFolder = new UISelectFolder();
        this.addUIFormInput((UIFormInputSet)uiSelectFolder);
        uiSelectFolder.init(accountId);
        ArrayList<SelectItemOption> tagList = new ArrayList<SelectItemOption>();
        tagList.add(new SelectItemOption("Choose a tag", (Object)"choose-tag"));
        for (Tag tag : mailSrv.getTags(username, accountId)) {
            tagList.add(new SelectItemOption(tag.getName(), (Object)tag.getId()));
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FILTER_APPLY_TAG, FILTER_APPLY_TAG, tagList));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(APPLY_ALL_MESSAGE, APPLY_ALL_MESSAGE, (Object)false));
    }

    public MessageFilter getCurrentFilter() {
        return this.currentFilter;
    }

    public void setCurrentFilter(MessageFilter filter) throws Exception {
        this.currentFilter = filter;
        this.setFilterName(filter.getName());
        this.setFrom(filter.getFrom());
        this.setFromCondition(String.valueOf(filter.getFromCondition()));
        this.setTo(filter.getTo());
        this.setToCondition(String.valueOf(filter.getToCondition()));
        this.setSubject(filter.getSubject());
        this.setSubjectCondition(String.valueOf(filter.getSubjectCondition()));
        this.setBody(filter.getBody());
        this.setBodyCondition(String.valueOf(filter.getBodyCondition()));
        this.setApplyFolder(filter.getApplyFolder());
        this.setApplyTag(filter.getApplyTag());
        this.setApplyAll(filter.applyForAll().booleanValue());
    }

    public String getFilterName() throws Exception {
        return (String)this.getUIStringInput(FILTER_NAME).getValue();
    }

    public void setFilterName(String s) throws Exception {
        this.getUIStringInput(FILTER_NAME).setValue((Object)s);
    }

    public String getFrom() throws Exception {
        return (String)this.getUIStringInput(FILTER_FROM).getValue();
    }

    public void setFrom(String s) throws Exception {
        this.getUIStringInput(FILTER_FROM).setValue((Object)s);
    }

    public String getFromCondition() throws Exception {
        return (String)this.getUIFormSelectBox(FILTER_FROM_CONDITION).getValue();
    }

    public void setFromCondition(String s) throws Exception {
        this.getUIFormSelectBox(FILTER_FROM_CONDITION).setValue(s);
    }

    public String getTo() throws Exception {
        return (String)this.getUIStringInput(FILTER_TO).getValue();
    }

    public void setTo(String s) throws Exception {
        this.getUIStringInput(FILTER_TO).setValue((Object)s);
    }

    public String getToCondition() throws Exception {
        return (String)this.getUIFormSelectBox(FILTER_TO_CONDITION).getValue();
    }

    public void setToCondition(String s) throws Exception {
        this.getUIFormSelectBox(FILTER_TO_CONDITION).setValue(s);
    }

    public String getSubject() throws Exception {
        return (String)this.getUIStringInput(FILTER_SUBJECT).getValue();
    }

    public void setSubject(String s) throws Exception {
        this.getUIStringInput(FILTER_SUBJECT).setValue((Object)s);
    }

    public String getSubjectCondition() throws Exception {
        return (String)this.getUIFormSelectBox(FILTER_SUBJECT_CONDITION).getValue();
    }

    public void setSubjectCondition(String s) throws Exception {
        this.getUIFormSelectBox(FILTER_SUBJECT_CONDITION).setValue(s);
    }

    public String getBody() throws Exception {
        return (String)this.getUIStringInput(FILTER_BODY).getValue();
    }

    public void setBody(String s) throws Exception {
        this.getUIStringInput(FILTER_BODY).setValue((Object)s);
    }

    public String getBodyCondition() throws Exception {
        return (String)this.getUIFormSelectBox(FILTER_BODY_CONDITION).getValue();
    }

    public void setBodyCondition(String s) throws Exception {
        this.getUIFormSelectBox(FILTER_BODY_CONDITION).setValue(s);
    }

    public String getApplyFolder() throws Exception {
        return ((UISelectFolder)this.getChild(UISelectFolder.class)).getSelectedValue();
    }

    public void setApplyFolder(String s) throws Exception {
        ((UISelectFolder)this.getChild(UISelectFolder.class)).setSelectedValue(s);
    }

    public String getApplyTag() throws Exception {
        String tagId = (String)this.getUIStringInput(FILTER_APPLY_TAG).getValue();
        return tagId.equals("choose-tag") ? "" : tagId;
    }

    public void setApplyTag(String s) throws Exception {
        this.getUIStringInput(FILTER_APPLY_TAG).setValue((Object)s);
    }

    public Boolean getApplyAll() throws Exception {
        return this.getUIFormCheckBoxInput(APPLY_ALL_MESSAGE).isChecked();
    }

    public void setApplyAll(boolean b) throws Exception {
        this.getUIFormCheckBoxInput(APPLY_ALL_MESSAGE).setChecked(b);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }
}

