/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.MailSetting;
import org.exoplatform.mail.webui.CalendarUtils;
import org.exoplatform.mail.webui.UIActionBar;
import org.exoplatform.mail.webui.UIMessageArea;
import org.exoplatform.mail.webui.UINavigationContainer;
import org.exoplatform.mail.webui.UISelectAccount;
import org.exoplatform.mail.webui.popup.UIPopupAction;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupMessages;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/mail/webui/UIMailPortlet.gtmpl")
public class UIMailPortlet
extends UIPortletApplication {
    public UIMailPortlet() throws Exception {
        this.addChild(UIActionBar.class, null, null);
        this.addChild(UINavigationContainer.class, null, null);
        String accId = ((UISelectAccount)((UINavigationContainer)this.getChild(UINavigationContainer.class)).getChild(UISelectAccount.class)).getSelectedValue();
        UIMessageArea uiMessageArea = (UIMessageArea)this.createUIComponent(UIMessageArea.class, null, null);
        uiMessageArea.init(accId);
        uiMessageArea.setMailSetting(this.getMailSetting());
        this.addChild((UIComponent)uiMessageArea);
        this.addChild(UIPopupAction.class, null, null);
    }

    public String getAccountId() {
        return ((UISelectAccount)((UINavigationContainer)this.getChild(UINavigationContainer.class)).getChild(UISelectAccount.class)).getSelectedValue();
    }

    public String getCurrentUser() {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public long getPeriodCheckAuto() throws Exception {
        Long period = this.getMailSetting().getPeriodCheckAuto() * 60L * 1000L;
        return period;
    }

    public MailSetting getMailSetting() throws Exception {
        MailService mailSrv = (MailService)this.getApplicationComponent(MailService.class);
        return mailSrv.getMailSetting(this.getCurrentUser());
    }

    public void renderPopupMessages() throws Exception {
        UIPopupMessages popupMess = this.getUIPopupMessages();
        if (popupMess == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        popupMess.processRender(context);
    }

    public void cancelAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIPopupAction popupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
        popupAction.deActivate();
        context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
    }

    public String getRemoteUser() throws Exception {
        return CalendarUtils.getCurrentUser();
    }

    public String getUserToken() throws Exception {
        ContinuationService continuation = (ContinuationService)this.getApplicationComponent(ContinuationService.class);
        try {
            return continuation.getUserToken(this.getRemoteUser());
        }
        catch (Exception e) {
            System.out.println("\n\n can not get UserToken");
            return "";
        }
    }

    public String getRestContextName() {
        return PortalContainer.getInstance().getRestContextName();
    }
}

