/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.webui.UISelectAccount;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/UISelectAccount.gtmpl", events={@EventConfig(listeners={AddAccountActionListener.class}), @EventConfig(listeners={EditAccountActionListener.class}), @EventConfig(listeners={DeleteAccountActionListener.class}), @EventConfig(listeners={SelectAccountActionListener.class})})
public class UISelectAccount
extends UIForm {
    public static final String FIELD_SELECT = "accSelect";

    public UISelectAccount() throws Exception {
        UIFormSelectBox uiSelect = new UIFormSelectBox(FIELD_SELECT, FIELD_SELECT, this.getValues());
        uiSelect.setOnChange("SelectAccount");
        this.addChild((UIComponent)uiSelect);
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    private List<SelectItemOption<String>> getValues() throws Exception {
        MailService mailSvr = (MailService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MailService.class);
        String username = Util.getPortalRequestContext().getRemoteUser();
        List accountList = new ArrayList();
        accountList = mailSvr.getAccounts(username);
        String defaultAcc = mailSvr.getMailSetting(username).getDefaultAccount();
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        for (Account acc : accountList) {
            SelectItemOption option = new SelectItemOption(acc.getLabel(), (Object)acc.getId());
            if (defaultAcc != null && acc.getId().equals(defaultAcc)) {
                option = new SelectItemOption(acc.getLabel() + " (" + this.getLabel("default") + ")", (Object)acc.getId());
                option.setSelected(true);
            }
            options.add((SelectItemOption<String>)option);
        }
        return options;
    }

    public void updateAccount() throws Exception {
        this.getUIFormSelectBox(FIELD_SELECT).setOptions(this.getValues());
    }

    public String getSelectedValue() {
        return (String)((UIFormSelectBox)this.getChild(UIFormSelectBox.class)).getValue();
    }

    public void setSelectedValue(String value) {
        ((UIFormSelectBox)this.getChild(UIFormSelectBox.class)).setValue(value);
    }

    public void refreshItems() throws Exception {
        ((UIFormSelectBox)this.getChild(UIFormSelectBox.class)).getOptions().clear();
        ((UIFormSelectBox)this.getChild(UIFormSelectBox.class)).setOptions(this.getValues());
    }

    public String[] getActions() {
        return new String[]{"AddAccount", "EditAccount", "DeleteAccount"};
    }
}

