/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.webui.UIFolderContainer;
import org.exoplatform.mail.webui.UIMailPortlet;
import org.exoplatform.mail.webui.UINavigationContainer;
import org.exoplatform.mail.webui.UISelectAccount;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/templates/mail/webui/UIFolderContainer.gtmpl", events={@EventConfig(listeners={ChangeFolderActionListener.class}), @EventConfig(listeners={AddFolderActionListener.class}), @EventConfig(listeners={AddSubFolderActionListener.class}), @EventConfig(listeners={RenameFolderActionListener.class}), @EventConfig(listeners={RemoveFolderActionListener.class}, confirm="UIFolderContainer.msg.confirm-remove-folder"), @EventConfig(listeners={MarkReadActionListener.class}), @EventConfig(listeners={EmptyFolderActionListener.class}), @EventConfig(listeners={MoveToTrashActionListener.class})})
public class UIFolderContainer
extends UIContainer {
    private String currentFolder_ = null;
    public int i = 1;
    private boolean isChecking_ = false;

    public void init(String accountId) throws Exception {
        this.currentFolder_ = Utils.generateFID((String)accountId, (String)Utils.FD_INBOX, (boolean)false);
    }

    public String getSelectedFolder() {
        return this.currentFolder_;
    }

    public void setSelectedFolder(String folderId) {
        this.currentFolder_ = folderId;
    }

    public List<Folder> getDefaultFolders() throws Exception {
        return this.getFolders(false);
    }

    public List<Folder> getCustomizeFolders() throws Exception {
        return this.getFolders(true);
    }

    public boolean isChecking() {
        return this.isChecking_;
    }

    public void setIsChecking(boolean b) {
        this.isChecking_ = b;
    }

    public List<Folder> getSubFolders(String parentPath) throws Exception {
        MailService mailSvr = MailUtils.getMailService();
        String username = MailUtils.getCurrentUser();
        String accountId = ((UISelectAccount)((UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class)).findFirstComponentOfType(UISelectAccount.class)).getSelectedValue();
        String id = username;
        if (MailUtils.isDelegated((String)accountId)) {
            id = mailSvr.getDelegatedAccount(username, accountId).getDelegateFrom();
        }
        ArrayList<Folder> subFolders = new ArrayList<Folder>();
        for (Folder f : mailSvr.getSubFolders(id, accountId, parentPath)) {
            subFolders.add(f);
        }
        return subFolders;
    }

    public Folder getCurrentFolder() throws Exception {
        MailService mailSvr = (MailService)this.getApplicationComponent(MailService.class);
        String username = ((UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class)).getCurrentUser();
        String accountId = ((UISelectAccount)((UINavigationContainer)this.getAncestorOfType(UINavigationContainer.class)).getChild(UISelectAccount.class)).getSelectedValue();
        String id = username;
        if (MailUtils.isDelegated((String)accountId)) {
            id = mailSvr.getDelegatedAccount(username, accountId).getDelegateFrom();
        }
        return mailSvr.getFolder(id, accountId, this.getSelectedFolder());
    }

    public List<Folder> getFolders(boolean isPersonal) throws Exception {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        MailService mailSvr = (MailService)this.getApplicationComponent(MailService.class);
        String username = MailUtils.getCurrentUser();
        String accountId = ((UISelectAccount)((UINavigationContainer)this.getAncestorOfType(UINavigationContainer.class)).getChild(UISelectAccount.class)).getSelectedValue();
        try {
            String id = username;
            if (MailUtils.isDelegated((String)accountId)) {
                id = mailSvr.getDelegatedAccount(username, accountId).getDelegateFrom();
            }
            folders.addAll(mailSvr.getFolders(id, accountId, isPersonal));
        }
        catch (Exception e) {
            // empty catch block
        }
        return folders;
    }

    public String[] getActions() {
        return new String[]{"AddFolder"};
    }

    public boolean isImap() throws Exception {
        try {
            MailService mailSvr = MailUtils.getMailService();
            String username = MailUtils.getCurrentUser();
            String accountId = ((UISelectAccount)((UIMailPortlet)this.getAncestorOfType(UIMailPortlet.class)).findFirstComponentOfType(UISelectAccount.class)).getSelectedValue();
            Account dAcc = mailSvr.getDelegatedAccount(username, accountId);
            if (MailUtils.isDelegatedAccount((Account)dAcc, (String)username)) {
                username = dAcc.getDelegateFrom();
            }
            Account acc = mailSvr.getAccountById(username, accountId);
            return Utils.IMAP.equalsIgnoreCase(acc.getProtocol());
        }
        catch (Exception e) {
            return false;
        }
    }
}

