/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.mail.DataCache;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.webui.popup.UIAccountList;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPopupComponent;

@ComponentConfig(template="app:/templates/mail/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIAccountList.msg.confirm-delete"), @EventConfig(listeners={CloseActionListener.class})})
public class UIAccountList
extends UIGrid
implements UIPopupComponent {
    private static final Log log = ExoLogger.getExoLogger(UIAccountList.class);
    private static String[] BEAN_FIELD = new String[]{"name", "email", "server", "protocol"};
    private static String[] BEAN_ACTION = new String[]{"Delete"};

    public UIAccountList() throws Exception {
        this.configure("id", BEAN_FIELD, BEAN_ACTION);
        this.updateGrid();
    }

    public void updateGrid() throws Exception {
        DataCache dataCache = (DataCache)WebuiRequestContext.getCurrentInstance().getAttribute(DataCache.class);
        ArrayList<AccountData> accounts = new ArrayList<AccountData>();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        for (Account acc : dataCache.getAccounts(userId)) {
            accounts.add(new AccountData(this, acc.getId(), acc.getLabel(), acc.getEmailAddress(), (String)acc.getServerProperties().get(Utils.SVR_INCOMING_HOST), acc.getProtocol()));
        }
        for (Account acc : dataCache.getDelegatedAccounts(userId)) {
            accounts.add(new AccountData(this, acc.getId(), acc.getLabel(), acc.getEmailAddress(), (String)acc.getServerProperties().get(Utils.SVR_INCOMING_HOST), acc.getProtocol()));
        }
        LazyPageList pageList = new LazyPageList((ListAccess)new ListAccessImpl(AccountData.class, accounts), 10);
        this.getUIPageIterator().setPageList((PageList)pageList);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String[] getButtons() {
        return new String[]{"Close"};
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

