/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import org.exoplatform.contact.service.AddressBook;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.ContactService;
import org.exoplatform.contact.service.DataStorage;
import org.exoplatform.contact.service.SharedAddressBook;
import org.exoplatform.contact.service.Utils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.webui.popup.UIAddContactForm;
import org.exoplatform.mail.webui.popup.UIFormMultiValueInputSet;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItem;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.core.model.SelectOption;
import org.exoplatform.webui.core.model.SelectOptionGroup;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormSelectBoxWithGroups;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/mail/webui/popup/UIAddContactForm.gtmpl", events={@EventConfig(listeners={AddGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeImageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeleteImageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAddContactForm
extends UIForm
implements UIPopupComponent {
    private static final Log log = ExoLogger.getExoLogger(UIAddContactForm.class);
    public static final String SELECT_GROUP = "select-group".intern();
    public static final String NAME = "name".intern();
    public static final String FIRST_NAME = "first-name".intern();
    public static final String LAST_NAME = "last-name".intern();
    private static final String NICKNAME = "nickName";
    private static final String GENDER = "gender";
    private static final String BIRTHDAY = "birthday";
    private static final String DAY = "day";
    private static final String MONTH = "month";
    private static final String YEAR = "year";
    private static final String JOBTITLE = "jobTitle";
    private static final String EMAIL = "email";
    private UIFormMultiValueInputSet uiFormMultiValue = new UIFormMultiValueInputSet("email", "email");
    private static final String MALE = "Male";
    private static final String FEMALE = "Female";
    private byte[] imageBytes_ = null;
    private Contact tempContact = null;
    private String fileName_ = null;
    private String imageMimeType_ = null;
    public boolean isEdited_ = false;
    public String selectedGroup_;
    public Contact selectedContact_;
    public boolean addedNewGroup_ = false;
    private String sharedContacts_ = "sharedContacts";

    public UIAddContactForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormSelectBoxWithGroups(SELECT_GROUP, SELECT_GROUP, this.getOptions()));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIRST_NAME, FIRST_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(LAST_NAME, LAST_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NICKNAME, NICKNAME, null));
        ArrayList<SelectItemOption> genderOptions = new ArrayList<SelectItemOption>();
        genderOptions.add(new SelectItemOption(MALE, (Object)MALE));
        genderOptions.add(new SelectItemOption(FEMALE, (Object)FEMALE));
        this.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(GENDER, MALE, genderOptions));
        this.addUIFormInput((UIFormInput)new UIFormInputInfo(BIRTHDAY, BIRTHDAY, null));
        ArrayList<SelectItemOption> datesOptions = new ArrayList<SelectItemOption>();
        datesOptions.add(new SelectItemOption("- day -", (Object)DAY));
        for (int i = 1; i < 32; ++i) {
            String date = i + "";
            datesOptions.add(new SelectItemOption(date, (Object)date));
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(DAY, DAY, datesOptions));
        ArrayList<SelectItemOption> monthOptions = new ArrayList<SelectItemOption>();
        monthOptions.add(new SelectItemOption("-month-", (Object)MONTH));
        for (int i = 1; i < 13; ++i) {
            String month = i + "";
            monthOptions.add(new SelectItemOption(month, (Object)month));
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(MONTH, MONTH, monthOptions));
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        String date = MailUtils.formatDate((String)"dd/MM/yyyy", (Date)new Date(), (Locale)locale);
        String strDate = date.substring(date.lastIndexOf("/") + 1, date.length());
        int thisYear = Integer.parseInt(strDate);
        ArrayList<SelectItemOption> yearOptions = new ArrayList<SelectItemOption>();
        yearOptions.add(new SelectItemOption("- year -", (Object)YEAR));
        for (int i = thisYear; i >= 1900; --i) {
            String year = i + "";
            yearOptions.add(new SelectItemOption(year, (Object)year));
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(YEAR, YEAR, yearOptions));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(JOBTITLE, JOBTITLE, null));
        this.uiFormMultiValue.setType(UIFormStringInput.class);
        this.addUIFormInput((UIFormInput)this.uiFormMultiValue);
    }

    public boolean isPrivateGroup(String groupId) {
        SelectOptionGroup privateGroups = (SelectOptionGroup)((UIFormSelectBoxWithGroups)this.getChild(UIFormSelectBoxWithGroups.class)).getOptions().get(0);
        for (SelectOption option : privateGroups.getOptions()) {
            if (!option.getValue().equals(groupId)) continue;
            return true;
        }
        return false;
    }

    public boolean havePermission(Contact contact) throws Exception {
        String group;
        if (!contact.getContactType().equals(DataStorage.SHARED)) {
            return true;
        }
        String currentUser = MailUtils.getCurrentUser();
        if (contact.getEditPermissionUsers() != null && Arrays.asList(contact.getEditPermissionUsers()).contains(currentUser + DataStorage.HYPHEN)) {
            return true;
        }
        String[] editPerGroups = contact.getEditPermissionGroups();
        if (editPerGroups != null) {
            for (String editPer : editPerGroups) {
                if (!MailUtils.getUserGroups().contains(editPer)) continue;
                return true;
            }
        }
        return (group = (String)((UIFormSelectBoxWithGroups)this.getChild(UIFormSelectBoxWithGroups.class)).getValue()) != null && !group.equals(this.sharedContacts_) && MailUtils.havePermission((String)((String)((UIFormSelectBoxWithGroups)this.getChild(UIFormSelectBoxWithGroups.class)).getValue()));
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    public void setTempContact(Contact c) {
        this.tempContact = c;
    }

    public Contact getTempContact() {
        return this.tempContact;
    }

    public List<SelectItem> getOptions() throws Exception {
        String username = MailUtils.getCurrentUser();
        ContactService contactSrv = (ContactService)this.getApplicationComponent(ContactService.class);
        ArrayList<SelectItem> options = new ArrayList<SelectItem>();
        SelectOptionGroup personalContacts = new SelectOptionGroup("personal-contacts");
        for (AddressBook pcg : contactSrv.getGroups(username)) {
            personalContacts.addOption(new SelectOption(pcg.getName(), pcg.getId()));
        }
        options.add((SelectItem)personalContacts);
        SelectOptionGroup sharedContacts = new SelectOptionGroup("shared-contacts");
        for (SharedAddressBook scg : contactSrv.getSharedAddressBooks(username)) {
            if (!MailUtils.havePermission((String)scg.getId())) continue;
            sharedContacts.addOption(new SelectOption(MailUtils.getDisplayAdddressShared((String)scg.getSharedUserId(), (String)scg.getName()), scg.getId()));
        }
        options.add((SelectItem)sharedContacts);
        return options;
    }

    public void fillDatas(Contact ct, String groupId) throws Exception {
        this.isEdited_ = true;
        this.selectedGroup_ = groupId;
        this.selectedContact_ = ct;
        this.tempContact = ct;
        ((UIFormSelectBoxWithGroups)this.getChildById(SELECT_GROUP)).setSelectedValues(new String[]{groupId});
        ((UIFormSelectBoxWithGroups)this.getChildById(SELECT_GROUP)).setEnable(false);
        this.getUIStringInput(FIRST_NAME).setValue((Object)ct.getFirstName());
        this.getUIStringInput(LAST_NAME).setValue((Object)ct.getLastName());
        this.getUIStringInput(NICKNAME).setValue((Object)ct.getNickName());
        ((UIFormRadioBoxInput)this.getChild(UIFormRadioBoxInput.class)).setValue((Object)ct.getGender());
        this.setFieldBirthday(ct.getBirthday());
        this.getUIStringInput(JOBTITLE).setValue((Object)ct.getJobTitle());
        String emails = MailUtils.listToString((List)ct.getEmailAddresses());
        List<Object> list = MailUtils.isFieldEmpty((String)emails) ? new ArrayList() : Arrays.asList(emails.split(Utils.SEMI_COLON));
        if (this.uiFormMultiValue != null) {
            this.removeChildById(EMAIL);
        }
        this.uiFormMultiValue = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
        this.uiFormMultiValue.setId(EMAIL);
        this.uiFormMultiValue.setName(EMAIL);
        this.uiFormMultiValue.setType(UIFormStringInput.class);
        this.uiFormMultiValue.setValue(list);
        this.addUIFormInput((UIFormInput)this.uiFormMultiValue);
        if (ct != null && ct.getAttachment() != null) {
            this.setImage(ct.getAttachment().getInputStream());
        }
    }

    public void setFieldBirthday(Date date) throws Exception {
        if (date != null) {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime(date);
            this.getUIFormSelectBox(MONTH).setValue(String.valueOf(cal.get(2) + 1));
            this.getUIFormSelectBox(DAY).setValue(String.valueOf(cal.get(5)));
            this.getUIFormSelectBox(YEAR).setValue(String.valueOf(cal.get(1)));
        }
    }

    public void refreshGroupList() throws Exception {
        ((UIFormSelectBoxWithGroups)this.getChildById(SELECT_GROUP)).setOptions(this.getOptions());
    }

    public void setFirstNameField(String firstName) throws Exception {
        this.getUIStringInput(FIRST_NAME).setValue((Object)firstName);
    }

    public void setLastNameField(String lastName) throws Exception {
        this.getUIStringInput(LAST_NAME).setValue((Object)lastName);
    }

    public void setAddedNewGroup(boolean b) {
        this.addedNewGroup_ = b;
    }

    public String getNickName() {
        return (String)this.getUIStringInput(NICKNAME).getValue();
    }

    public String getJobTitle() {
        return (String)this.getUIStringInput(JOBTITLE).getValue();
    }

    public void setEmailField(String emails) throws Exception {
        List<Object> list = MailUtils.isFieldEmpty((String)emails) ? new ArrayList() : Arrays.asList(emails.split(Utils.SEMI_COLON));
        if (this.uiFormMultiValue != null) {
            this.removeChildById(EMAIL);
        }
        this.uiFormMultiValue = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
        this.uiFormMultiValue.setId(EMAIL);
        this.uiFormMultiValue.setName(EMAIL);
        this.uiFormMultiValue.setType(UIFormStringInput.class);
        this.uiFormMultiValue.setValue(list);
        this.addUIFormInput((UIFormInput)this.uiFormMultiValue);
    }

    protected String getFieldEmail() {
        List emails = this.uiFormMultiValue.getValue();
        StringBuffer email = new StringBuffer();
        for (String item : emails) {
            if (MailUtils.isFieldEmpty((String)item)) continue;
            if (email.length() == 0) {
                email.append(item);
                continue;
            }
            email.append(Utils.SEMI_COLON + item);
        }
        return email.toString();
    }

    protected String getFieldGender() {
        return (String)((UIFormRadioBoxInput)this.getChild(UIFormRadioBoxInput.class)).getValue();
    }

    protected Date getFieldBirthday() {
        int year = 0;
        int month = 0;
        int day = 0;
        boolean emptyYear = false;
        boolean emptyMonth = false;
        boolean emptyDay = false;
        try {
            day = Integer.parseInt((String)this.getUIFormSelectBox(DAY).getValue());
        }
        catch (NumberFormatException e) {
            emptyDay = true;
        }
        try {
            month = Integer.parseInt((String)this.getUIFormSelectBox(MONTH).getValue());
        }
        catch (NumberFormatException e) {
            emptyMonth = true;
        }
        try {
            year = Integer.parseInt((String)this.getUIFormSelectBox(YEAR).getValue());
        }
        catch (NumberFormatException e) {
            emptyYear = true;
        }
        if (emptyDay && emptyMonth && emptyYear) {
            return null;
        }
        Calendar cal = GregorianCalendar.getInstance();
        cal.setLenient(false);
        cal.set(5, day);
        cal.set(2, month - 1);
        cal.set(1, year);
        return cal.getTime();
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    protected void setImage(InputStream input) throws Exception {
        if (input != null) {
            this.imageBytes_ = new byte[input.available()];
            input.read(this.imageBytes_);
        } else {
            this.imageBytes_ = null;
        }
    }

    protected byte[] getImage() {
        return this.imageBytes_;
    }

    protected String getMimeType() {
        return this.imageMimeType_;
    }

    protected void setMimeType(String mimeType) {
        this.imageMimeType_ = mimeType;
    }

    protected void setFileName(String name) {
        this.fileName_ = name;
    }

    protected String getFileName() {
        return this.fileName_;
    }

    static /* synthetic */ String access$000(UIAddContactForm x0) {
        return x0.sharedContacts_;
    }

    static /* synthetic */ Log access$100() {
        return log;
    }
}

