/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.mail.DataCache;
import org.exoplatform.mail.MailUtils;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.AccountDelegation;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.webui.popup.UIDelegationAccountGrid;
import org.exoplatform.mail.webui.popup.UIDelegationInputSet;
import org.exoplatform.mail.webui.popup.UIMailSettings;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.form.UIFormCheckBoxInput;

@ComponentConfig(template="app:/templates/mail/webui/popup/UIDelegationAccountGrid.gtmpl", events={@EventConfig(listeners={RemoveActionListener.class}, confirm="UIDelegationAccountGrid.grid.msg.confirm-delete")})
public class UIDelegationAccountGrid
extends UIGrid {
    private static final Log log = ExoLogger.getExoLogger(UIDelegationAccountGrid.class);
    public static final String FULL_PRIVILEGE_FIELD = "isFull";
    public static final String READONLY_PRIVILEGE_FIELD = "isReadOnly";
    String[] fields = new String[]{"accountName", "delegatedUserName", "isFull"};
    String[] actions = new String[]{"Remove"};

    public UIDelegationAccountGrid() throws Exception {
        this.configure("id", this.fields, this.actions);
        this.updateGrid();
    }

    private boolean isFull(String user, String perms) {
        return user != null && perms != null && Utils.SEND_RECIEVE.equalsIgnoreCase(perms);
    }

    public void updateGrid() {
        ArrayList<AccountDelegation> delegation;
        block4: {
            DataCache dataCache = (DataCache)WebuiRequestContext.getCurrentInstance().getAttribute(DataCache.class);
            delegation = new ArrayList<AccountDelegation>();
            try {
                String currentuser = MailUtils.getCurrentUser();
                List acclist = dataCache.getAccounts(currentuser);
                for (Account a : acclist) {
                    if (a.getPermissions() == null || a.getPermissions().keySet() == null) continue;
                    for (String receiver : a.getPermissions().keySet()) {
                        AccountDelegation bean = new AccountDelegation(a.getId(), a.getLabel() + "(" + a.getEmailAddress() + ")", receiver, this.isFull(currentuser, (String)a.getPermissions().get(receiver)));
                        delegation.add(bean);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"Exception in method updateGrid", (Throwable)e);
            }
        }
        LazyPageList pageList = new LazyPageList((ListAccess)new ListAccessImpl(AccountDelegation.class, delegation), 10);
        this.getUIPageIterator().setPageList((PageList)pageList);
        this.addCheckboxToParent();
    }

    protected void addCheckboxToParent() {
        try {
            List data = this.getUIPageIterator().getCurrentPageData();
            UIDelegationInputSet deInputSet = (UIDelegationInputSet)this.getParent();
            deInputSet.removeChild(UIFormCheckBoxInput.class);
            deInputSet.addChild((UIComponent)new UIFormCheckBoxInput(UIMailSettings.FIELD_PRIVILEGE_FULL, UIMailSettings.FIELD_PRIVILEGE_FULL, null));
            for (AccountDelegation a : data) {
                UIFormCheckBoxInput cb = new UIFormCheckBoxInput(a.getId(), a.getId(), null);
                cb.setChecked(a.isFull());
                cb.setOnChange("OnChange");
                deInputSet.addChild((UIComponent)cb);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void renderCheckbox(String id) throws Exception {
        UIDelegationInputSet deInputSet = (UIDelegationInputSet)this.getParent();
        if (deInputSet.getChildById(id) != null) {
            deInputSet.renderChild(id);
        }
    }
}

