/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.mail.DataCache;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.mail.webui.WizardStep;
import org.exoplatform.mail.webui.popup.UIAccountCreation;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIAccountWizardStepIntro
extends UIFormInputSet
implements WizardStep {
    public static final String ITEM_ADDNEW = "true";
    public static final String ITEM_EDIT = "false";
    public static final String FIELD_SELECT = "selectActions";
    public static final String FIELD_ACCOUNTS = "acoounts";
    public boolean isValid_ = false;
    private List<String> infoMessage_ = new ArrayList();

    public UIAccountWizardStepIntro(String id) throws Exception {
        this.setId(id);
        ArrayList<SelectItemOption> folderOptions = new ArrayList<SelectItemOption>();
        folderOptions.add(new SelectItemOption(ITEM_ADDNEW, (Object)ITEM_ADDNEW));
        folderOptions.add(new SelectItemOption(ITEM_EDIT, (Object)ITEM_EDIT));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_SELECT, FIELD_SELECT, folderOptions));
        UIFormSelectBox uiSelect = this.getUIFormSelectBox(FIELD_SELECT);
        uiSelect.setOnChange(UIAccountCreation.ACT_CHANGE_ACT);
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_ACCOUNTS, FIELD_ACCOUNTS, this.getAccounts()));
        this.infoMessage_.clear();
        this.infoMessage_.add("UIAccountWizardStepIntro.info.label1");
        this.infoMessage_.add("UIAccountWizardStepIntro.info.label2");
    }

    public List<String> getInfoMessage() {
        return this.infoMessage_;
    }

    public List<SelectItemOption<String>> getAccounts() throws Exception {
        DataCache dataCache = (DataCache)WebuiRequestContext.getCurrentInstance().getAttribute(DataCache.class);
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        if (!this.isCreateNew()) {
            String username = Util.getPortalRequestContext().getRemoteUser();
            for (Account acc : dataCache.getAccounts(username)) {
                options.add((SelectItemOption<String>)new SelectItemOption(acc.getUserDisplayName(), (Object)acc.getId()));
            }
        }
        return options;
    }

    protected void lockFields(boolean isLock) {
        boolean isEditable = !isLock;
        this.getUIFormSelectBox(FIELD_SELECT).setEnable(isEditable);
        this.getUIFormSelectBox(FIELD_ACCOUNTS).setEnable(isEditable);
    }

    protected void resetFields() {
        this.reset();
    }

    public boolean isFieldsValid() {
        return !Utils.isEmptyField((String)this.getSelectedAccount()) || this.isCreateNew();
    }

    protected void fieldsValid(boolean isValid) {
        this.isValid_ = isValid;
    }

    protected void setAccounts(List<SelectItemOption<String>> options) {
        this.getUIFormSelectBox(FIELD_ACCOUNTS).setOptions(options);
    }

    protected String getSelectedAccount() {
        return (String)this.getUIFormSelectBox(FIELD_ACCOUNTS).getValue();
    }

    protected void setSelectedAccount(String value) {
        this.getUIFormSelectBox(FIELD_ACCOUNTS).setValue(value);
    }

    protected boolean isCreateNew() {
        return this.getSelectType().equals(ITEM_ADDNEW);
    }

    protected String getSelectType() {
        return (String)this.getUIFormSelectBox(FIELD_SELECT).getValue();
    }

    public void fillFields(Account acc) {
    }
}

