/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rest.client.openfire;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.rest.client.openfire.ExoGroupProvider;
import org.exoplatform.rest.client.openfire.Utils;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserCollection;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.openfire.user.UserProvider;
import org.jivesoftware.util.JiveGlobals;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoUserProvider
implements UserProvider {
    private static final Log log = LogFactory.getLog(ExoGroupProvider.class);
    private static final String FIND_USERS_URL = "eXo.provider.exoUserProvider.findUsersURL";
    private static final String FIND_USERS_METHHOD = "eXo.provider.exoUserProvider.findUsersMethod";
    private static final String FIND_USERS_PARAMS = "eXo.provider.exoUserProvider.findUsersParams";
    private static final String GET_USERS_URL = "eXo.provider.exoUserProvider.getUsersURL";
    private static final String GET_USERS_METHOD = "eXo.provider.exoUserProvider.getUsersMethod";
    private static final String GET_USERS_PARAMS = "eXo.provider.exoUserProvider.getUsersParams";
    private static final String USERS_COUNT_URL = "eXo.provider.exoUserProvider.usersCountURL";
    private static final String USERS_COUNT_METHOD = "eXo.provider.exoUserProvider.usersCountMethod";
    private static final String USERS_COUNT_PARAMS = "eXo.provider.exoUserProvider.usersCountParams";
    private static final String USER_INFO_URL = "eXo.provider.exoUserProvider.userInfoURL";
    private static final String USER_INFO_METHOD = "eXo.provider.exoUserProvider.userInfoMethod";
    private static final String USER_INFO_PARAMS = "eXo.provider.exoUserProvider.userInfoParams";
    private final String findUsersURL_;
    private final String findUsersMethod_;
    private final Map<String, String> findUsersParams_;
    private final String getUsersURL_;
    private final String getUsersMethod_;
    private final Map<String, String> getUsersParams_;
    private final String usersCountURL_;
    private final String usersCountMethod_;
    private final Map<String, String> usersCountParams_;
    private final String userInfoURL_;
    private final String userInfoMethod_;
    private final Map<String, String> userInfoParams_;

    public ExoUserProvider() {
        String t = JiveGlobals.getXMLProperty((String)FIND_USERS_URL);
        this.findUsersURL_ = Utils.getBaseURL() + (t.endsWith("/") ? t : t + "/");
        this.findUsersMethod_ = JiveGlobals.getXMLProperty((String)FIND_USERS_METHHOD);
        this.findUsersParams_ = Utils.parseQuery(JiveGlobals.getXMLProperties((String)FIND_USERS_PARAMS));
        t = JiveGlobals.getXMLProperty((String)GET_USERS_URL);
        this.getUsersURL_ = Utils.getBaseURL() + (t.endsWith("/") ? t : t + "/");
        this.getUsersMethod_ = JiveGlobals.getXMLProperty((String)GET_USERS_METHOD);
        this.getUsersParams_ = Utils.parseQuery(JiveGlobals.getXMLProperties((String)GET_USERS_PARAMS));
        t = JiveGlobals.getXMLProperty((String)USERS_COUNT_URL);
        this.usersCountURL_ = Utils.getBaseURL() + (t.endsWith("/") ? t : t + "/");
        this.usersCountMethod_ = JiveGlobals.getXMLProperty((String)USERS_COUNT_METHOD);
        this.usersCountParams_ = Utils.parseQuery(JiveGlobals.getXMLProperties((String)USERS_COUNT_PARAMS));
        t = JiveGlobals.getXMLProperty((String)USER_INFO_URL);
        this.userInfoURL_ = Utils.getBaseURL() + (t.endsWith("/") ? t : t + "/");
        this.userInfoMethod_ = JiveGlobals.getXMLProperty((String)USER_INFO_METHOD);
        this.userInfoParams_ = Utils.parseQuery(JiveGlobals.getXMLProperties((String)USER_INFO_PARAMS));
    }

    public Collection<User> findUsers(Set<String> fields, String query) throws UnsupportedOperationException {
        String url = this.findUsersURL_;
        String method = this.findUsersMethod_;
        if (query == null || "".equals(query) || fields.isEmpty()) {
            return Collections.emptyList();
        }
        if (!this.getSearchFields().containsAll(fields)) {
            throw new IllegalArgumentException("Search fields " + fields + " are not valid.");
        }
        Collection<String> usernames = this.findUsers(fields, query, url, method);
        return new UserCollection(usernames.toArray(new String[usernames.size()]));
    }

    public Collection<User> findUsers(Set<String> fields, String query, int startIndex, int numResults) throws UnsupportedOperationException {
        String url = this.findUsersURL_ + startIndex + "/" + (startIndex + numResults);
        String method = this.findUsersMethod_;
        if (query == null || "".equals(query) || fields.isEmpty()) {
            return Collections.emptyList();
        }
        if (!this.getSearchFields().containsAll(fields)) {
            throw new IllegalArgumentException("Search fields " + fields + " are not valid.");
        }
        Collection<String> usernames = this.findUsers(fields, query, url, method);
        return new UserCollection(usernames.toArray(new String[usernames.size()]));
    }

    private Collection<String> findUsers(Set<String> fields, String query, String url, String method) {
        Utils.Response resp;
        block9: {
            resp = null;
            HashMap<String, String> params = new HashMap<String, String>(this.findUsersParams_);
            for (String field : fields) {
                if ("name".equals(field)) {
                    params.put("firstname", query);
                    params.put("lastname", query);
                    continue;
                }
                params.put(field, query);
            }
            try {
                if ("POST".equalsIgnoreCase(method)) {
                    resp = Utils.doPost(new URL(url), params);
                    break block9;
                }
                if ("GET".equalsIgnoreCase(method)) {
                    resp = Utils.doGet(new URL(url), params);
                    break block9;
                }
                throw new IllegalStateException("Configuration error, only HTTP methods 'POST' or 'GET' are allowed, but found '" + method + "'.");
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exception in method findUsers", (Throwable)e);
                }
                return null;
            }
        }
        if (resp.getStatus() == 200) {
            return this.createUserList(resp.getResponseDoc());
        }
        if (resp.getStatus() == 404) {
            return Collections.emptyList();
        }
        throw new IllegalStateException("Unknown response status : " + resp.getStatus());
    }

    public Set<String> getSearchFields() throws UnsupportedOperationException {
        return new HashSet<String>(Arrays.asList("username", "name", "email"));
    }

    public int getUserCount() {
        Utils.Response resp;
        block6: {
            resp = null;
            String url = this.usersCountURL_;
            String method = this.usersCountMethod_;
            HashMap<String, String> params = new HashMap<String, String>(this.usersCountParams_);
            try {
                if ("POST".equalsIgnoreCase(method)) {
                    resp = Utils.doPost(new URL(url), params);
                    break block6;
                }
                if ("GET".equalsIgnoreCase(method)) {
                    resp = Utils.doGet(new URL(url), params);
                    break block6;
                }
                throw new IllegalStateException("Configuration error, only HTTP methods 'POST' or 'GET' are allowed, but found '" + method + "'.");
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exception in method getUserCount", (Throwable)e);
                }
                return -1;
            }
        }
        if (resp.getStatus() == 200) {
            Document d = resp.getResponseDoc();
            return Integer.valueOf(d.getDocumentElement().getElementsByTagName("number").item(0).getTextContent());
        }
        throw new IllegalStateException("Unknown response status : " + resp.getStatus());
    }

    public Collection<String> getUsernames() {
        return this.getUsernames(this.getUsersURL_, this.getUsersMethod_);
    }

    public Collection<User> getUsers() {
        Collection<String> usernames = this.getUsernames(this.getUsersURL_, this.getUsersMethod_);
        return new UserCollection(usernames.toArray(new String[usernames.size()]));
    }

    public Collection<User> getUsers(int startIndex, int numResults) {
        String url = this.getUsersURL_ + startIndex + "/" + (startIndex + numResults);
        String method = this.getUsersMethod_;
        Collection<String> usernames = this.getUsernames(url, method);
        return new UserCollection(usernames.toArray(new String[usernames.size()]));
    }

    private Collection<String> getUsernames(String url, String method) {
        Utils.Response resp;
        block6: {
            resp = null;
            HashMap<String, String> params = new HashMap<String, String>(this.getUsersParams_);
            try {
                if ("POST".equalsIgnoreCase(method)) {
                    resp = Utils.doPost(new URL(url), params);
                    break block6;
                }
                if ("GET".equalsIgnoreCase(method)) {
                    resp = Utils.doGet(new URL(url), params);
                    break block6;
                }
                throw new IllegalStateException("Configuration error, only HTTP methods 'POST' or 'GET' are allowed, but found '" + method + "'.");
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exception in method getUsernames", (Throwable)e);
                }
                return null;
            }
        }
        if (resp.getStatus() == 200) {
            return this.createUserList(resp.getResponseDoc());
        }
        throw new IllegalStateException("Unknown response status : " + resp.getStatus());
    }

    public boolean isEmailRequired() {
        return true;
    }

    public boolean isNameRequired() {
        return true;
    }

    public boolean isReadOnly() {
        return true;
    }

    public User loadUser(String username) throws UserNotFoundException {
        Utils.Response resp;
        block7: {
            String url = this.userInfoURL_ + username + "/";
            String method = this.userInfoMethod_;
            HashMap<String, String> params = new HashMap<String, String>(this.userInfoParams_);
            resp = null;
            try {
                if ("POST".equalsIgnoreCase(method)) {
                    resp = Utils.doPost(new URL(url), params);
                    break block7;
                }
                if ("GET".equalsIgnoreCase(method)) {
                    resp = Utils.doGet(new URL(url), params);
                    break block7;
                }
                throw new IllegalStateException("Configuration error, only HTTP methods 'POST' or 'GET' are allowed, but found '" + method + "'.");
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exception in method loadUser", (Throwable)e);
                }
                return null;
            }
        }
        if (resp.getStatus() == 200) {
            Document d = resp.getResponseDoc();
            String name = d.getDocumentElement().getElementsByTagName("first-name").item(0).getTextContent();
            String email = d.getDocumentElement().getElementsByTagName("email").item(0).getTextContent();
            return new User(username, name, email, new Date(), new Date());
        }
        if (resp.getStatus() == 404) {
            throw new UserNotFoundException("User '" + username + "' not found!");
        }
        throw new IllegalStateException("Unknown response status : " + resp.getStatus());
    }

    private List<String> createUserList(Document d) {
        ArrayList<String> usernames = new ArrayList<String>();
        NodeList u = d.getDocumentElement().getElementsByTagName("name");
        for (int i = 0; i < u.getLength(); ++i) {
            usernames.add(u.item(i).getTextContent());
        }
        return usernames;
    }

    public void setCreationDate(String username, Date creationDate) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void setEmail(String username, String email) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void setModificationDate(String username, Date modificationDate) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void setName(String username, String name) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    public User createUser(String username, String password, String name, String email) throws UserAlreadyExistsException {
        throw new UnsupportedOperationException();
    }

    public void deleteUser(String username) {
        throw new UnsupportedOperationException();
    }
}

