/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.rest.client.openfire;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.rest.client.openfire.Utils;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupAlreadyExistsException;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.group.GroupProvider;
import org.jivesoftware.util.JiveGlobals;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmpp.packet.JID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoGroupProvider
implements GroupProvider {
    private static final Log log = LogFactory.getLog(ExoGroupProvider.class);
    private static final String GROUPS_COUNT_URL = "eXo.provider.exoGroupProvider.groupsCountURL";
    private static final String GROUPS_COUNT_METHOD = "eXo.provider.exoGroupProvider.groupsCountMethod";
    private static final String GROUPS_COUNT_PARAMS = "eXo.provider.exoGroupProvider.groupsCountParams";
    private static final String GET_GROUPS_ALL_URL = "eXo.provider.exoGroupProvider.getGroupsAllURL";
    private static final String GET_GROUPS_ALL_METHOD = "eXo.provider.exoGroupProvider.getGroupsAllMethod";
    private static final String GET_GROUPS_ALL_PARAMS = "eXo.provider.exoGroupProvider.getGroupsAllParams";
    private static final String GET_GROUPS_RANGE_URL = "eXo.provider.exoGroupProvider.getGroupsRangeURL";
    private static final String GET_GROUPS_RANGE_METHOD = "eXo.provider.exoGroupProvider.getGroupsRangeMethod";
    private static final String GET_GROUPS_RANGE_PARAMS = "eXo.provider.exoGroupProvider.getGroupsRangeParams";
    private static final String GET_GROUPS_FORUSER_URL = "eXo.provider.exoGroupProvider.getGroupsForUserURL";
    private static final String GET_GROUPS_FORUSER_METHOD = "eXo.provider.exoGroupProvider.getGroupsForUserMethod";
    private static final String GET_GROUPS_FORUSER_PARAMS = "eXo.provider.exoGroupProvider.getGroupsForUserParams";
    private static final String GROUP_INFO_URL = "eXo.provider.exoGroupProvider.groupInfoURL";
    private static final String GROUP_INFO_METHOD = "eXo.provider.exoGroupProvider.groupInfoMethod";
    private static final String GROUP_INFO_PARAMS = "eXo.provider.exoGroupProvider.groupInfoParams";
    private final String groupInfoURL_;
    private final String groupInfoMethod_;
    private final Map<String, String> groupInfoParams_;
    private final String getGroupsAllURL_;
    private final String getGroupsAllMethod_;
    private final Map<String, String> getGroupsAllParams_;
    private final String getGroupsRangeURL_;
    private final String getGroupsRangeMethod_;
    private final Map<String, String> getGroupsRangeParams_;
    private final String getGroupsForUserURL_;
    private final String getGroupsForUserMethod_;
    private final Map<String, String> getGroupsForUserParams_;
    private final String groupsCountURL_;
    private final String groupsCountMethod_;
    private final Map<String, String> groupsCountParams_;

    public ExoGroupProvider() {
        String t = JiveGlobals.getXMLProperty((String)GROUP_INFO_URL);
        this.groupInfoURL_ = Utils.getBaseURL() + (t.endsWith("/") ? t : t + "/");
        this.groupInfoMethod_ = JiveGlobals.getXMLProperty((String)GROUP_INFO_METHOD);
        this.groupInfoParams_ = Utils.parseQuery(JiveGlobals.getXMLProperties((String)GROUP_INFO_PARAMS));
        t = JiveGlobals.getXMLProperty((String)GET_GROUPS_ALL_URL);
        this.getGroupsAllURL_ = Utils.getBaseURL() + (t.endsWith("/") ? t : t + "/");
        this.getGroupsAllMethod_ = JiveGlobals.getXMLProperty((String)GET_GROUPS_ALL_METHOD);
        this.getGroupsAllParams_ = Utils.parseQuery(JiveGlobals.getXMLProperties((String)GET_GROUPS_ALL_PARAMS));
        t = JiveGlobals.getXMLProperty((String)GET_GROUPS_RANGE_URL);
        this.getGroupsRangeURL_ = Utils.getBaseURL() + (t.endsWith("/") ? t : t + "/");
        this.getGroupsRangeMethod_ = JiveGlobals.getXMLProperty((String)GET_GROUPS_RANGE_METHOD);
        this.getGroupsRangeParams_ = Utils.parseQuery(JiveGlobals.getXMLProperties((String)GET_GROUPS_RANGE_PARAMS));
        t = JiveGlobals.getXMLProperty((String)GROUPS_COUNT_URL);
        this.groupsCountURL_ = Utils.getBaseURL() + (t.endsWith("/") ? t : t + "/");
        this.groupsCountMethod_ = JiveGlobals.getXMLProperty((String)GROUPS_COUNT_METHOD);
        this.groupsCountParams_ = Utils.parseQuery(JiveGlobals.getXMLProperties((String)GROUPS_COUNT_PARAMS));
        t = JiveGlobals.getXMLProperty((String)GET_GROUPS_FORUSER_URL);
        this.getGroupsForUserURL_ = Utils.getBaseURL() + (t.endsWith("/") ? t : t + "/");
        this.getGroupsForUserMethod_ = JiveGlobals.getXMLProperty((String)GET_GROUPS_FORUSER_METHOD);
        this.getGroupsForUserParams_ = Utils.parseQuery(JiveGlobals.getXMLProperties((String)GET_GROUPS_FORUSER_PARAMS));
    }

    public Group getGroup(String group) throws GroupNotFoundException {
        Utils.Response resp;
        block8: {
            String url = this.groupInfoURL_;
            String method = this.groupInfoMethod_;
            HashMap<String, String> params = new HashMap<String, String>(this.groupInfoParams_);
            resp = null;
            url = url + group + "/";
            try {
                if ("POST".equalsIgnoreCase(method)) {
                    resp = Utils.doPost(new URL(url), params);
                    break block8;
                }
                if ("GET".equalsIgnoreCase(method)) {
                    resp = Utils.doGet(new URL(url), params);
                    break block8;
                }
                throw new IllegalStateException("Configuration error, only HTTP methods 'POST' or 'GET' are allowed, but found '" + method + "'.");
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exception in method getGroup", (Throwable)e);
                }
                return null;
            }
        }
        if (resp.getStatus() == 200) {
            Document d = resp.getResponseDoc();
            String description = d.getDocumentElement().getElementsByTagName("description").item(0).getTextContent();
            NodeList t = d.getDocumentElement().getElementsByTagName("member");
            ArrayList<JID> members = new ArrayList<JID>();
            for (int i = 0; i < t.getLength(); ++i) {
                members.add(new JID(t.item(i).getTextContent()));
            }
            List administrators = Collections.emptyList();
            return new Group(group, description, members, administrators);
        }
        if (resp.getStatus() == 404) {
            throw new GroupNotFoundException();
        }
        throw new IllegalStateException("Unknown response status : " + resp.getStatus());
    }

    public int getGroupCount() {
        Utils.Response resp;
        block6: {
            String url = this.groupsCountURL_;
            String method = this.groupsCountMethod_;
            HashMap<String, String> params = new HashMap<String, String>(this.groupsCountParams_);
            resp = null;
            try {
                if ("POST".equalsIgnoreCase(method)) {
                    resp = Utils.doPost(new URL(url), params);
                    break block6;
                }
                if ("GET".equalsIgnoreCase(method)) {
                    resp = Utils.doGet(new URL(url), params);
                    break block6;
                }
                throw new IllegalStateException("Configuration error, only HTTP methods 'POST' or 'GET' are allowed, but found '" + method + "'.");
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exception in method getGroupCount", (Throwable)e);
                }
                return -1;
            }
        }
        if (resp.getStatus() == 200) {
            Document d = resp.getResponseDoc();
            Integer count = Integer.valueOf(d.getDocumentElement().getElementsByTagName("number").item(0).getTextContent());
            return count - 1;
        }
        throw new IllegalStateException("Unknown response status : " + resp.getStatus());
    }

    public Collection<String> getGroupNames() {
        String url = this.getGroupsAllURL_;
        String method = this.getGroupsAllMethod_;
        HashMap<String, String> params = new HashMap<String, String>(this.getGroupsAllParams_);
        return this.getGroupNames(url, method, params);
    }

    public Collection<String> getGroupNames(int startIndex, int numResults) {
        String url = this.getGroupsRangeURL_;
        String method = this.getGroupsRangeMethod_;
        HashMap<String, String> params = new HashMap<String, String>(this.getGroupsRangeParams_);
        url = url + startIndex + "/" + (startIndex + numResults);
        return this.getGroupNames(url, method, params);
    }

    public Collection<String> getGroupNames(JID user) {
        String url = this.getGroupsForUserURL_;
        String method = this.getGroupsForUserMethod_;
        HashMap<String, String> params = new HashMap<String, String>(this.getGroupsForUserParams_);
        params.put("username", user.getNode());
        return this.getGroupNames(url, method, params);
    }

    public Collection<String> getSharedGroupsNames() {
        return Collections.emptyList();
    }

    public Collection<String> search(String query) {
        return Collections.emptyList();
    }

    public Collection<String> search(String query, int startIndex, int numResults) {
        return Collections.emptyList();
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isSearchSupported() {
        return false;
    }

    private Collection<String> getGroupNames(String url, String method, HashMap<String, String> params) {
        Utils.Response resp;
        block6: {
            resp = null;
            try {
                if ("POST".equalsIgnoreCase(method)) {
                    resp = Utils.doPost(new URL(url), params);
                    break block6;
                }
                if ("GET".equalsIgnoreCase(method)) {
                    resp = Utils.doGet(new URL(url), params);
                    break block6;
                }
                throw new IllegalStateException("Configuration error, only HTTP methods 'POST' or 'GET' are allowed, but found '" + method + "'.");
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exception in method getGroupNames", (Throwable)e);
                }
                return null;
            }
        }
        if (resp.getStatus() == 200) {
            return this.createGroupList(resp.getResponseDoc());
        }
        throw new IllegalStateException("Unknown response status : " + resp.getStatus());
    }

    private List<String> createGroupList(Document d) {
        ArrayList<String> groupnames = new ArrayList<String>();
        NodeList u = d.getDocumentElement().getElementsByTagName("group");
        for (int i = 0; i < u.getLength(); ++i) {
            Node descendantGroup = u.item(i);
            NamedNodeMap attribs = descendantGroup.getAttributes();
            String groupName = attribs.getNamedItem("groupId").getNodeValue();
            String getGroups = this.getGroupNameWithDescendants(groupName);
            for (String _group : getGroups.split(":")) {
                if (_group.startsWith("/")) {
                    _group = _group.substring(1);
                }
                groupnames.add(_group);
            }
        }
        return groupnames;
    }

    private String getGroupNameWithDescendants(String group) {
        Utils.Response resp;
        block9: {
            String url = this.getGroupsAllURL_;
            String method = this.getGroupsAllMethod_;
            resp = null;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("parentId", group);
            try {
                if ("POST".equalsIgnoreCase(method)) {
                    resp = Utils.doPost(new URL(url), params);
                    break block9;
                }
                if ("GET".equalsIgnoreCase(method)) {
                    resp = Utils.doGet(new URL(url), params);
                    break block9;
                }
                throw new IllegalStateException("Configuration error, only HTTP methods 'POST' or 'GET' are allowed, but found '" + method + "'.");
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exception in method getGroupNameWithDescendants", (Throwable)e);
                }
                return null;
            }
        }
        if (resp.getStatus() == 200) {
            Document d = resp.getResponseDoc();
            NodeList groupList = d.getDocumentElement().getElementsByTagName("group");
            if (groupList.getLength() == 0) {
                return group;
            }
            StringBuffer compositeGroupName = new StringBuffer(group);
            for (int i = 0; i < groupList.getLength(); ++i) {
                Node descendantGroup = groupList.item(i);
                NamedNodeMap attribs = descendantGroup.getAttributes();
                String groupId = attribs.getNamedItem("groupId").getNodeValue();
                compositeGroupName.append(":");
                compositeGroupName.append(this.getGroupNameWithDescendants(groupId));
            }
            return compositeGroupName.toString();
        }
        if (resp.getStatus() == 404) {
            throw new IllegalStateException("Group not found");
        }
        throw new IllegalStateException("Unknown response status : " + resp.getStatus());
    }

    public void addMember(String groupName, JID user, boolean administrator) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Group createGroup(String name) throws UnsupportedOperationException, GroupAlreadyExistsException {
        throw new UnsupportedOperationException();
    }

    public void deleteGroup(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void deleteMember(String groupName, JID user) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setDescription(String name, String description) throws GroupNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void setName(String oldName, String newName) throws UnsupportedOperationException, GroupAlreadyExistsException {
        throw new UnsupportedOperationException();
    }

    public void updateMember(String groupName, JID user, boolean administrator) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

