/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest.json;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.rest.RESTOrganizationServiceAbstractImpl;
import org.exoplatform.services.organization.rest.json.CountBean;
import org.exoplatform.services.organization.rest.json.UserBean;
import org.exoplatform.services.organization.rest.json.UserListBean;
import org.exoplatform.services.rest.ContextParam;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.ws.frameworks.json.transformer.Bean2JsonOutputTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@URITemplate(value="/organization/json/")
public class RESTOrganizationServiceJSONImpl
extends RESTOrganizationServiceAbstractImpl
implements ResourceContainer {
    protected static final String JSON_CONTENT_TYPE = "application/json";
    private static final String ASCENDING = "ascending";
    private static final String DESCENDING = "descending";
    private static final String USERNAME = "username";
    private static final String FIRSTNAME = "firstname";
    private static final String LASTNAME = "lastname";

    public RESTOrganizationServiceJSONImpl(OrganizationService organizationService) {
        super(organizationService);
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/user/find-all/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response findUsers(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="username") String username, @QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname, @QueryParam(value="email") String email, @QueryParam(value="fromLoginDate") String fromLoginDate, @QueryParam(value="toLogindate") String toLoginDate) {
        try {
            Query query = new Query();
            query.setUserName(username);
            query.setFirstName(firstname);
            query.setLastName(lastname);
            query.setEmail(email);
            if (fromLoginDate != null) {
                try {
                    query.setFromLoginDate(DateFormat.getDateTimeInstance().parse(fromLoginDate));
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("Thrown exception : " + e));
                }
            }
            if (toLoginDate != null) {
                try {
                    query.setToLoginDate(DateFormat.getDateTimeInstance().parse(toLoginDate));
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("Thrown exception : " + e));
                }
            }
            PageList pageList = this.userHandler.findUsers(query);
            ArrayList list = new ArrayList();
            int pages = pageList.getAvailablePage();
            for (int i = 1; i <= pages; ++i) {
                list.addAll(pageList.getPage(i));
            }
            ArrayList<UserBean> listBean = new ArrayList<UserBean>();
            for (User user : list) {
                if (user == null) continue;
                listBean.add(new UserBean(user));
            }
            UserListBean user_list = new UserListBean(listBean);
            return Response.Builder.ok((Object)user_list, (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/user/find-user-in-range/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response findUsersRange(@ContextParam(value="baseURI") String baseURI, @QueryParam(value="question") String question, @QueryParam(value="from") Integer from, @QueryParam(value="to") Integer to, @QueryParam(value="sort-order") String sortOrder, @QueryParam(value="sort-field") String sortField) {
        try {
            List temp = new ArrayList();
            Comparator<User> comparator = this.getComparator(sortField, sortOrder);
            if (comparator == null) {
                LOGGER.error((Object)("You set wrong parameters fo sorting! sort-order = [ascending, descending], sort-field = [username, lastname, firstname]. You set sort-field = " + sortField + " sort-order = " + sortOrder));
                return Response.Builder.withStatus((int)400).errorMessage("You set wrong parameters fo sorting! sort-order = [ascending, descending], sort-field = [username, lastname, firstname]. You set sort-field = " + sortField + " sort-order = " + sortOrder).build();
            }
            TreeSet<User> users = new TreeSet<User>(comparator);
            int numResult = to - from;
            if (numResult <= 0) {
                return Response.Builder.noContent().build();
            }
            Query query = new Query();
            query.setUserName(question);
            PageList pageList = this.userHandler.findUsers(query);
            pageList.setPageSize(numResult);
            int page = from / numResult + 1;
            temp = pageList.getPage(page);
            for (User user : temp) {
                if (users.contains(user)) continue;
                users.add(user);
            }
            query = new Query();
            query.setFirstName(question);
            pageList = this.userHandler.findUsers(query);
            pageList.setPageSize(numResult);
            page = from / numResult + 1;
            temp = pageList.getPage(page);
            for (User user : temp) {
                if (users.contains(user)) continue;
                users.add(user);
            }
            query = new Query();
            query.setLastName(question);
            pageList = this.userHandler.findUsers(query);
            pageList.setPageSize(numResult);
            page = from / numResult + 1;
            temp = pageList.getPage(page);
            for (User user : temp) {
                if (users.contains(user)) continue;
                users.add(user);
            }
            ArrayList<UserBean> uList = new ArrayList<UserBean>();
            for (User user : users) {
                uList.add(new UserBean(user));
            }
            UserListBean user_list = new UserListBean(uList);
            user_list.setTotalUser(this.userHandler.getUserPageList(20).getAvailable());
            return Response.Builder.ok((Object)user_list, (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/user/info/{username}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getUser(@URIParam(value="username") String username) {
        try {
            User user = this.userHandler.findUserByName(username);
            if (user == null) {
                return Response.Builder.withStatus((int)404).errorMessage("User '" + username + "' not found.").build();
            }
            return Response.Builder.ok((Object)user).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/users/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getUsers(@ContextParam(value="baseURI") String baseURI) {
        return Response.Builder.noContent().build();
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/user/count/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response getUsersCount() {
        try {
            int number = this.userHandler.getUserPageList(20).getAvailable();
            return Response.Builder.ok((Object)new CountBean(number), (String)JSON_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Thrown exception : " + e));
            return Response.Builder.withStatus((int)500).errorMessage("Thrown exception : " + e).build();
        }
    }

    private Comparator<User> getComparator(String sortField, String sortOrder) {
        if (sortOrder == null || sortOrder.length() == 0) {
            sortOrder = ASCENDING;
        }
        if (sortField == null || sortField.length() == 0) {
            sortField = USERNAME;
        }
        if (sortOrder.equalsIgnoreCase(ASCENDING)) {
            if (sortField.equalsIgnoreCase(FIRSTNAME)) {
                return new FirstNameComporatorAsc();
            }
            if (sortField.equalsIgnoreCase(LASTNAME)) {
                return new LastNameComporatorAsc();
            }
            if (sortField.equalsIgnoreCase(USERNAME)) {
                return new UserNameComporatorAsc();
            }
        } else if (sortOrder.equalsIgnoreCase(DESCENDING)) {
            if (sortField.equalsIgnoreCase(FIRSTNAME)) {
                return new FirstNameComporatorDesc();
            }
            if (sortField.equalsIgnoreCase(LASTNAME)) {
                return new LastNameComporatorDesc();
            }
            if (sortField.equalsIgnoreCase(USERNAME)) {
                return new UserNameComporatorDesc();
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LastNameComporatorDesc
    implements Comparator<User> {
        private LastNameComporatorDesc() {
        }

        @Override
        public int compare(User u1, User u2) {
            if (u1.getLastName() == null) {
                return -1;
            }
            if (u2.getLastName() == null) {
                return 1;
            }
            return -u1.getLastName().compareTo(u2.getLastName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LastNameComporatorAsc
    implements Comparator<User> {
        private LastNameComporatorAsc() {
        }

        @Override
        public int compare(User u1, User u2) {
            if (u1.getLastName() == null) {
                return 1;
            }
            if (u2.getLastName() == null) {
                return -1;
            }
            return u1.getLastName().compareTo(u2.getLastName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FirstNameComporatorDesc
    implements Comparator<User> {
        private FirstNameComporatorDesc() {
        }

        @Override
        public int compare(User u1, User u2) {
            if (u1.getFirstName() == null) {
                return -1;
            }
            if (u2.getFirstName() == null) {
                return 1;
            }
            return -u1.getFirstName().compareTo(u2.getFirstName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FirstNameComporatorAsc
    implements Comparator<User> {
        private FirstNameComporatorAsc() {
        }

        @Override
        public int compare(User u1, User u2) {
            if (u1.getFirstName() == null) {
                return 1;
            }
            if (u2.getFirstName() == null) {
                return -1;
            }
            return u1.getFirstName().compareTo(u2.getFirstName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UserNameComporatorDesc
    implements Comparator<User> {
        private UserNameComporatorDesc() {
        }

        @Override
        public int compare(User u1, User u2) {
            return -u1.getUserName().compareTo(u2.getUserName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UserNameComporatorAsc
    implements Comparator<User> {
        private UserNameComporatorAsc() {
        }

        @Override
        public int compare(User u1, User u2) {
            return u1.getUserName().compareTo(u2.getUserName());
        }
    }
}

