/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest.xml;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.rest.transformer.SerializableEntity;

public class UserXMLEntity
implements SerializableEntity {
    private final User user_;

    public UserXMLEntity(User user) {
        this.user_ = user;
    }

    public void writeObject(OutputStream _out) throws IOException {
        try {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
            XMLStreamWriter xsw = outputFactory.createXMLStreamWriter(_out);
            xsw.writeStartDocument();
            xsw.writeStartElement("user");
            xsw.writeDefaultNamespace("http://exoplatform.org/organization/rest");
            xsw.writeAttribute("user-name", this.user_.getUserName());
            xsw.writeStartElement("first-name");
            xsw.writeCharacters(this.user_.getFirstName() != null ? this.user_.getFirstName() : "");
            xsw.writeEndElement();
            xsw.writeStartElement("last-name");
            xsw.writeCharacters(this.user_.getLastName() != null ? this.user_.getLastName() : "");
            xsw.writeEndElement();
            xsw.writeStartElement("email");
            xsw.writeCharacters(this.user_.getEmail() != null ? this.user_.getEmail() : "");
            xsw.writeEndElement();
            xsw.writeStartElement("password");
            xsw.writeCharacters(this.user_.getPassword() != null ? this.user_.getPassword() : "");
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.flush();
            xsw.close();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

