/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.bayeux.request;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import org.apache.tomcat.bayeux.BayeuxException;
import org.apache.tomcat.bayeux.BayeuxRequest;
import org.apache.tomcat.bayeux.ClientImpl;
import org.apache.tomcat.bayeux.HttpError;
import org.apache.tomcat.bayeux.RequestBase;
import org.apache.tomcat.bayeux.TomcatBayeux;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.jboss.servlet.http.HttpEvent;

public class MetaDisconnectRequest
extends RequestBase
implements BayeuxRequest {
    protected static HashMap<String, Object> responseTemplate = new HashMap();

    public MetaDisconnectRequest(TomcatBayeux tb, HttpEvent event, JSONObject jsReq) throws JSONException {
        super(tb, event, jsReq);
    }

    public HttpError validate() {
        if (this.clientId == null || !this.getTomcatBayeux().hasClient(this.clientId)) {
            return new HttpError(400, "Client Id not valid.", null);
        }
        return null;
    }

    public int process(int prevops) throws BayeuxException {
        prevops = super.process(prevops);
        this.response = (HashMap)responseTemplate.clone();
        ClientImpl client = (ClientImpl)this.getTomcatBayeux().getClient(this.clientId);
        HttpError error = this.validate();
        if (error == null) {
            ((HashMap)this.response.get("advice")).put("reconnect", "retry");
            ((HashMap)this.response.get("advice")).put("interval", this.getReconnectInterval());
        } else {
            this.getTomcatBayeux().remove(client);
            this.response.put("successful", Boolean.FALSE);
            this.response.put("error", error.toString());
            ((HashMap)this.response.get("advice")).put("reconnect", "none");
            if (client == null) {
                client = TomcatBayeux.getErrorClient();
            }
        }
        this.response.put("clientId", client.getId());
        try {
            JSONObject obj = new JSONObject(this.response);
            this.addToDeliveryQueue(client, obj);
        }
        catch (ServletException x) {
            throw new BayeuxException(x);
        }
        catch (IOException x) {
            throw new BayeuxException(x);
        }
        return 0;
    }

    static {
        responseTemplate.put("channel", "/meta/disconnect");
        responseTemplate.put("successful", Boolean.TRUE);
        responseTemplate.put("advice", new HashMap());
    }
}

