/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.event.transfer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.event.EventSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventReport
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Log LOG = LogFactory.getLog(EventReport.class);
    private final int maxEventsPerSource;
    private final int maxEventsPerReport;
    private Map<EventSource, Set<Event>> events = new HashMap<EventSource, Set<Event>>();
    private transient Map<EventSource, Integer> eventsDropped;
    private transient int totalEventsInReport = 0;
    private transient boolean addedLimitWarningEvents = false;

    public EventReport(int maxEventsPerSource, int maxEventsPerReport) {
        this.maxEventsPerSource = maxEventsPerSource;
        this.maxEventsPerReport = maxEventsPerReport;
    }

    public void addEvent(@NotNull Event event, @NotNull EventSource eventSource) {
        if (this.totalEventsInReport < this.maxEventsPerReport) {
            Set<Event> eventSet = this.getEventsForEventSource(eventSource);
            if (eventSet.size() < this.maxEventsPerSource) {
                eventSet.add(event);
                ++this.totalEventsInReport;
            } else {
                this.droppedEvent(eventSource);
            }
        } else {
            this.droppedEvent(eventSource);
        }
    }

    private void droppedEvent(EventSource eventSource) {
        Integer droppedCount;
        if (this.eventsDropped == null) {
            this.eventsDropped = new HashMap<EventSource, Integer>();
        }
        droppedCount = (droppedCount = this.eventsDropped.get(eventSource)) == null ? Integer.valueOf(1) : Integer.valueOf(droppedCount + 1);
        this.eventsDropped.put(eventSource, droppedCount);
    }

    private Set<Event> getEventsForEventSource(EventSource eventSource) {
        Set<Event> eventSet = this.events.get(eventSource);
        if (eventSet == null) {
            eventSet = new LinkedHashSet<Event>();
            this.events.put(eventSource, eventSet);
        }
        return eventSet;
    }

    @NotNull
    public Map<EventSource, Set<Event>> getEvents() {
        return this.events;
    }

    public void addLimitWarningEvents() {
        if (this.addedLimitWarningEvents || this.eventsDropped == null) {
            return;
        }
        long now = System.currentTimeMillis();
        for (Map.Entry<EventSource, Integer> entry : this.eventsDropped.entrySet()) {
            EventSource eventSource = entry.getKey();
            Integer droppedCount = entry.getValue();
            Set<Event> eventSet = this.getEventsForEventSource(eventSource);
            String warningMessage = eventSet.size() >= this.maxEventsPerSource ? "Event Report Limit Reached: reached the maximum allowed events [" + this.maxEventsPerSource + "] for this event source - dropped [" + droppedCount + "] events" : "Event Report Limit Reached: reached total maximum allowed events [" + this.maxEventsPerReport + "] - dropped [" + droppedCount + "] events";
            LOG.warn((Object)(warningMessage + ": source=[" + eventSource + "]"));
            Event warningEvent = new Event(eventSource.getEventDefinition().getName(), eventSource.getLocation(), now, EventSeverity.WARN, warningMessage, eventSource);
            eventSet.add(warningEvent);
            this.addedLimitWarningEvents = true;
        }
    }

    public int getMaxEventsPerSource() {
        return this.maxEventsPerSource;
    }

    public int getMaxEventsPerReport() {
        return this.maxEventsPerReport;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.events + "]";
    }
}

