/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.xml.namespace.QName;
import org.gatein.pc.api.spi.PortalContext;
import org.gatein.wsrp.WSRPUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSRPConstants {
    public static final String WEB_APP_REGISTRY_OBJECT_NAME = "portal:service=WebAppRegistry";
    public static final String WSRP_PRODUCER_OBJECT_NAME = "portletcontainer.wsrp:service=WSRPProducer";
    public static final String NORMAL_WINDOW_STATE = "wsrp:normal";
    public static final String MINIMIZED_WINDOW_STATE = "wsrp:minimized";
    public static final String MAXIMIZED_WINDOW_STATE = "wsrp:maximized";
    public static final String SOLO_WINDOW_STATE = "wsrp:solo";
    public static final String VIEW_MODE = "wsrp:view";
    public static final String EDIT_MODE = "wsrp:edit";
    public static final String HELP_MODE = "wsrp:help";
    public static final String PREVIEW_MODE = "wsrp:preview";
    public static final String NONE_USER_AUTHENTICATION = "wsrp:none";
    public static final String PASSWORD_USER_AUTHENTICATION = "wsrp:password";
    public static final String CERTIFICATE_USER_AUTHENTICATION = "wsrp:certificate";
    public static final String DEFAULT_CHARACTER_SET = "UTF-8";
    public static final String DEFAULT_CONSUMER_NAME;
    public static final String CONSUMER_AGENT;
    public static final String CACHE_PER_USER = "wsrp:perUser";
    public static final String CACHE_FOR_ALL = "wsrp:forAll";
    public static final int SESSION_NEVER_EXPIRES = -1;
    public static final QName XSD_STRING;
    private static String defaultLocale;

    private WSRPConstants() {
    }

    public static List<String> getDefaultLocales() {
        ArrayList<String> locales = new ArrayList<String>(2);
        locales.add(defaultLocale);
        locales.add("en");
        return locales;
    }

    public static List<String> getDefaultMimeTypes() {
        return Collections.singletonList("text/html");
    }

    static {
        CONSUMER_AGENT = PortalContext.VERSION.getName() + "." + PortalContext.VERSION.getMajor() + "." + PortalContext.VERSION.getMinor() + "." + PortalContext.VERSION.getQualifier();
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (localhost != null) {
            DEFAULT_CONSUMER_NAME = localhost.getCanonicalHostName();
        } else {
            Random random = new Random(System.currentTimeMillis());
            DEFAULT_CONSUMER_NAME = CONSUMER_AGENT + " Unconfigured " + random.nextInt();
        }
        XSD_STRING = new QName("http://www.w3.org/2001/XMLSchema", "string");
        defaultLocale = WSRPUtils.toString(Locale.getDefault());
    }
}

