/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.StringTokenizer;
import org.jboss.kernel.api.dependency.Matcher;
import org.jboss.kernel.api.dependency.NonNullMatcherTransformer;
import org.jboss.kernel.plugins.dependency.IntervalMatcher;

public class IntervalMatcherTransformer
extends NonNullMatcherTransformer {
    protected Matcher internalTransform(Object value) {
        String interval = value.toString();
        Double floor = null;
        Double ceiling = null;
        StringTokenizer st = new StringTokenizer(interval, ",[]()", true);
        Boolean floorIsGreaterThan = null;
        Boolean ceilingIsLessThan = null;
        boolean mid = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("[")) {
                floorIsGreaterThan = false;
                continue;
            }
            if (token.equals("(")) {
                floorIsGreaterThan = true;
                continue;
            }
            if (token.equals("]")) {
                ceilingIsLessThan = false;
                continue;
            }
            if (token.equals(")")) {
                ceilingIsLessThan = true;
                continue;
            }
            if (token.equals(",")) {
                mid = true;
                continue;
            }
            if (token.equals("\"")) continue;
            if (floor == null) {
                floor = Double.parseDouble(token);
                continue;
            }
            ceiling = Double.parseDouble(token);
        }
        if (floorIsGreaterThan == null || ceilingIsLessThan == null) {
            if (mid) {
                throw new IllegalArgumentException("Missing parenthesis: " + interval);
            }
            floorIsGreaterThan = false;
            ceilingIsLessThan = false;
        }
        return new IntervalMatcher(floor, ceiling, floorIsGreaterThan, ceilingIsLessThan);
    }
}

