/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.organization.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UserListXMLEntity
implements StreamingOutput {
    private final List<User> userList_;
    private final String baseURI_;
    private int prevFrom_ = -1;
    private int nextFrom_ = -1;
    private int range_ = -1;

    public UserListXMLEntity(List<User> userList, String baseURI) {
        this.userList_ = userList;
        this.baseURI_ = baseURI;
    }

    public UserListXMLEntity(List<User> userList, String baseURI, int prevFrom, int nextFrom, int range) {
        this.userList_ = userList;
        this.baseURI_ = baseURI;
        this.prevFrom_ = prevFrom;
        this.nextFrom_ = nextFrom;
        this.range_ = range;
    }

    public void write(OutputStream out) throws IOException {
        try {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
            XMLStreamWriter xsw = outputFactory.createXMLStreamWriter(out);
            xsw.writeStartDocument();
            xsw.writeStartElement("users");
            xsw.writeDefaultNamespace("http://exoplatform.org/organization/rest");
            xsw.writeNamespace("xlink", "http://www.w3.org/1999/xlink");
            for (User u : this.userList_) {
                xsw.writeStartElement("user");
                xsw.writeAttribute("http://www.w3.org/1999/xlink", "href", this.baseURI_ + "/organization/user/" + "?output=xml&command=info");
                xsw.writeStartElement("name");
                xsw.writeCharacters(u.getUserName());
                xsw.writeEndElement();
                xsw.writeStartElement("first-name");
                xsw.writeCharacters(u.getFirstName() != null ? u.getFirstName() : "");
                xsw.writeEndElement();
                xsw.writeStartElement("last-name");
                xsw.writeCharacters(u.getLastName() != null ? u.getLastName() : "");
                xsw.writeEndElement();
                xsw.writeStartElement("email");
                xsw.writeCharacters(u.getEmail() != null ? u.getEmail() : "");
                xsw.writeEndElement();
                xsw.writeEndElement();
            }
            if (this.prevFrom_ >= 0) {
                xsw.writeStartElement("prev-range");
                xsw.writeAttribute("http://www.w3.org/1999/xlink", "href", this.baseURI_ + "/user/" + this.prevFrom_ + "/" + this.range_ + "/?output=xml&command=view-range");
                xsw.writeEndElement();
            }
            if (this.nextFrom_ > 0) {
                xsw.writeStartElement("next-range");
                xsw.writeAttribute("http://www.w3.org/1999/xlink", "href", this.baseURI_ + "/user/" + this.nextFrom_ + "/" + this.range_ + "/?output=xml&command=view-range");
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.flush();
            xsw.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage());
        }
    }
}

