/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.connection;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnectionImpl;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnectionProvider;

public abstract class AbstractProfileServiceConnectionProvider
implements ProfileServiceConnectionProvider {
    private final Log log = LogFactory.getLog(this.getClass());
    private ProfileServiceConnectionImpl existingConnection;
    private boolean connected;

    public final ProfileServiceConnection connect() {
        ProfileServiceConnectionImpl connection = this.doConnect();
        this.connected = true;
        if (this.existingConnection == null) {
            this.existingConnection = connection;
        }
        return this.existingConnection;
    }

    protected abstract ProfileServiceConnectionImpl doConnect();

    public boolean isConnected() {
        return this.connected;
    }

    public final void disconnect() {
        this.connected = false;
        this.doDisconnect();
    }

    protected abstract void doDisconnect();

    public ProfileServiceConnection getExistingConnection() {
        return this.existingConnection;
    }

    protected InitialContext createInitialContext(Properties env) {
        InitialContext initialContext;
        this.log.debug((Object)("Creating JNDI InitialContext with env [" + env + "]..."));
        try {
            initialContext = new InitialContext(env);
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to create JNDI InitialContext.", e);
        }
        this.log.debug((Object)("Created JNDI InitialContext [" + initialContext + "]."));
        return initialContext;
    }

    protected Object lookup(InitialContext initialContext, String name) {
        try {
            return initialContext.lookup(name);
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to lookup JNDI name '" + name + "' from InitialContext.", e);
        }
    }
}

