/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.interceptors.annotation.AnnotationAdvisor;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotationAdvisorWrapper
implements AnnotationAdvisor {
    private static final Logger log = Logger.getLogger(AnnotationAdvisorWrapper.class);
    private Advisor advisor;

    AnnotationAdvisorWrapper(Advisor advisor) {
        assert (advisor != null) : "advisor is null";
        this.advisor = advisor;
    }

    private final void checkClass(Class<?> cls) {
        if (cls != this.advisor.getClazz()) {
            throw new IllegalArgumentException("Can't advise on " + cls + " (only on " + this.advisor.getClazz() + ")");
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<?> cls, Class<T> annotationClass) {
        this.checkClass(cls);
        return (T)((Annotation)this.advisor.resolveAnnotation(annotationClass));
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<?> cls, Field field, Class<T> annotationClass) {
        this.checkClass(cls);
        return (T)((Annotation)this.advisor.resolveAnnotation(field, annotationClass));
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<?> cls, Method method, Class<T> annotationClass) {
        this.checkClass(cls);
        return (T)((Annotation)this.advisor.resolveAnnotation(method, annotationClass));
    }

    @Override
    public boolean isAnnotationPresent(Class<?> cls, Class<? extends Annotation> annotationClass) {
        return this.advisor.hasAnnotation(cls, annotationClass);
    }

    @Override
    public boolean isAnnotationPresent(Class<?> cls, Field field, Class<? extends Annotation> annotationClass) {
        this.checkClass(cls);
        return this.advisor.resolveAnnotation(field, annotationClass) != null;
    }

    @Override
    public boolean isAnnotationPresent(Class<?> cls, Method method, Class<? extends Annotation> annotationClass) {
        this.checkClass(cls);
        return this.advisor.hasAnnotation(method, annotationClass);
    }
}

