/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.event.Observer;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.event.EventObserver;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManager {
    private static Log log = Logging.getLog(EventManager.class);
    private final ManagerImpl manager;

    public EventManager(ManagerImpl manager) {
        this.manager = manager;
    }

    public <T> void addObserver(Observer<T> observer, Type eventType, Annotation ... bindings) {
        EventObserver<T> eventObserver = new EventObserver<T>(observer, eventType, this.manager, bindings);
        this.manager.getRegisteredObservers().put(eventType, eventObserver);
        log.debug((Object)("Added observer " + observer + " observing event type " + eventType), new Object[0]);
    }

    public <T> Set<Observer<T>> getObservers(T event, Annotation ... bindings) {
        HashSet<Observer<T>> interestedObservers = new HashSet<Observer<T>>();
        Set<Type> types = new Reflections.HierarchyDiscovery(event.getClass()).getFlattenedTypes();
        for (Type type : types) {
            for (EventObserver observer : (Set)this.manager.getRegisteredObservers().get(type)) {
                log.debug((Object)("Checking observer " + observer + " to see if it is interested in event [" + event + "]"), new Object[0]);
                if (!observer.isObserverInterested(bindings)) continue;
                Observer o = observer.getObserver();
                interestedObservers.add(o);
                log.debug((Object)("Added observer " + observer + " for event [" + event + "]"), new Object[0]);
            }
        }
        return interestedObservers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void notifyObservers(Set<Observer<T>> observers, T event) {
        DependentContext.instance().setActive(true);
        for (Observer<T> observer : observers) {
            observer.notify(event);
        }
    }

    public <T> void removeObserver(Observer<T> observer, Class<T> eventType, Annotation ... bindings) {
        Collection observers = (Collection)this.manager.getRegisteredObservers().get(eventType);
        EventObserver<T> eventObserver = new EventObserver<T>(observer, eventType, this.manager, bindings);
        observers.remove(eventObserver);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Event manager\n");
        buffer.append(this.manager.getRegisteredObservers().toString());
        return buffer.toString();
    }
}

