/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security.client;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        return TCLAction.UTIL.getContextClassLoader();
    }

    static void setContextClassLoader(ClassLoader loader) {
        TCLAction.UTIL.setContextClassLoader(loader);
    }

    static Principal getCallerPrincipal() {
        if (System.getSecurityManager() == null) {
            return PrincipalInfoAction.NON_PRIVILEGED.getCallerPrincipal();
        }
        return PrincipalInfoAction.PRIVILEGED.getCallerPrincipal();
    }

    static Principal getPrincipal() {
        if (System.getSecurityManager() == null) {
            return PrincipalInfoAction.NON_PRIVILEGED.getPrincipal();
        }
        return PrincipalInfoAction.PRIVILEGED.getPrincipal();
    }

    static void setPrincipal(Principal principal) {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.setPrincipal(principal);
        } else {
            PrincipalInfoAction.PRIVILEGED.setPrincipal(principal);
        }
    }

    static Object getCredential() {
        if (System.getSecurityManager() == null) {
            return PrincipalInfoAction.NON_PRIVILEGED.getCredential();
        }
        return PrincipalInfoAction.PRIVILEGED.getCredential();
    }

    static void setCredential(Object credential) {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.setCredential(credential);
        } else {
            PrincipalInfoAction.PRIVILEGED.setCredential(credential);
        }
    }

    static void pushSubjectContext(Principal principal, Object credential, Subject subject) {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.push(principal, credential, subject);
        } else {
            PrincipalInfoAction.PRIVILEGED.push(principal, credential, subject);
        }
    }

    static void popSubjectContext() {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.pop();
        } else {
            PrincipalInfoAction.PRIVILEGED.pop();
        }
    }

    static RunAsIdentity peekRunAsIdentity() {
        if (System.getSecurityManager() == null) {
            return RunAsIdentityActions.NON_PRIVILEGED.peek();
        }
        return RunAsIdentityActions.PRIVILEGED.peek();
    }

    static void pushRunAsIdentity(RunAsIdentity principal) {
        if (System.getSecurityManager() == null) {
            RunAsIdentityActions.NON_PRIVILEGED.push(principal);
        } else {
            RunAsIdentityActions.PRIVILEGED.push(principal);
        }
    }

    static RunAsIdentity popRunAsIdentity() {
        if (System.getSecurityManager() == null) {
            return RunAsIdentityActions.NON_PRIVILEGED.pop();
        }
        return RunAsIdentityActions.PRIVILEGED.pop();
    }

    static Exception getContextException() {
        if (System.getSecurityManager() == null) {
            return ContextInfoActions.NON_PRIVILEGED.getContextException();
        }
        return ContextInfoActions.PRIVILEGED.getContextException();
    }

    static Subject getContextSubject() throws PolicyContextException {
        if (System.getSecurityManager() == null) {
            return PolicyContextActions.NON_PRIVILEGED.getContextSubject();
        }
        return PolicyContextActions.PRIVILEGED.getContextSubject();
    }

    static void clearSecurityContext() {
        ClearSecurityContextAction action = new ClearSecurityContextAction();
        AccessController.doPrivileged(action);
    }

    static SecurityContext createSecurityContext() throws PrivilegedActionException {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return SecurityContextFactory.createSecurityContext((String)"CLIENT");
            }
        });
    }

    static SecurityContext getSecurityContext() {
        GetSecurityContextAction action = new GetSecurityContextAction();
        return (SecurityContext)AccessController.doPrivileged(action);
    }

    static void setSecurityContext(SecurityContext sc) {
        SetSecurityContextAction action = new SetSecurityContextAction(sc);
        AccessController.doPrivileged(action);
    }

    static void establishSecurityContext(String domain, Principal p, Object cred, Subject subject) throws Exception {
        SecurityContext sc = SecurityContextFactory.createSecurityContext((Principal)p, (Object)cred, (Subject)subject, (String)domain);
        SecurityActions.setSecurityContext(sc);
    }

    private static class ClearSecurityContextAction
    implements PrivilegedAction {
        ClearSecurityContextAction() {
        }

        public Object run() {
            SecurityContextAssociation.clearSecurityContext();
            return null;
        }
    }

    private static class SetSecurityContextAction
    implements PrivilegedAction {
        private SecurityContext securityContext;

        SetSecurityContextAction(SecurityContext sc) {
            this.securityContext = sc;
        }

        public Object run() {
            SecurityContextAssociation.setSecurityContext((SecurityContext)this.securityContext);
            return null;
        }
    }

    private static class GetSecurityContextAction
    implements PrivilegedAction {
        GetSecurityContextAction() {
        }

        public Object run() {
            return SecurityContextAssociation.getSecurityContext();
        }
    }

    static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            public ClassLoader getContextClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }

            public ClassLoader getContextClassLoader(Thread thread) {
                return thread.getContextClassLoader();
            }

            public void setContextClassLoader(ClassLoader cl) {
                Thread.currentThread().setContextClassLoader(cl);
            }

            public void setContextClassLoader(Thread thread, ClassLoader cl) {
                thread.setContextClassLoader(cl);
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){
            private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            };

            public ClassLoader getContextClassLoader() {
                return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
            }

            public ClassLoader getContextClassLoader(final Thread thread) {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return thread.getContextClassLoader();
                    }
                });
            }

            public void setContextClassLoader(final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(cl);
                        return null;
                    }
                });
            }

            public void setContextClassLoader(final Thread thread, final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        thread.setContextClassLoader(cl);
                        return null;
                    }
                });
            }
        };

        public ClassLoader getContextClassLoader();

        public ClassLoader getContextClassLoader(Thread var1);

        public void setContextClassLoader(ClassLoader var1);

        public void setContextClassLoader(Thread var1, ClassLoader var2);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            static ClassLoader getContextClassLoader() {
                return UTIL.getTCLAction().getContextClassLoader();
            }

            static ClassLoader getContextClassLoader(Thread thread) {
                return UTIL.getTCLAction().getContextClassLoader(thread);
            }

            static void setContextClassLoader(ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(cl);
            }

            static void setContextClassLoader(Thread thread, ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(thread, cl);
            }
        }
    }

    static interface PolicyContextActions {
        public static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
        public static final PolicyContextActions PRIVILEGED = new PolicyContextActions(){
            private final PrivilegedExceptionAction exAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return (Subject)PolicyContext.getContext((String)PolicyContextActions.SUBJECT_CONTEXT_KEY);
                }
            };

            public Subject getContextSubject() throws PolicyContextException {
                try {
                    return (Subject)AccessController.doPrivileged(this.exAction);
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof PolicyContextException) {
                        throw (PolicyContextException)ex;
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
        };
        public static final PolicyContextActions NON_PRIVILEGED = new PolicyContextActions(){

            public Subject getContextSubject() throws PolicyContextException {
                return (Subject)PolicyContext.getContext((String)PolicyContextActions.SUBJECT_CONTEXT_KEY);
            }
        };

        public Subject getContextSubject() throws PolicyContextException;
    }

    static interface ContextInfoActions {
        public static final String EX_KEY = "org.jboss.security.exception";
        public static final ContextInfoActions PRIVILEGED = new ContextInfoActions(){
            private final PrivilegedAction exAction = new PrivilegedAction(){

                public Object run() {
                    return SecurityAssociation.getContextInfo((String)ContextInfoActions.EX_KEY);
                }
            };

            public Exception getContextException() {
                return (Exception)AccessController.doPrivileged(this.exAction);
            }
        };
        public static final ContextInfoActions NON_PRIVILEGED = new ContextInfoActions(){

            public Exception getContextException() {
                return (Exception)SecurityAssociation.getContextInfo((String)ContextInfoActions.EX_KEY);
            }
        };

        public Exception getContextException();
    }

    static interface RunAsIdentityActions {
        public static final RunAsIdentityActions PRIVILEGED = new RunAsIdentityActions(){
            private final PrivilegedAction peekAction = new PrivilegedAction(){

                public Object run() {
                    return SecurityAssociation.peekRunAsIdentity();
                }
            };
            private final PrivilegedAction popAction = new PrivilegedAction(){

                public Object run() {
                    return SecurityAssociation.popRunAsIdentity();
                }
            };

            public RunAsIdentity peek() {
                return (RunAsIdentity)AccessController.doPrivileged(this.peekAction);
            }

            public void push(final RunAsIdentity id) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityAssociation.pushRunAsIdentity((RunAsIdentity)id);
                        return null;
                    }
                });
            }

            public RunAsIdentity pop() {
                return (RunAsIdentity)AccessController.doPrivileged(this.popAction);
            }
        };
        public static final RunAsIdentityActions NON_PRIVILEGED = new RunAsIdentityActions(){

            public RunAsIdentity peek() {
                return SecurityAssociation.peekRunAsIdentity();
            }

            public void push(RunAsIdentity id) {
                SecurityAssociation.pushRunAsIdentity((RunAsIdentity)id);
            }

            public RunAsIdentity pop() {
                return SecurityAssociation.popRunAsIdentity();
            }
        };

        public RunAsIdentity peek();

        public void push(RunAsIdentity var1);

        public RunAsIdentity pop();
    }

    static interface PrincipalInfoAction {
        public static final PrincipalInfoAction PRIVILEGED = new PrincipalInfoAction(){

            public void push(final Principal principal, final Object credential, final Subject subject) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityAssociation.pushSubjectContext((Subject)subject, (Principal)principal, (Object)credential);
                        return null;
                    }
                });
            }

            public void pop() {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityAssociation.popSubjectContext();
                        return null;
                    }
                });
            }

            public Principal getPrincipal() {
                return (Principal)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return SecurityAssociation.getPrincipal();
                    }
                });
            }

            public void setPrincipal(final Principal principal) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityAssociation.setPrincipal((Principal)principal);
                        return null;
                    }
                });
            }

            public Principal getCallerPrincipal() {
                return (Principal)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return SecurityAssociation.getCallerPrincipal();
                    }
                });
            }

            public Object getCredential() {
                return AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return SecurityAssociation.getCredential();
                    }
                });
            }

            public void setCredential(final Object credential) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityAssociation.setCredential((Object)credential);
                        return null;
                    }
                });
            }
        };
        public static final PrincipalInfoAction NON_PRIVILEGED = new PrincipalInfoAction(){

            public void push(Principal principal, Object credential, Subject subject) {
                SecurityAssociation.pushSubjectContext((Subject)subject, (Principal)principal, (Object)credential);
            }

            public void pop() {
                SecurityAssociation.popSubjectContext();
            }

            public Principal getPrincipal() {
                return SecurityAssociation.getPrincipal();
            }

            public void setPrincipal(Principal principal) {
                SecurityAssociation.setPrincipal((Principal)principal);
            }

            public Principal getCallerPrincipal() {
                return SecurityAssociation.getPrincipal();
            }

            public Object getCredential() {
                return SecurityAssociation.getCredential();
            }

            public void setCredential(Object credential) {
                SecurityAssociation.setCredential((Object)credential);
            }
        };

        public void push(Principal var1, Object var2, Subject var3);

        public void pop();

        public Principal getPrincipal();

        public void setPrincipal(Principal var1);

        public Principal getCallerPrincipal();

        public Object getCredential();

        public void setCredential(Object var1);
    }
}

