/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.deployers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ControllerStateModel;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.IncompleteDeploymentException;
import org.jboss.deployers.client.spi.IncompleteDeployments;
import org.jboss.deployers.client.spi.MissingDependency;
import org.jboss.deployers.plugins.deployers.DeployerStatistics;
import org.jboss.deployers.plugins.deployers.DeployerWrapper;
import org.jboss.deployers.plugins.deployers.DeployersImplMBean;
import org.jboss.deployers.plugins.deployers.DeploymentControllerContext;
import org.jboss.deployers.plugins.sort.DeployerSorter;
import org.jboss.deployers.plugins.sort.DeployerSorterFactory;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.DeploymentState;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.deployer.Deployers;
import org.jboss.deployers.spi.deployer.DeploymentStage;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentMBean;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.scope.ScopeBuilder;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployersImpl
implements Deployers,
ControllerContextActions,
DeployersImplMBean,
MBeanRegistration {
    private static final Logger log = Logger.getLogger(DeployersImpl.class);
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private boolean collectStats = false;
    private DeployerStatistics deploymentTimes;
    private Controller controller;
    private MBeanServer server;
    private boolean registerMBeans = true;
    private MutableMetaDataRepository repository;
    private Map<String, DeploymentStage> stages = new ConcurrentHashMap<String, DeploymentStage>();
    private Set<DeployerWrapper> deployers = new HashSet<DeployerWrapper>();
    private Map<String, List<Deployer>> deployersByStage = new HashMap<String, List<Deployer>>();
    private ScopeBuilder scopeBuilder;
    private ManagedObjectCreator mgtObjectCreator = null;

    public DeployersImpl(Controller controller) {
        this(controller, null);
    }

    public DeployersImpl(Controller controller, Set<Deployer> deployers) {
        if (controller == null) {
            throw new IllegalArgumentException("Null controller");
        }
        this.controller = controller;
        this.addDeploymentStage(DeploymentStages.NOT_INSTALLED);
        this.addDeploymentStage(DeploymentStages.PARSE);
        this.addDeploymentStage(DeploymentStages.POST_PARSE);
        this.addDeploymentStage(DeploymentStages.PRE_DESCRIBE);
        this.addDeploymentStage(DeploymentStages.DESCRIBE);
        this.addDeploymentStage(DeploymentStages.CLASSLOADER);
        this.addDeploymentStage(DeploymentStages.POST_CLASSLOADER);
        this.addDeploymentStage(DeploymentStages.PRE_REAL);
        this.addDeploymentStage(DeploymentStages.REAL);
        this.addDeploymentStage(DeploymentStages.INSTALLED);
        if (deployers != null) {
            this.setDeployers(deployers);
        }
    }

    public void shutdown() {
        this.shutdown.set(true);
    }

    protected void checkShutdown() {
        if (this.shutdown.get()) {
            throw new IllegalStateException("Deployers are shutdown");
        }
    }

    public boolean isCollectStats() {
        return this.collectStats;
    }

    public void setCollectStats(boolean collectStats) {
        this.collectStats = collectStats;
    }

    public Set<DeployerWrapper> getDeployerWrappers() {
        return this.deployers;
    }

    public void setDeployers(Set<Deployer> deployers) {
        if (deployers == null) {
            throw new IllegalArgumentException("Null deployers");
        }
        HashSet<DeployerWrapper> oldDeployers = new HashSet<DeployerWrapper>(this.deployers);
        oldDeployers.removeAll(deployers);
        for (Deployer deployer : oldDeployers) {
            this.removeDeployer(deployer);
        }
        HashSet<Deployer> newDeployers = new HashSet<Deployer>(deployers);
        newDeployers.removeAll(this.deployers);
        for (Deployer deployer : newDeployers) {
            this.addDeployer(deployer);
        }
    }

    public synchronized void addDeployer(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        DeploymentStage stage = deployer.getStage();
        if (stage == null) {
            throw new IllegalArgumentException("Deployer has no stage: " + deployer);
        }
        this.addDeploymentStage(stage);
        DeployerWrapper wrapper = new DeployerWrapper(deployer);
        if (this.deployers.contains(wrapper)) {
            return;
        }
        String stageName = stage.getName();
        List<Object> deployers = this.deployersByStage.get(stageName);
        if (deployers == null) {
            deployers = Collections.emptyList();
        }
        deployers = this.insert(deployers, wrapper);
        this.deployersByStage.put(stageName, deployers);
        this.deployers.add(wrapper);
        StringBuilder builder = new StringBuilder();
        builder.append("Added deployer ").append(deployer).append(" for stage ").append(stageName).append('\n');
        for (Deployer temp : this.getDeployersList(stageName)) {
            builder.append(temp);
            builder.append("{inputs=").append(temp.getInputs());
            builder.append(" outputs=").append(temp.getOutputs());
            builder.append("}\n");
        }
        log.debug((Object)builder);
    }

    public synchronized void removeDeployer(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        this.deployers.remove(new DeployerWrapper(deployer));
        DeploymentStage stage = deployer.getStage();
        if (stage == null) {
            log.warn((Object)("Deployer has no stage: " + deployer));
            return;
        }
        String stageName = stage.getName();
        List<Deployer> deployers = this.deployersByStage.get(stageName);
        if (deployers == null) {
            return;
        }
        deployers.remove(deployer);
        if (deployers.isEmpty()) {
            this.deployersByStage.remove(stageName);
        }
        log.debug((Object)("Removed deployer " + deployer + " from stage " + stageName));
    }

    protected synchronized void addDeploymentStage(DeploymentStage stage) {
        if (stage == null) {
            throw new IllegalArgumentException("Null stage");
        }
        String stageName = stage.getName();
        if (this.stages.containsKey(stageName)) {
            return;
        }
        ControllerState preceeds = null;
        String before = stage.getBefore();
        String after = stage.getAfter();
        if (before != null || after != null) {
            ControllerStateModel states = this.controller.getStates();
            for (ControllerState state : states) {
                String stateName = state.getStateString();
                if (before != null && before.equals(stateName)) {
                    preceeds = state;
                    break;
                }
                if (after == null || !after.equals(stateName) || states.getNextState(state) == null) continue;
                preceeds = states.getNextState(state);
                break;
            }
        }
        this.controller.addState(new ControllerState(stageName), preceeds);
        this.stages.put(stageName, stage);
        log.debug((Object)("Added stage " + stageName + " before " + preceeds));
    }

    public ScopeBuilder getScopeBuilder() {
        return this.scopeBuilder;
    }

    public void setScopeBuilder(ScopeBuilder scopeBuilder) {
        this.scopeBuilder = scopeBuilder;
    }

    public ManagedObjectCreator getMgtObjectCreator() {
        return this.mgtObjectCreator;
    }

    public void setMgtObjectCreator(ManagedObjectCreator mgtObjectCreator) {
        this.mgtObjectCreator = mgtObjectCreator;
        log.debug((Object)("setMgtObjectCreator, " + mgtObjectCreator));
    }

    public MutableMetaDataRepository getRepository() {
        return this.repository;
    }

    public void setRepository(MutableMetaDataRepository repository) {
        this.repository = repository;
    }

    public boolean isRegisterMBeans() {
        return this.registerMBeans;
    }

    public void setRegisterMBeans(boolean registerMBeans) {
        this.registerMBeans = registerMBeans;
    }

    public void start() {
        if (this.repository == null && this.controller instanceof KernelController) {
            KernelController kernelController = (KernelController)this.controller;
            this.repository = kernelController.getKernel().getMetaDataRepository().getMetaDataRepository();
        }
    }

    public Map<String, ManagedObject> getManagedObjects(DeploymentContext context) throws DeploymentException {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        this.checkShutdown();
        HashMap<String, ManagedObject> managedObjects = new HashMap<String, ManagedObject>();
        DeploymentUnit unit = context.getDeploymentUnit();
        HashSet<DeployerWrapper> mocs = new HashSet<DeployerWrapper>();
        HashSet<String> outputs = new HashSet<String>();
        for (DeployerWrapper deployerWrapper : this.deployers) {
            outputs.addAll(deployerWrapper.getOutputs());
            if (deployerWrapper.getManagedObjectCreator() == null) continue;
            mocs.add(deployerWrapper);
        }
        this.mgtObjectCreator.build(unit, outputs, managedObjects);
        for (ManagedObjectCreator managedObjectCreator : mocs) {
            managedObjectCreator.build(unit, outputs, managedObjects);
        }
        return managedObjects;
    }

    public ManagedObjectCreator getDeployerManagedObjectBuilder(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        ManagedObjectCreator result = null;
        for (DeployerWrapper wrapper : this.deployers) {
            if (!wrapper.equals(deployer)) continue;
            result = wrapper.getManagedObjectCreator();
        }
        return result;
    }

    public void setDeployerManagedObjectBuilder(Deployer deployer, ManagedObjectCreator managedObjectCreator) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        for (DeployerWrapper wrapper : this.deployers) {
            if (!wrapper.equals(deployer)) continue;
            wrapper.setManagedObjectCreator(managedObjectCreator);
        }
    }

    @Override
    public String listDeployerTimes(boolean details) {
        if (this.deploymentTimes == null) {
            return "No statistics available";
        }
        return this.deploymentTimes.listTimes(details);
    }

    @Override
    public String listDeployers(String stageName) {
        StringBuilder result = new StringBuilder();
        result.append("<table><tr><th>Stage/Deployer</th><th>top</th><th>component</th><th>parent last</th><th>input<th>output</th></tr>");
        if (stageName == null || stageName.trim().length() == 0) {
            for (String stage : this.stages.keySet()) {
                this.internalListDeployers(stage, null, result);
            }
        } else {
            this.internalListDeployers(stageName, null, result);
        }
        result.append("</table>");
        return result.toString();
    }

    @Override
    public String listDeployersByAttachment(String attachment) {
        if (attachment == null || attachment.trim().length() == 0) {
            return "No attachment specified";
        }
        StringBuilder result = new StringBuilder();
        result.append("<table><tr><th>Stage/Deployer</th><th>top</th><th>component</th><th>parent last</th><th>input<th>output</th></tr>");
        for (String stage : this.stages.keySet()) {
            this.internalListDeployers(stage, attachment, result);
        }
        result.append("</table>");
        return result.toString();
    }

    protected void internalListDeployers(String stageName, String attachment, StringBuilder builder) {
        List<Deployer> deployers = this.getDeployersList(stageName);
        if (deployers.isEmpty()) {
            return;
        }
        builder.append("<tr>").append("<td>").append(stageName).append("</td>").append("</tr>");
        for (Deployer deployer : deployers) {
            int row = 0;
            Set deployerInputs = deployer.getInputs();
            ArrayList<String> inputs = new ArrayList<String>();
            for (String input : deployerInputs) {
                if (attachment != null && !attachment.equals(input)) continue;
                inputs.add(input);
            }
            Set deployerOutputs = deployer.getOutputs();
            ArrayList<String> outputs = new ArrayList<String>();
            for (String output : deployerOutputs) {
                if (attachment != null && !attachment.equals(output)) continue;
                outputs.add(output);
            }
            if (attachment != null && inputs.isEmpty() && outputs.isEmpty()) continue;
            while (row < 1 || row < outputs.size() || row < outputs.size()) {
                builder.append("<tr>");
                if (row == 0) {
                    builder.append("<td>`--").append(deployer).append("</td>");
                    builder.append(deployer.isTopLevelOnly() ? "<td>X</td>" : "<td/>");
                    builder.append(deployer.isWantComponents() ? "<td>X</td>" : "<td/>");
                    builder.append(!deployer.isParentFirst() ? "<td>X</td>" : "<td/>");
                } else {
                    builder.append("<td/><td/><td/><td/>");
                }
                if (row < inputs.size()) {
                    builder.append("<td>").append((String)inputs.get(row)).append("</td>");
                } else {
                    builder.append("<td/>");
                }
                if (row < outputs.size()) {
                    builder.append("<td>").append((String)outputs.get(row)).append("</td>");
                } else {
                    builder.append("<td/>");
                }
                builder.append("</tr>");
                ++row;
            }
        }
    }

    public DeploymentStage getDeploymentStage(DeploymentContext context) throws DeploymentException {
        DeploymentControllerContext deploymentControllerContext = (DeploymentControllerContext)((Object)context.getTransientAttachments().getAttachment(ControllerContext.class.getName(), DeploymentControllerContext.class));
        if (deploymentControllerContext == null) {
            return null;
        }
        ControllerState state = deploymentControllerContext.getState();
        if (ControllerState.ERROR.equals((Object)state)) {
            return DeploymentStages.NOT_INSTALLED;
        }
        return new DeploymentStage(state.getStateString());
    }

    public void change(DeploymentContext context, DeploymentStage stage) throws DeploymentException {
        if (context == null) {
            throw new DeploymentException("Null context");
        }
        if (stage == null) {
            throw new DeploymentException("Null stage");
        }
        String stageName = stage.getName();
        if (!this.stages.containsKey(stage.getName())) {
            throw new DeploymentException("Unknown deployment stage: " + stage);
        }
        DeploymentControllerContext deploymentControllerContext = (DeploymentControllerContext)((Object)context.getTransientAttachments().getAttachment(ControllerContext.class.getName(), DeploymentControllerContext.class));
        if (deploymentControllerContext == null) {
            throw new DeploymentException("Deployment " + context.getName() + " has no deployment controller context");
        }
        this.checkShutdown();
        ControllerState state = new ControllerState(stageName);
        try {
            this.controller.change((ControllerContext)deploymentControllerContext, state);
        }
        catch (Throwable t) {
            context.setState(DeploymentState.ERROR);
            context.setProblem(t);
        }
        Throwable problem = context.getProblem();
        if (problem != null) {
            throw DeploymentException.rethrowAsDeploymentException((String)("Error changing to stage " + stage + " for " + context.getName()), (Throwable)problem);
        }
    }

    public void process(List<DeploymentContext> deploy, List<DeploymentContext> undeploy) {
        ControllerState current;
        boolean trace = log.isTraceEnabled();
        if (undeploy != null && !undeploy.isEmpty()) {
            ArrayList<DeploymentControllerContext> toUndeploy = new ArrayList<DeploymentControllerContext>();
            for (int i = undeploy.size() - 1; i >= 0; --i) {
                DeploymentContext context = undeploy.get(i);
                if (!DeploymentState.ERROR.equals((Object)context.getState())) {
                    context.setState(DeploymentState.UNDEPLOYING);
                }
                log.debug((Object)("Undeploying " + context.getName()));
                DeploymentControllerContext deploymentControllerContext = (DeploymentControllerContext)((Object)context.getTransientAttachments().getAttachment(ControllerContext.class.getName(), DeploymentControllerContext.class));
                if (deploymentControllerContext == null) {
                    log.debug((Object)("DeploymentContext has no DeploymentControllerContext during undeploy request, ignoring: " + context));
                    continue;
                }
                toUndeploy.add(deploymentControllerContext);
            }
            ControllerStateModel states = this.controller.getStates();
            ListIterator iter = states.listIteraror();
            while (iter.hasPrevious()) {
                ControllerState state = (ControllerState)iter.previous();
                for (DeploymentControllerContext deploymentControllerContext : toUndeploy) {
                    current = deploymentControllerContext.getState();
                    if (!ControllerState.ERROR.equals((Object)current) && states.isAfterState(current, state)) {
                        DeploymentContext context = deploymentControllerContext.getDeploymentContext();
                        try {
                            this.controller.change((ControllerContext)deploymentControllerContext, state);
                        }
                        catch (Throwable t) {
                            log.warn((Object)"Error during undeploy", t);
                            context.setState(DeploymentState.ERROR);
                            context.setProblem(t);
                        }
                        continue;
                    }
                    if (!trace) continue;
                    log.trace((Object)("Not moving " + (Object)((Object)deploymentControllerContext) + " to state " + state + " it is at " + current));
                }
            }
            for (DeploymentControllerContext deploymentControllerContext : toUndeploy) {
                DeploymentContext context = deploymentControllerContext.getDeploymentContext();
                context.getTransientAttachments().removeAttachment(ControllerContext.class);
                try {
                    this.controller.uninstall(deploymentControllerContext.getName());
                    DeployersImpl.setState(context, DeploymentState.UNDEPLOYED, null);
                    this.unregisterMBean(context);
                    DeployersImpl.removeClassLoader(context);
                    DeployersImpl.cleanup(context);
                    log.debug((Object)("Fully Undeployed " + context.getName()));
                }
                catch (Throwable t) {
                    log.warn((Object)"Error during uninstall", t);
                    context.setState(DeploymentState.ERROR);
                    context.setProblem(t);
                }
            }
        }
        if (deploy != null && !deploy.isEmpty()) {
            for (DeploymentContext context : deploy) {
                this.checkShutdown();
                DeploymentControllerContext deploymentControllerContext = new DeploymentControllerContext(context, this);
                context.getTransientAttachments().addAttachment(ControllerContext.class, (Object)deploymentControllerContext);
                try {
                    this.controller.install((ControllerContext)deploymentControllerContext);
                    context.setState(DeploymentState.DEPLOYING);
                    log.debug((Object)("Deploying " + context.getName()));
                    if (this.scopeBuilder != null) {
                        context.getTransientAttachments().addAttachment(ScopeBuilder.class, (Object)this.scopeBuilder);
                    }
                    if (this.repository != null) {
                        context.getTransientAttachments().addAttachment(MutableMetaDataRepository.class, (Object)this.repository);
                    }
                    this.registerMBean(context);
                }
                catch (Throwable t) {
                    context.setState(DeploymentState.ERROR);
                    context.setProblem(t);
                    DeployersImpl.setState(context, DeploymentState.UNDEPLOYED, DeploymentState.DEPLOYING);
                    this.unregisterMBean(context);
                }
            }
            ControllerStateModel states = this.controller.getStates();
            for (ControllerState state : states) {
                for (DeploymentContext context : deploy) {
                    DeploymentControllerContext deploymentControllerContext;
                    deploymentControllerContext = (DeploymentControllerContext)((Object)context.getTransientAttachments().getAttachment(ControllerContext.class.getName(), DeploymentControllerContext.class));
                    current = deploymentControllerContext.getState();
                    if (!ControllerState.ERROR.equals((Object)current) && states.isBeforeState(current, state)) {
                        this.checkShutdown();
                        try {
                            this.controller.change((ControllerContext)deploymentControllerContext, state);
                        }
                        catch (Throwable t) {
                            context.setState(DeploymentState.ERROR);
                            context.setProblem(t);
                        }
                        continue;
                    }
                    if (!trace) continue;
                    log.trace((Object)("Not moving " + (Object)((Object)deploymentControllerContext) + " to state " + state + " it is at " + current));
                }
            }
        }
    }

    private static Throwable getRootCause(Throwable original) {
        if (original == null) {
            return null;
        }
        Throwable result = original;
        for (Throwable cause = result.getCause(); cause != null; cause = cause.getCause()) {
            result = cause;
        }
        return result;
    }

    public void checkComplete(Collection<DeploymentContext> errors, Collection<Deployment> missingDeployer) throws DeploymentException {
        IncompleteDeployments incompleteDeployments;
        Set notInstalled;
        HashMap<String, Throwable> deploymentsInError = null;
        HashSet<String> deploymentsMissingDeployer = null;
        HashMap<String, Throwable> contextsInError = null;
        HashMap<String, Set<MissingDependency>> contextsMissingDependencies = null;
        if (errors != null && !errors.isEmpty()) {
            deploymentsInError = new HashMap<String, Throwable>();
            for (DeploymentContext deploymentContext : errors) {
                deploymentsInError.put(deploymentContext.getName(), DeployersImpl.getRootCause(deploymentContext.getProblem()));
            }
        }
        if (missingDeployer != null && !missingDeployer.isEmpty()) {
            deploymentsMissingDeployer = new HashSet<String>();
            for (Deployment deployment : missingDeployer) {
                deploymentsMissingDeployer.add(deployment.getName());
            }
        }
        if (!(notInstalled = this.controller.getNotInstalled()).isEmpty()) {
            Iterator iterator = notInstalled.iterator();
            while (iterator.hasNext()) {
                ControllerContext context = (ControllerContext)iterator.next();
                if (!context.getState().equals((Object)context.getRequiredState())) continue;
                iterator.remove();
            }
            if (!notInstalled.isEmpty()) {
                ControllerStateModel controllerStateModel = this.controller.getStates();
                contextsInError = new HashMap<String, Throwable>();
                contextsMissingDependencies = new HashMap<String, Set<MissingDependency>>();
                for (ControllerContext context : notInstalled) {
                    this.checkControllerContext(context, contextsInError, contextsMissingDependencies, controllerStateModel);
                }
            }
        }
        if ((incompleteDeployments = new IncompleteDeployments(deploymentsInError, deploymentsMissingDeployer, contextsInError, contextsMissingDependencies)).isIncomplete()) {
            throw new IncompleteDeploymentException(incompleteDeployments);
        }
    }

    protected final void checkControllerContext(ControllerContext context, Map<String, Throwable> contextsInError, Map<String, Set<MissingDependency>> contextsMissingDependencies, ControllerStateModel states) {
        if (context.getState().equals((Object)ControllerState.ERROR)) {
            contextsInError.put(context.getName().toString(), DeployersImpl.getRootCause(context.getError()));
        } else {
            Object contextName = context.getName();
            String name = contextName.toString();
            HashSet<MissingDependency> dependencies = new HashSet<MissingDependency>();
            DependencyInfo dependsInfo = context.getDependencyInfo();
            ControllerState currentState = context.getState();
            ControllerState nextState = states.getNextState(currentState);
            for (DependencyItem item : dependsInfo.getUnresolvedDependencies(nextState)) {
                String actualStateString;
                String dependency;
                if (item.isResolved()) continue;
                ControllerState actualState = null;
                Object iDependOn = item.getIDependOn();
                if (contextName.equals(iDependOn) || item.resolve(this.controller)) continue;
                iDependOn = item.getIDependOn();
                if (iDependOn == null) {
                    dependency = "<UNKNOWN " + item.getName() + ">";
                    actualStateString = "** UNRESOLVED " + item.toHumanReadableString() + " **";
                } else {
                    dependency = iDependOn.toString();
                    ControllerContext other = this.controller.getContext(iDependOn, null);
                    if (other == null) {
                        actualStateString = "** NOT FOUND " + item.toHumanReadableString() + " **";
                    } else {
                        actualState = other.getState();
                        actualStateString = actualState.getStateString();
                    }
                }
                ControllerState requiredState = item.getWhenRequired();
                String requiredStateString = requiredState.getStateString();
                if (actualState != null && !states.isAfterState(requiredState, actualState)) continue;
                MissingDependency missing = new MissingDependency(name, dependency, requiredStateString, actualStateString);
                dependencies.add(missing);
            }
            contextsMissingDependencies.put(name, dependencies);
        }
    }

    public void checkComplete(DeploymentContext ... contexts) throws DeploymentException {
        this.checkComplete(true, contexts);
    }

    public void checkStructureComplete(DeploymentContext ... contexts) throws DeploymentException {
        this.checkComplete(false, contexts);
    }

    protected void checkComplete(boolean checkContexts, DeploymentContext ... contexts) throws DeploymentException {
        IncompleteDeployments incomplete;
        if (contexts == null) {
            throw new IllegalArgumentException("Null contexts");
        }
        HashMap<String, Throwable> deploymentsInError = new HashMap<String, Throwable>();
        HashSet<String> deploymentsMissingDeployer = new HashSet<String>();
        HashMap<String, Throwable> contextsInError = new HashMap<String, Throwable>();
        HashMap<String, Set<MissingDependency>> contextsMissingDependencies = new HashMap<String, Set<MissingDependency>>();
        for (DeploymentContext context : contexts) {
            Throwable problem = context.getProblem();
            if (problem != null) {
                deploymentsInError.put(context.getName(), problem);
            }
            if (!this.isDeployed(context)) {
                deploymentsMissingDeployer.add(context.getName());
            }
            if (!checkContexts) continue;
            Set notInstalled = this.controller.getNotInstalled();
            ControllerStateModel states = this.controller.getStates();
            this.checkComplete(context, contextsInError, contextsMissingDependencies, notInstalled, states);
        }
        if (deploymentsInError.isEmpty()) {
            deploymentsInError = null;
        }
        if (deploymentsMissingDeployer.isEmpty()) {
            deploymentsMissingDeployer = null;
        }
        if (contextsInError.isEmpty()) {
            contextsInError = null;
        }
        if (contextsMissingDependencies.isEmpty()) {
            contextsMissingDependencies = null;
        }
        if ((incomplete = new IncompleteDeployments(deploymentsInError, deploymentsMissingDeployer, contextsInError, contextsMissingDependencies)).isIncomplete()) {
            throw new IncompleteDeploymentException(incomplete);
        }
    }

    protected boolean isDeployed(DeploymentContext context) {
        return context.isDeployed() || DeploymentState.DEPLOYED.equals((Object)context.getState());
    }

    protected final void checkComplete(DeploymentContext context, Map<String, Throwable> contextsInError, Map<String, Set<MissingDependency>> contextsMissingDependencies, Set<ControllerContext> notInstalled, ControllerStateModel states) {
        List components;
        List children;
        DeploymentControllerContext dcc = (DeploymentControllerContext)((Object)context.getTransientAttachments().getAttachment(ControllerContext.class.getName(), DeploymentControllerContext.class));
        this.checkControllerContext((ControllerContext)dcc, contextsInError, contextsMissingDependencies, notInstalled, states);
        Set names = context.getControllerContextNames();
        if (names != null && !names.isEmpty()) {
            for (Object name : names) {
                ControllerContext cc = this.controller.getContext(name, null);
                this.checkControllerContext(cc, contextsInError, contextsMissingDependencies, notInstalled, states);
            }
        }
        if ((children = context.getChildren()) != null && !children.isEmpty()) {
            for (DeploymentContext child : children) {
                this.checkComplete(child, contextsInError, contextsMissingDependencies, notInstalled, states);
            }
        }
        if ((components = context.getComponents()) != null && !components.isEmpty()) {
            for (DeploymentContext component : components) {
                this.checkComplete(component, contextsInError, contextsMissingDependencies, notInstalled, states);
            }
        }
    }

    protected void checkControllerContext(ControllerContext context, Map<String, Throwable> contextsInError, Map<String, Set<MissingDependency>> contextsMissingDependencies, Set<ControllerContext> notInstalled, ControllerStateModel states) {
        if (context != null && !context.getState().equals((Object)context.getRequiredState()) && notInstalled.contains(context)) {
            this.checkControllerContext(context, contextsInError, contextsMissingDependencies, states);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(ControllerContext context, ControllerState fromState, ControllerState toState) throws Throwable {
        block11: {
            DeploymentControllerContext deploymentControllerContext = (DeploymentControllerContext)context;
            String stageName = toState.getStateString();
            DeploymentContext deploymentContext = deploymentControllerContext.getDeploymentContext();
            try {
                List<Deployer> theDeployers = this.getDeployersList(stageName);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Deployers for " + stageName + " " + theDeployers));
                }
                if (theDeployers.isEmpty()) break block11;
                try {
                    for (int i = 0; i < theDeployers.size(); ++i) {
                        Deployer deployer = theDeployers.get(i);
                        if (deployer.isParentFirst()) {
                            this.doInstallParentFirst(deployer, deploymentContext);
                            continue;
                        }
                        this.doInstallParentLast(deployer, deploymentContext);
                    }
                }
                catch (Throwable t) {
                    deploymentContext.setState(DeploymentState.ERROR);
                    deploymentContext.setProblem(t);
                    for (int j = i - 1; j >= 0; --j) {
                        Deployer deployer = theDeployers.get(j);
                        if (deployer.isParentFirst()) {
                            this.doUninstallParentLast(deployer, deploymentContext, true, true);
                            continue;
                        }
                        this.doUninstallParentFirst(deployer, deploymentContext, true, true);
                    }
                    DeployersImpl.setState(deploymentContext, DeploymentState.UNDEPLOYED, DeploymentState.DEPLOYING);
                    throw t;
                }
            }
            finally {
                if (ControllerState.INSTALLED.equals((Object)toState) && DeploymentState.DEPLOYING.equals((Object)deploymentContext.getState())) {
                    log.debug((Object)("Fully Deployed " + context.getName()));
                    DeployersImpl.setState(deploymentContext, DeploymentState.DEPLOYED, null);
                }
            }
        }
    }

    protected void doInstallParentFirst(Deployer deployer, DeploymentContext context) throws Throwable {
        List children;
        DeploymentUnit unit;
        List currentComponents = context.getComponents();
        ArrayList components = null;
        if (currentComponents != null && !currentComponents.isEmpty()) {
            components = new ArrayList(currentComponents);
        }
        if (this.isRelevant(deployer, unit = context.getDeploymentUnit(), context.isTopLevel(), context.isComponent())) {
            try {
                this.doDeploy(deployer, unit);
            }
            catch (DeploymentException e) {
                context.setState(DeploymentState.ERROR);
                context.setProblem((Throwable)e);
                throw e;
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Deployer " + deployer + " not relevant for " + context.getName()));
        }
        if (components != null) {
            try {
                for (int i = 0; i < components.size(); ++i) {
                    DeploymentContext component = (DeploymentContext)components.get(i);
                    try {
                        this.doInstallParentFirst(deployer, component);
                        continue;
                    }
                    catch (DeploymentException e) {
                        for (int j = i - 1; j >= 0; --j) {
                            component = (DeploymentContext)components.get(j);
                            this.doUninstallParentLast(deployer, component, false, true);
                        }
                        throw e;
                    }
                }
            }
            catch (DeploymentException e) {
                this.doUninstallParentLast(deployer, context, false, false);
                throw e;
            }
        }
        if ((children = context.getChildren()) != null) {
            try {
                for (int i = 0; i < children.size(); ++i) {
                    DeploymentContext child = (DeploymentContext)children.get(i);
                    try {
                        this.doInstallParentFirst(deployer, child);
                        continue;
                    }
                    catch (DeploymentException e) {
                        for (int j = i - 1; j >= 0; --j) {
                            child = (DeploymentContext)children.get(j);
                            this.doUninstallParentLast(deployer, child, true, true);
                        }
                        throw e;
                    }
                }
            }
            catch (DeploymentException e) {
                this.doUninstallParentLast(deployer, context, false, true);
                throw e;
            }
        }
    }

    protected void doInstallParentLast(Deployer deployer, DeploymentContext context) throws Throwable {
        DeploymentUnit unit;
        List children = context.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            DeploymentContext child = (DeploymentContext)children.get(i);
            try {
                this.doInstallParentLast(deployer, child);
                continue;
            }
            catch (DeploymentException e) {
                for (int j = i - 1; j >= 0; --j) {
                    child = (DeploymentContext)children.get(j);
                    this.doUninstallParentFirst(deployer, child, true, true);
                }
                throw e;
            }
        }
        List components = context.getComponents();
        if (components != null) {
            try {
                for (int i = 0; i < components.size(); ++i) {
                    DeploymentContext component = (DeploymentContext)components.get(i);
                    try {
                        this.doInstallParentLast(deployer, component);
                        continue;
                    }
                    catch (DeploymentException e) {
                        for (int j = i - 1; j >= 0; --j) {
                            component = (DeploymentContext)components.get(j);
                            this.doUninstallParentFirst(deployer, component, true, true);
                        }
                        throw e;
                    }
                }
            }
            catch (DeploymentException e) {
                this.doUninstallParentFirst(deployer, context, false, false);
                throw e;
            }
        }
        if (this.isRelevant(deployer, unit = context.getDeploymentUnit(), context.isTopLevel(), context.isComponent())) {
            try {
                this.doDeploy(deployer, unit);
            }
            catch (DeploymentException e) {
                this.doUninstallParentFirst(deployer, context, false, true);
                context.setState(DeploymentState.ERROR);
                context.setProblem((Throwable)e);
                throw e;
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Deployer " + deployer + " not relevant for " + context.getName()));
        }
    }

    public void uninstall(ControllerContext context, ControllerState fromState, ControllerState toState) {
        DeploymentControllerContext deploymentControllerContext = (DeploymentControllerContext)context;
        String stageName = fromState.getStateString();
        DeploymentContext deploymentContext = deploymentControllerContext.getDeploymentContext();
        List<Deployer> theDeployers = this.getDeployersList(stageName);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deployers for " + stageName + " " + theDeployers));
        }
        if (!theDeployers.isEmpty()) {
            for (int i = theDeployers.size() - 1; i >= 0; --i) {
                Deployer deployer = theDeployers.get(i);
                if (deployer.isParentFirst()) {
                    this.doUninstallParentLast(deployer, deploymentContext, true, true);
                    continue;
                }
                this.doUninstallParentFirst(deployer, deploymentContext, true, true);
            }
        }
    }

    protected void doUninstallParentLast(Deployer deployer, DeploymentContext context, boolean doChildren, boolean doComponents) {
        DeploymentUnit unit;
        List components;
        int i;
        List children;
        if (doChildren && (children = context.getChildren()) != null && !children.isEmpty()) {
            for (i = children.size() - 1; i >= 0; --i) {
                DeploymentContext child = (DeploymentContext)children.get(i);
                this.doUninstallParentLast(deployer, child, true, true);
            }
        }
        if (doComponents && (components = context.getComponents()) != null && !components.isEmpty()) {
            for (i = components.size() - 1; i >= 0; --i) {
                DeploymentContext component = (DeploymentContext)components.get(i);
                this.doUninstallParentLast(deployer, component, false, true);
            }
        }
        if (this.isRelevant(deployer, unit = context.getDeploymentUnit(), context.isTopLevel(), context.isComponent())) {
            this.doUndeploy(deployer, unit);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Deployer " + deployer + " not relevant for " + context.getName()));
        }
    }

    protected void doUninstallParentFirst(Deployer deployer, DeploymentContext context, boolean doContext, boolean doComponents) {
        List children;
        int i;
        List components;
        if (doContext) {
            DeploymentUnit unit = context.getDeploymentUnit();
            if (this.isRelevant(deployer, unit, context.isTopLevel(), context.isComponent())) {
                this.doUndeploy(deployer, unit);
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("Deployer " + deployer + " not relevant for " + context.getName()));
            }
        }
        if (doComponents && (components = context.getComponents()) != null && !components.isEmpty()) {
            for (i = components.size() - 1; i >= 0; --i) {
                DeploymentContext component = (DeploymentContext)components.get(i);
                this.doUninstallParentFirst(deployer, component, true, true);
            }
        }
        if ((children = context.getChildren()) != null && !children.isEmpty()) {
            for (i = children.size() - 1; i >= 0; --i) {
                DeploymentContext child = (DeploymentContext)children.get(i);
                this.doUninstallParentFirst(deployer, child, true, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeploy(Deployer deployer, DeploymentUnit unit) throws DeploymentException {
        long time = 0L;
        boolean collectStats = this.collectStats;
        if (collectStats) {
            time = System.currentTimeMillis();
        }
        try {
            deployer.deploy(unit);
        }
        finally {
            if (collectStats && (time = System.currentTimeMillis() - time) > 0L) {
                DeployersImpl deployersImpl = this;
                synchronized (deployersImpl) {
                    if (this.deploymentTimes == null) {
                        this.deploymentTimes = new DeployerStatistics();
                    }
                    String deployerName = deployer.toString();
                    String deploymentName = unit.getName();
                    this.deploymentTimes.addStatistic(deployerName, deploymentName, time);
                }
            }
        }
    }

    protected void doUndeploy(Deployer deployer, DeploymentUnit unit) {
        deployer.undeploy(unit);
    }

    protected synchronized List<Deployer> getDeployersList(String stageName) {
        List<Deployer> deployers = this.deployersByStage.get(stageName);
        if (deployers == null || deployers.isEmpty()) {
            return Collections.emptyList();
        }
        return deployers;
    }

    protected boolean isRelevant(Deployer deployer, DeploymentUnit unit, boolean isTopLevel, boolean isComponent) {
        Class input;
        if (deployer.isTopLevelOnly() && !isTopLevel) {
            return false;
        }
        if (deployer.isComponentsOnly() && !isComponent) {
            return false;
        }
        if (!deployer.isWantComponents() && isComponent) {
            return false;
        }
        return deployer.isAllInputs() || (input = deployer.getInput()) == null || unit.getAttachment(input) != null;
    }

    protected List<Deployer> insert(List<Deployer> original, Deployer newDeployer) {
        DeployerSorter sorter = DeployerSorterFactory.newSorter();
        return sorter.sortDeployers(original, newDeployer);
    }

    private static void setState(DeploymentContext context, DeploymentState state, DeploymentState ifState) {
        List children;
        if (ifState == null || ifState.equals((Object)context.getState())) {
            context.setState(state);
        }
        if ((children = context.getChildren()) != null && !children.isEmpty()) {
            for (DeploymentContext child : children) {
                DeployersImpl.setState(child, state, ifState);
            }
        }
    }

    private static void removeClassLoader(DeploymentContext context) {
        context.removeClassLoader();
        List children = context.getChildren();
        if (children != null && !children.isEmpty()) {
            for (DeploymentContext child : children) {
                DeployersImpl.removeClassLoader(child);
            }
        }
    }

    private static void cleanup(DeploymentContext context) {
        List components;
        context.cleanup();
        List children = context.getChildren();
        if (children != null && !children.isEmpty()) {
            for (DeploymentContext child : children) {
                DeployersImpl.cleanup(child);
            }
        }
        if ((components = context.getComponents()) != null && !components.isEmpty()) {
            for (DeploymentContext component : components) {
                DeployersImpl.cleanup(component);
            }
        }
    }

    protected void registerMBean(DeploymentContext context) {
        if (this.server != null && this.isRegisterMBeans() && context instanceof DeploymentMBean) {
            try {
                DeploymentMBean depMBean = (DeploymentMBean)context;
                this.server.registerMBean(context, depMBean.getObjectName());
            }
            catch (Exception e) {
                log.warn((Object)("Unable to register deployment mbean " + context.getName()), (Throwable)e);
            }
        }
    }

    protected void unregisterMBean(DeploymentContext context) {
        if (this.server != null && this.isRegisterMBeans() && context instanceof DeploymentMBean) {
            try {
                DeploymentMBean depMBean = (DeploymentMBean)context;
                this.server.unregisterMBean(depMBean.getObjectName());
            }
            catch (Exception e) {
                log.trace((Object)("Unable to unregister deployment mbean " + context.getName()), (Throwable)e);
            }
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }
}

