/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.typegen;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.PropertyType;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.chromattic.common.xml.DocumentEmitter;
import org.chromattic.common.xml.ElementEmitter;
import org.chromattic.metamodel.bean.PropertyInfo;
import org.chromattic.metamodel.bean.SimpleValueInfo;
import org.chromattic.metamodel.mapping.BaseTypeMappingVisitor;
import org.chromattic.metamodel.mapping.NodeTypeMapping;
import org.chromattic.metamodel.mapping.jcr.JCRPropertyMapping;
import org.chromattic.metamodel.typegen.NodeDefinition;
import org.chromattic.metamodel.typegen.NodeType;
import org.chromattic.metamodel.typegen.PropertyDefinition;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.TypeInfo;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeBuilder
extends BaseTypeMappingVisitor {
    private final Map<ClassTypeInfo, NodeType> nodeTypes = new HashMap<ClassTypeInfo, NodeType>();
    private NodeType current;

    public NodeType getNodeType(ClassTypeInfo type) {
        return this.nodeTypes.get(type);
    }

    private NodeType resolve(NodeTypeMapping mapping) {
        NodeType nodeType = this.nodeTypes.get(mapping.getType());
        if (nodeType == null) {
            nodeType = new NodeType(mapping);
            this.nodeTypes.put(mapping.getType(), nodeType);
        }
        return nodeType;
    }

    @Override
    public void start() {
        this.nodeTypes.clear();
    }

    @Override
    protected void startMapping(NodeTypeMapping mapping) {
        this.current = this.resolve(mapping);
    }

    @Override
    protected <V> void propertyMapping(ClassTypeInfo definer, JCRPropertyMapping<V> propertyMapping, PropertyInfo<SimpleValueInfo<V>> propertyInfo) {
        if (definer.equals(this.current.mapping.getType())) {
            this.current.properties.put(propertyMapping.getName(), new PropertyDefinition(propertyMapping, propertyInfo));
        }
    }

    @Override
    protected void propertyMapMapping(ClassTypeInfo definer) {
        if (definer.equals(this.current.mapping.getType())) {
            this.current.properties.put("*", new PropertyDefinition("*", false, 0));
        }
    }

    @Override
    protected void oneToManyByReference(ClassTypeInfo definer, String relatedName, NodeTypeMapping relatedMapping) {
        if (definer.equals(this.current.mapping.getType())) {
            this.resolve((NodeTypeMapping)relatedMapping).properties.put(relatedName, new PropertyDefinition(relatedName, false, 9));
        }
    }

    @Override
    protected void oneToManyByPath(ClassTypeInfo definer, String relatedName, NodeTypeMapping relatedMapping) {
        if (definer.equals(this.current.mapping.getType())) {
            this.resolve((NodeTypeMapping)relatedMapping).properties.put(relatedName, new PropertyDefinition(relatedName, false, 8));
        }
    }

    @Override
    protected void oneToManyHierarchic(ClassTypeInfo definer, NodeTypeMapping relatedMapping) {
        if (definer.equals(this.current.mapping.getType())) {
            this.current.addChildNodeType("*", relatedMapping);
        }
    }

    @Override
    protected void manyToOneByReference(ClassTypeInfo definer, String name, NodeTypeMapping relatedType) {
        if (definer.equals(this.current.mapping.getType())) {
            this.current.properties.put(name, new PropertyDefinition(name, false, 9));
        }
    }

    @Override
    protected void manyToOneByPath(ClassTypeInfo definer, String name, NodeTypeMapping relatedMapping) {
        if (definer.equals(this.current.mapping.getType())) {
            this.current.properties.put(name, new PropertyDefinition(name, false, 8));
        }
    }

    @Override
    protected void manyToOneHierarchic(ClassTypeInfo definer, NodeTypeMapping relatedMapping) {
        if (definer.equals(this.current.mapping.getType())) {
            this.resolve(relatedMapping).addChildNodeType("*", this.current.mapping);
        }
    }

    @Override
    protected void oneToOneHierarchic(ClassTypeInfo definer, String name, NodeTypeMapping relatedMapping, boolean owner) {
        if (definer.equals(this.current.mapping.getType())) {
            if (owner) {
                this.current.addChildNodeType(name, relatedMapping);
            } else {
                this.resolve(relatedMapping).addChildNodeType(name, this.current.mapping);
            }
        }
    }

    @Override
    protected void endMapping() {
        this.current = null;
    }

    @Override
    public void end() {
        for (NodeType nodeType : this.nodeTypes.values()) {
            ClassTypeInfo cti = nodeType.mapping.getType();
            for (NodeType otherNodeType : this.nodeTypes.values()) {
                if (otherNodeType == nodeType || !cti.isSubType((TypeInfo)otherNodeType.mapping.getType())) continue;
                nodeType.superTypes.add(otherNodeType);
            }
        }
    }

    public void writeTo(Writer writer) throws IOException {
        try {
            SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler handler = factory.newTransformerHandler();
            handler.getTransformer().setOutputProperty("method", "xml");
            handler.getTransformer().setOutputProperty("encoding", "UTF-8");
            handler.getTransformer().setOutputProperty("indent", "yes");
            handler.getTransformer().setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            handler.setResult(new StreamResult(writer));
            this.writeTo(handler, handler);
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void writeTo(ContentHandler contentHandler, LexicalHandler lexicalHandler) throws SAXException {
        DocumentEmitter writer = new DocumentEmitter(contentHandler, lexicalHandler);
        writer.comment("Node type generation prototype");
        ElementEmitter nodeTypesWriter = writer.documentElement("nodeTypes");
        for (NodeType nodeType : this.nodeTypes.values()) {
            nodeTypesWriter.comment(" Node type generated for the class " + nodeType.mapping.getType().getName() + " ");
            ElementEmitter nodeTypeWriter = nodeTypesWriter.element("nodeType").withAttribute("name", nodeType.getName()).withAttribute("isMixin", Boolean.toString(nodeType.isMixin())).withAttribute("hasOrderableChildNodes", Boolean.toString(nodeType.isOrderable()));
            ElementEmitter superTypesWriter = nodeTypeWriter.element("supertypes");
            for (NodeType superType : nodeType.superTypes) {
                superTypesWriter.element("supertype").content(superType.getName());
            }
            superTypesWriter.element("supertype").content("mix:referenceable");
            ElementEmitter propertyDefinitionsWriter = nodeTypeWriter.element("propertyDefinitions");
            for (PropertyDefinition propertyDefinition : nodeType.getPropertyDefinitions().values()) {
                ElementEmitter propertyDefinitionWriter = propertyDefinitionsWriter.element("propertyDefinition").withAttribute("name", propertyDefinition.getName()).withAttribute("propertyType", PropertyType.nameFromValue((int)propertyDefinition.getType())).withAttribute("autoCreated", Boolean.FALSE.toString()).withAttribute("mandatory", Boolean.FALSE.toString()).withAttribute("onParentVersion", "COPY").withAttribute("protected", Boolean.FALSE.toString()).withAttribute("multiple", Boolean.toString(propertyDefinition.isMultiple()));
                propertyDefinitionWriter.element("valueConstraints");
                List<String> defaultValues = propertyDefinition.getDefaultValues();
                if (defaultValues == null) continue;
                ElementEmitter defaultValuesWriter = propertyDefinitionWriter.element("defaultValues");
                for (String s : defaultValues) {
                    defaultValuesWriter.element("defaultValue").content(s);
                }
            }
            ElementEmitter childNodeDefinitionsWriter = nodeTypeWriter.element("childNodeDefinitions");
            for (NodeDefinition childNodeDefinition : nodeType.getChildNodeDefinitions().values()) {
                childNodeDefinitionsWriter.element("childNodeDefinition").withAttribute("name", childNodeDefinition.getName()).withAttribute("defaultPrimaryType", "").withAttribute("autoCreated", "false").withAttribute("mandatory", "false").withAttribute("onParentVersion", "COPY").withAttribute("protected", "false").withAttribute("sameNameSiblings", "false").element("requiredPrimaryTypes").element("requiredPrimaryType").content(childNodeDefinition.getNodeTypeName());
            }
        }
        writer.close();
    }
}

