/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.ArrayList;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;

public class NewMembershipListener
extends MembershipEventListener {
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private RepositoryService reposervice_;

    public NewMembershipListener(NodeHierarchyCreator nodeHierarchyCreator, RepositoryService rservice) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.reposervice_ = rservice;
    }

    public void postSave(Membership m, boolean isNew) throws Exception {
        String username = m.getUserName();
        String groupId = m.getGroupId();
        JCRDataStorage storage_ = new JCRDataStorage(this.nodeHierarchyCreator_, this.reposervice_);
        ArrayList<String> group = new ArrayList<String>();
        group.add(groupId);
        storage_.autoShareCalendar(group, username);
    }

    public void preDelete(Membership m) throws Exception {
        String username = m.getUserName();
        String groupId = m.getGroupId();
        JCRDataStorage storage_ = new JCRDataStorage(this.nodeHierarchyCreator_, this.reposervice_);
        storage_.autoRemoveShareCalendar(groupId, username);
    }
}

