/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.services.organization.UserProfile;
import org.gatein.common.util.Tools;
import org.gatein.pc.api.invocation.resolver.AttributeResolver;
import org.gatein.pc.api.invocation.resolver.PrincipalAttributeResolver;
import org.gatein.pc.api.spi.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExoUserContext
implements UserContext {
    private static final Map<String, String> EMPTY_STRING_TO_STRING_MAP = Collections.emptyMap();
    private static final List<Locale> EMPTY_LOCALE_LIST = Collections.emptyList();
    private final String id;
    private final HttpServletRequest clientRequest;
    private final AttributeResolver attributeResolver;
    private final UserProfile userProfile;
    private static final Set<String> JSR_168_P3P;

    public ExoUserContext(HttpServletRequest clientRequest, UserProfile userProfile) throws IllegalArgumentException {
        if (clientRequest == null) {
            throw new IllegalArgumentException("No client request provided");
        }
        this.id = clientRequest.getRemoteUser();
        this.clientRequest = clientRequest;
        this.attributeResolver = new PrincipalAttributeResolver(clientRequest);
        this.userProfile = userProfile;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getInformations() {
        if (this.userProfile == null) {
            return EMPTY_STRING_TO_STRING_MAP;
        }
        Map infoMap = this.userProfile.getUserInfoMap();
        HashMap filteredMap = new HashMap();
        for (String key : infoMap.keySet()) {
            if (!JSR_168_P3P.contains(key)) continue;
            filteredMap.put(key, infoMap.get(key));
        }
        return Collections.unmodifiableMap(filteredMap);
    }

    public Locale getLocale() {
        return this.clientRequest != null ? this.clientRequest.getLocale() : Locale.ENGLISH;
    }

    public List<Locale> getLocales() {
        if (this.clientRequest == null) {
            return EMPTY_LOCALE_LIST;
        }
        return Tools.toList((Enumeration)this.clientRequest.getLocales());
    }

    public void setAttribute(String attrKey, Object attrValue) {
        this.attributeResolver.setAttribute((Object)attrKey, attrValue);
    }

    public Object getAttribute(String attrKey) {
        return this.attributeResolver.getAttribute((Object)attrKey);
    }

    static {
        HashSet<String> keys = new HashSet<String>();
        for (PortletRequest.P3PUserInfos userInfos : PortletRequest.P3PUserInfos.values()) {
            keys.add(userInfos.toString());
        }
        JSR_168_P3P = Collections.unmodifiableSet(keys);
    }
}

