/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.web;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;

public abstract class AbstractHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = -3302886470677004895L;
    protected ServletConfig config;
    protected String servletContextName;
    private volatile Boolean requirePortalEnvironment;

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        this.servletContextName = config.getServletContext().getServletContextName();
        this.afterInit(config);
    }

    protected void afterInit(ServletConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        ExoContainer container = null;
        boolean hasBeenSet = false;
        try {
            container = this.getContainer();
            if (!container.equals(oldContainer)) {
                if (container instanceof PortalContainer) {
                    PortalContainer.setInstance((PortalContainer)container);
                }
                ExoContainerContext.setCurrentContainer(container);
                hasBeenSet = true;
            }
            if (this.requirePortalEnvironment() && container instanceof PortalContainer) {
                if (PortalContainer.getInstanceIfPresent() == null) {
                    PortalContainer.setInstance((PortalContainer)container);
                    hasBeenSet = true;
                }
                Thread.currentThread().setContextClassLoader(((PortalContainer)container).getPortalClassLoader());
            }
            this.onService(container, req, res);
        }
        finally {
            if (hasBeenSet) {
                if (container instanceof PortalContainer) {
                    PortalContainer.setInstance(null);
                }
                ExoContainerContext.setCurrentContainer(oldContainer);
            }
            if (this.requirePortalEnvironment()) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean requirePortalEnvironment() {
        if (this.requirePortalEnvironment == null) {
            AbstractHttpServlet abstractHttpServlet = this;
            synchronized (abstractHttpServlet) {
                if (this.requirePortalEnvironment == null) {
                    this.requirePortalEnvironment = PortalContainer.isPortalContainerName(this.servletContextName);
                }
            }
        }
        return this.requirePortalEnvironment;
    }

    protected void onService(ExoContainer container, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }

    protected final ExoContainer getContainer() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer && (container = PortalContainer.getCurrentInstance(this.config.getServletContext())) == null) {
            container = ExoContainerContext.getTopContainer();
        }
        return container;
    }

    public ServletContext getServletContext() {
        ExoContainer container;
        if (this.requirePortalEnvironment() && (container = this.getContainer()) instanceof PortalContainer) {
            return ((PortalContainer)container).getPortalContext();
        }
        return super.getServletContext();
    }
}

